/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class OrnamentBlock
extends ChristmasBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.field_208158_K;
    public static final AbstractBlock.Properties BLOCK_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).harvestLevel(-1).func_200943_b(0.1f).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_200942_a();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200916_a(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    public VoxelShape[] normalShape;
    public VoxelShape[] hangingShape;
    public VoxelShape[] wallShape;

    public OrnamentBlock(VoxelShape[][] ornamentShapes) {
        super(BLOCK_PROPERTIES);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(ATTACH_FACE, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.normalShape = ornamentShapes[0];
        this.hangingShape = ornamentShapes[1];
        this.wallShape = ornamentShapes[2];
    }

    @Override
    public void configureBlock() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing;
        AttachFace attachFace;
        Direction clickedFaceDirection = context.func_196000_l();
        Direction.Axis clickedFaceAxis = clickedFaceDirection.func_176740_k();
        BlockPos blockPos = context.func_195995_a();
        World world = context.func_195991_k();
        if (clickedFaceAxis == Direction.Axis.Y) {
            attachFace = clickedFaceDirection == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING;
            facing = context.func_195992_f().func_176734_d();
        } else {
            attachFace = AttachFace.WALL;
            facing = clickedFaceDirection;
        }
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isWaterlogged = fluidstate.func_206886_c() == Fluids.field_204546_a;
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a(ATTACH_FACE, (Comparable)attachFace)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        return this.func_196260_a(blockState, (IWorldReader)world, blockPos) ? blockState : null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.func_206894_a(new Property[]{ATTACH_FACE, FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, ISelectionContext context) {
        Direction direction = (Direction)blockState.func_177229_b((Property)FACING);
        AttachFace attachFace = (AttachFace)blockState.func_177229_b(ATTACH_FACE);
        VoxelShape[] resultShapes = null;
        resultShapes = attachFace == AttachFace.FLOOR ? Arrays.copyOf(this.normalShape, this.normalShape.length) : (attachFace == AttachFace.CEILING ? Arrays.copyOf(this.hangingShape, this.hangingShape.length) : Arrays.copyOf(this.wallShape, this.wallShape.length));
        if (direction == Direction.SOUTH) {
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.NORTH) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_180);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.WEST) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_90);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        for (int i = 0; i < resultShapes.length; ++i) {
            resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.COUNTERCLOCKWISE_90);
        }
        return HappyHolidaysUtils.combineShapes(resultShapes);
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState1, IWorld world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos1, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return this.func_196260_a(blockState, (IWorldReader)world, pos1) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos position) {
        boolean canSupportCentre;
        Direction facingDirection = (Direction)blockState.func_177229_b((Property)FACING);
        AttachFace attachFace = (AttachFace)blockState.func_177229_b(ATTACH_FACE);
        Direction connectedDirection = facingDirection.func_176734_d();
        boolean bl = attachFace == AttachFace.FLOOR ? Block.func_220055_a((IWorldReader)world, (BlockPos)position.func_177972_a(Direction.DOWN), (Direction)Direction.UP) : (canSupportCentre = attachFace == AttachFace.CEILING ? Block.func_220055_a((IWorldReader)world, (BlockPos)position.func_177972_a(Direction.UP), (Direction)Direction.DOWN) : Block.func_220055_a((IWorldReader)world, (BlockPos)position.func_177972_a(connectedDirection), (Direction)connectedDirection.func_176734_d()));
        BlockState onBlockState = facingDirection == Direction.NORTH ? world.func_180495_p(position.func_177968_d()) : (facingDirection == Direction.SOUTH ? world.func_180495_p(position.func_177978_c()) : (facingDirection == Direction.EAST ? world.func_180495_p(position.func_177976_e()) : (facingDirection == Direction.WEST ? world.func_180495_p(position.func_177974_f()) : null)));
        boolean canSupportHanging = onBlockState != null && onBlockState.func_224755_d((IBlockReader)world, position, facingDirection);
        boolean isLeaves = onBlockState != null && onBlockState.func_235714_a_((ITag)BlockTags.field_206952_E);
        return canSupportCentre || canSupportHanging || isLeaves;
    }
}

