/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc;

import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc.WallDecorationBlock;
import com.jumpcutfindo.happyholidays.common.events.christmas.StockingEvent;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTileEntities;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.StockingTileEntity;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StockingBlock
extends WallDecorationBlock {
    public static final String RED_STOCKING_ID = "red_stocking";
    public static final String BLUE_STOCKING_ID = "blue_stocking";
    public static final String YELLOW_STOCKING_ID = "yellow_stocking";
    public static final String GREEN_STOCKING_ID = "green_stocking";
    public static final String GOLD_STOCKING_ID = "gold_stocking";
    public static final String SILVER_STOCKING_ID = "silver_stocking";
    public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");
    public static final AbstractBlock.Properties BLOCK_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).harvestLevel(-1).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g).func_226896_b_().func_200942_a();
    public static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5);

    public StockingBlock() {
        super(BLOCK_PROPERTIES, SHAPE);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateBuilder) {
        super.func_206840_a(stateBuilder);
        stateBuilder.func_206894_a(new Property[]{FILLED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState1, IWorld world, BlockPos pos1, BlockPos pos2) {
        return this.func_196260_a(blockState, (IWorldReader)world, pos1) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!world.func_201670_d() && tileEntity instanceof StockingTileEntity) {
            StockingTileEntity stockingTileEntity = (StockingTileEntity)tileEntity;
            if (!stockingTileEntity.isEmpty()) {
                stockingTileEntity.dropStockingItems();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ChristmasTileEntities.STOCKING_ENTITY_TYPE.get()).func_200968_a();
    }

    public boolean func_149653_t(BlockState blockState) {
        return true;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld world, BlockPos blockPos, Random random) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof StockingTileEntity) {
            int randInt;
            StockingTileEntity stockingTileEntity = (StockingTileEntity)tileEntity;
            if (world.func_226690_K_() && !stockingTileEntity.isDoneForNight() && stockingTileEntity.isEmpty() && (randInt = random.nextInt(100)) < StockingBlock.getFillChance((World)world, blockPos)) {
                stockingTileEntity.fillStocking();
                AxisAlignedBB searchBox = new AxisAlignedBB(blockPos).func_186662_g(4.0);
                List playersAround = world.func_217357_a(PlayerEntity.class, searchBox);
                for (PlayerEntity playerEntity : playersAround) {
                    StockingEvent.Fill fillEvent = new StockingEvent.Fill(blockState, blockPos, playerEntity);
                    MinecraftForge.EVENT_BUS.post((Event)fillEvent);
                }
            }
            if (world.func_72935_r() && stockingTileEntity.isDoneForNight()) {
                stockingTileEntity.resetStocking();
            }
        }
    }

    public static int getFillChance(World world, BlockPos blockPos) {
        int chance = 0;
        int baseChance = 10;
        chance += baseChance;
        boolean isCookiesNear = HappyHolidaysUtils.findBlockInRadius((IWorld)world, blockPos, (Block)ChristmasBlocks.MILK_AND_COOKIES.get(), 5) != null;
        return chance += isCookiesNear ? 20 : 0;
    }
}

