/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.food;

import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.Arrays;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class ChristmasFoodBlock
extends ChristmasBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private VoxelShape[] shape;
    private final int nutrition;
    private final float saturation;

    public ChristmasFoodBlock(AbstractBlock.Properties properties, VoxelShape[] shape, int nutrition, float saturation) {
        super(properties);
        this.shape = shape;
        this.nutrition = nutrition;
        this.saturation = saturation;
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState1, IWorld world, BlockPos pos1, BlockPos pos2) {
        return this.func_196260_a(blockState, (IWorldReader)world, pos1) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, ISelectionContext context) {
        Direction direction = (Direction)blockState.func_177229_b((Property)FACING);
        VoxelShape[] resultShapes = Arrays.copyOf(this.shape, this.shape.length);
        if (direction == Direction.SOUTH) {
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.NORTH) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_180);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.WEST) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_90);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        for (int i = 0; i < resultShapes.length; ++i) {
            resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.COUNTERCLOCKWISE_90);
        }
        return HappyHolidaysUtils.combineShapes(resultShapes);
    }

    @Override
    public void configureBlock() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos position) {
        return world.func_180495_p(position.func_177977_b()).func_185904_a().func_76220_a();
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public static boolean isChristmasFoodBlock(Block block) {
        return block instanceof ChristmasFoodBlock;
    }
}

