/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.presents;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.presents.BabyPresentBlock;
import com.jumpcutfindo.happyholidays.common.entity.christmas.grinch.GrinchEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class PresentBlock
extends ChristmasBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final AbstractBlock.Properties BLOCK_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).harvestLevel(-1).func_200943_b(0.25f).func_200947_a(SoundType.field_185854_g).func_200944_c();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200917_a(64).func_200916_a(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    public static final float GROWTH_PROBABILITY = 0.015625f;
    private VoxelShape shape;

    public PresentBlock(String blockId, VoxelShape shape) {
        super(BLOCK_PROPERTIES);
        this.shape = shape;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{WATERLOGGED});
    }

    @Override
    public void configureBlock() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, ISelectionContext context) {
        return this.shape;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    }

    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return this.shape;
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState1, IWorld world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos1, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return this.func_196260_a(blockState, (IWorldReader)world, pos1) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isWaterlogged = fluidstate.func_206886_c() == Fluids.field_204546_a;
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        return this.func_196260_a(blockState, (IWorldReader)context.func_195991_k(), context.func_195995_a()) ? blockState : null;
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos position) {
        return PresentBlock.func_220055_a((IWorldReader)world, (BlockPos)position.func_177972_a(Direction.DOWN), (Direction)Direction.UP);
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    public float getGrowthProbability(World world, BlockPos pos) {
        ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingBlock(world, pos);
        if (starTileEntity == null) {
            return 0.015625f;
        }
        return 0.015625f + 0.015625f * (float)starTileEntity.getCurrentTier() * 0.2f;
    }

    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        playerEntity.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        playerEntity.func_71020_j(0.005f);
        if (!world.func_201670_d()) {
            LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockPos)).func_216015_a(LootParameters.field_216289_i, (Object)playerEntity.func_184614_ca()).func_216021_b(LootParameters.field_216288_h, (Object)tileEntity);
            List<ItemStack> drops = this.getCustomDrops(blockState, blockPos, lootContextBuilder);
            for (ItemStack drop : drops) {
                PresentBlock.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)drop);
            }
            blockState.func_215706_a((ServerWorld)world, blockPos, itemStack);
        }
    }

    public List<ItemStack> getCustomDrops(BlockState blockState, BlockPos blockPos, LootContext.Builder builder) {
        ResourceLocation resourceLocation = this.func_220068_i();
        if (resourceLocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootContext = builder.func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverWorld = lootContext.func_202879_g();
        LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(resourceLocation);
        ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingBlock((World)serverWorld, blockPos);
        List drops = lootTable.func_216113_a(lootContext);
        for (ItemStack drop : drops) {
            if (!ChristmasItems.isBasicOrnamentItem(drop)) continue;
            if (blockState.func_203425_a((Block)ChristmasBlocks.BABY_PRESENT.get())) {
                drop.func_190920_e(this.RANDOM.nextInt(1) + 1 + 1);
                continue;
            }
            if (blockState.func_203425_a((Block)ChristmasBlocks.ADULT_PRESENT.get())) {
                drop.func_190920_e(this.RANDOM.nextInt(2) + 1 + 2);
                continue;
            }
            drop.func_190920_e(this.RANDOM.nextInt(2) + 1 + 3);
        }
        if (starTileEntity != null && starTileEntity.isBonusActive()) {
            for (ItemStack drop : drops) {
                if (ItemStack.func_179545_c((ItemStack)drop, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).func_190903_i()) || ChristmasItems.isPresentItem(drop)) continue;
                drop.func_190920_e(drop.func_190916_E() * 2);
            }
        }
        return drops;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        super.func_225542_b_(blockState, serverWorld, blockPos, random);
        if (PresentBlock.isGrowable(blockState)) {
            boolean isGrow;
            boolean bl = PresentBlock.canGrow((IWorld)serverWorld, blockState, blockPos) && ForgeHooks.onCropsGrowPre((World)serverWorld, (BlockPos)blockPos, (BlockState)blockState, (random.nextInt((int)(1.0 / (double)this.getGrowthProbability((World)serverWorld, blockPos))) == 0 ? 1 : 0) != 0) ? true : (isGrow = false);
            if (isGrow) {
                PresentBlock.grow(blockState, serverWorld, blockPos, random);
            }
        }
        if (GrinchEntity.canSpawnInArea(blockPos, serverWorld)) {
            GrinchEntity.spawnGrinchAround(blockPos, serverWorld, random);
        }
    }

    public static void grow(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        BlockState nextBlockState = blockState.func_177230_c() instanceof BabyPresentBlock ? ((ChristmasBlock)ChristmasBlocks.ADULT_PRESENT.get()).func_176223_P() : ((ChristmasBlock)ChristmasBlocks.ELDER_PRESENT.get()).func_176223_P();
        serverWorld.func_180501_a(blockPos, nextBlockState, 2);
        serverWorld.func_184148_a(null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 1.0f, 1.0f);
        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197613_f, (double)blockPos.func_177958_n() + random.nextDouble(), (double)blockPos.func_177956_o() + random.nextDouble(), (double)blockPos.func_177952_p() + random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        ForgeHooks.onCropsGrowPost((World)serverWorld, (BlockPos)blockPos, (BlockState)blockState);
    }

    public static boolean canGrow(IWorld world, BlockState blockState, BlockPos blockPos) {
        return !world.func_180495_p(blockPos.func_177984_a()).func_235714_a_((ITag)BlockTags.field_206952_E) && !blockState.func_224755_d((IBlockReader)world, blockPos, Direction.UP);
    }

    public static boolean isGrowable(BlockState blockState) {
        return blockState.func_203425_a((Block)ChristmasBlocks.BABY_PRESENT.get()) || blockState.func_203425_a((Block)ChristmasBlocks.ADULT_PRESENT.get());
    }
}

