/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.container.christmas.gifts;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.container.christmas.gifts.GiftWrapperResultSlot;
import com.jumpcutfindo.happyholidays.common.item.christmas.gifts.ChristmasGiftItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasContainers;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.GiftWrapperTileEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GiftWrapperContainer
extends Container {
    public static final String CONTAINER_ID = "gift_wrapping_station";
    public final GiftWrapperTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;
    private final PlayerInventory playerInv;
    public Slot stringSlot;
    public Slot paperSlot;
    public Slot dyeSlot;
    public Slot resultSlot;
    public List<Slot> giftItemSlots;

    public GiftWrapperContainer(int windowId, PlayerInventory playerInv, GiftWrapperTileEntity tileEntity) {
        super((ContainerType)ChristmasContainers.GIFT_WRAPPER_CONTAINER.get(), windowId);
        this.tileEntity = tileEntity;
        this.playerInv = playerInv;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.stringSlot = this.func_75146_a(new Slot((IInventory)tileEntity, 0, 16, 16));
        this.paperSlot = this.func_75146_a(new Slot((IInventory)tileEntity, 1, 16, 41));
        this.dyeSlot = this.func_75146_a(new Slot((IInventory)tileEntity, 2, 16, 66));
        this.giftItemSlots = Lists.newArrayList();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.giftItemSlots.add(this.func_75146_a(new Slot((IInventory)tileEntity, 3 + i * 3 + j, 51 + j * 18, 32 + i * 18)));
            }
        }
        this.resultSlot = this.func_75146_a(new GiftWrapperResultSlot((IInventory)tileEntity, 9, 140, 40));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInv, col + row * 9 + 9, 8 + col * 18, 189 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInv, col, 8 + col * 18, 165));
        }
    }

    public GiftWrapperContainer(int windowId, PlayerInventory playerInv, PacketBuffer data) {
        this(windowId, playerInv, GiftWrapperContainer.getTileEntity(playerInv, data));
    }

    public void func_75134_a(PlayerEntity p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        this.playerInv.func_174886_c(p_75134_1_);
    }

    public static void handleSlotsChanged(int containerId, World world, PlayerEntity playerEntity, IInventory playerInv, IInventory giftWrapperInv) {
        if (!world.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerEntity;
            ItemStack itemStack = ItemStack.field_190927_a;
            if (GiftWrapperContainer.checkAllItemsPresent(giftWrapperInv)) {
                itemStack = GiftWrapperTileEntity.assembleGift(playerEntity, giftWrapperInv);
            }
            giftWrapperInv.func_70299_a(9, itemStack);
            giftWrapperInv.func_70296_d();
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(containerId, 9, itemStack));
        }
    }

    public static boolean checkAllItemsPresent(IInventory giftWrapperInv) {
        ItemStack stringItems = giftWrapperInv.func_70301_a(0);
        ItemStack paperItems = giftWrapperInv.func_70301_a(1);
        ItemStack dyeItems = giftWrapperInv.func_70301_a(2);
        if (ItemStack.func_179545_c((ItemStack)stringItems, (ItemStack)Items.field_151007_F.func_190903_i()) && stringItems.func_190916_E() >= 2 && ItemStack.func_179545_c((ItemStack)paperItems, (ItemStack)Items.field_151121_aF.func_190903_i()) && paperItems.func_190916_E() >= 4 && GiftWrapperTileEntity.isValidColourModifier(dyeItems)) {
            for (int i = 3; i <= 8; ++i) {
                if (giftWrapperInv.func_70301_a(i).func_190926_b() || giftWrapperInv.func_70301_a(i).func_77973_b() instanceof ChristmasGiftItem) continue;
                return true;
            }
        }
        return false;
    }

    public void func_75130_a(IInventory inventory) {
        this.canInteractWithCallable.func_221486_a((world, blockPos) -> GiftWrapperContainer.handleSlotsChanged(this.field_75152_c, world, this.playerInv.field_70458_d, (IInventory)this.playerInv, (IInventory)this.tileEntity));
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return this.playerInv.func_70300_a(playerEntity);
    }

    private static GiftWrapperTileEntity getTileEntity(PlayerInventory playerInv, PacketBuffer data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "Packet buffer cannot be null");
        TileEntity te = playerInv.field_70458_d.func_130014_f_().func_175625_s(data.func_179259_c());
        if (te instanceof GiftWrapperTileEntity) {
            return (GiftWrapperTileEntity)te;
        }
        throw new IllegalStateException("Incorrect tile entity!");
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int selectedSlot) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(selectedSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemStack = itemStack1.func_77946_l();
            if (slot.equals(this.stringSlot) || slot.equals(this.paperSlot) || slot.equals(this.dyeSlot) || this.giftItemSlots.contains(slot) || slot.equals(this.resultSlot) ? !this.func_75135_a(itemStack1, 10, 46, false) : (ItemStack.func_179545_c((ItemStack)itemStack1, (ItemStack)Items.field_151007_F.func_190903_i()) ? !this.func_75135_a(itemStack1, this.stringSlot.getSlotIndex(), this.stringSlot.getSlotIndex() + 1, false) : (ItemStack.func_179545_c((ItemStack)itemStack1, (ItemStack)Items.field_151121_aF.func_190903_i()) ? !this.func_75135_a(itemStack1, this.paperSlot.getSlotIndex(), this.paperSlot.getSlotIndex() + 1, false) : (GiftWrapperTileEntity.isValidColourModifier(itemStack) ? !this.func_75135_a(itemStack1, this.dyeSlot.getSlotIndex(), this.dyeSlot.getSlotIndex() + 1, false) : !this.func_75135_a(itemStack1, 3, 3 + this.giftItemSlots.size(), false))))) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack1.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, itemStack1);
        }
        return ItemStack.field_190927_a;
    }
}

