/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.container.christmas.star;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarBonusSlot;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarSlot;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasContainers;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChristmasStarContainer
extends Container {
    public static final String CONTAINER_ID = "christmas_star";
    public final ChristmasStarTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;
    private final IInventory container;
    private final IIntArray data;
    private List<Slot> ornamentSlots;
    private Slot bonusSlot;

    public ChristmasStarContainer(int windowId, PlayerInventory playerInv, ChristmasStarTileEntity tileEntity) {
        super((ContainerType)ChristmasContainers.CHRISTMAS_STAR_CONTAINER.get(), windowId);
        this.tileEntity = tileEntity;
        this.container = playerInv;
        this.data = tileEntity.dataAccess;
        this.func_216961_a(this.tileEntity.dataAccess);
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.ornamentSlots = Lists.newArrayList((Object[])new Slot[]{this.func_75146_a(new ChristmasStarSlot(tileEntity, 0, 80, 15)), this.func_75146_a(new ChristmasStarSlot(tileEntity, 1, 48, 43)), this.func_75146_a(new ChristmasStarSlot(tileEntity, 2, 112, 43)), this.func_75146_a(new ChristmasStarSlot(tileEntity, 3, 58, 77)), this.func_75146_a(new ChristmasStarSlot(tileEntity, 4, 102, 77))});
        this.bonusSlot = this.func_75146_a(new ChristmasStarBonusSlot(tileEntity, 5, 152, 77));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInv, col + row * 9 + 9, 8 + col * 18, 190 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInv, col, 8 + col * 18, 166));
        }
    }

    public ChristmasStarContainer(int windowId, PlayerInventory playerInv, PacketBuffer data) {
        this(windowId, playerInv, ChristmasStarContainer.getTileEntity(playerInv, data));
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int selectedSlot) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(selectedSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            for (Slot ornamentSlot : this.ornamentSlots) {
                if (!slot.equals(ornamentSlot) || this.func_75135_a(itemstack1, 6, 42, false)) continue;
                return ItemStack.field_190927_a;
            }
            if (slot.equals(this.bonusSlot) && !this.func_75135_a(itemstack1, 6, 42, false)) {
                return ItemStack.field_190927_a;
            }
            if (ChristmasItems.isOrnamentItem(itemstack1) && !this.func_75135_a(itemstack1, this.ornamentSlots.get(0).getSlotIndex(), this.ornamentSlots.get(this.ornamentSlots.size() - 1).getSlotIndex() + 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).func_190903_i()) && !this.func_75135_a(itemstack1, this.bonusSlot.getSlotIndex(), this.bonusSlot.getSlotIndex() + 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        this.container.func_174886_c(p_75134_1_);
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return this.container.func_70300_a(playerEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentPoints() {
        return this.data.func_221476_a(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentTier() {
        return this.data.func_221476_a(0);
    }

    public ChristmasStarTileEntity getTileEntity() {
        return this.tileEntity;
    }

    private static ChristmasStarTileEntity getTileEntity(PlayerInventory playerInv, PacketBuffer data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "Packet buffer cannot be null");
        TileEntity te = playerInv.field_70458_d.func_130014_f_().func_175625_s(data.func_179259_c());
        if (te instanceof ChristmasStarTileEntity) {
            return (ChristmasStarTileEntity)te;
        }
        throw new IllegalStateException("Incorrect tile entity!");
    }
}

