/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequest;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequests;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfTrades;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SantaElfEntity
extends ChristmasEntity
implements IAnimatable,
IMerchant {
    public static final String ENTITY_ID = "santa_elf";
    public static final AttributeModifierMap ENTITY_ATTRIBUTES = MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.27).func_233813_a_();
    public static final float ENTITY_BOX_SIZE = 0.8f;
    public static final float ENTITY_BOX_HEIGHT = 1.375f;
    public static final int DEFAULT_DESPAWN_DELAY = 24000;
    private static final ResourceLocation SANTA_ELF_REQUEST_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_elf_request");
    private static final double REQUEST_ORNAMENT_DROP_BASE_CHANCE = 0.2;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @Nullable
    private PlayerEntity tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    private int despawnDelay = 24000;
    private SantaElfRequest santaElfRequest;
    private int santaElfRequestOfferIndex = -1;
    private int requestItemCooldown = 0;
    private int requestPaperCooldown = 0;
    private boolean isRewardThrown = false;
    private boolean isRequestOutdated = false;
    private int timeToCompleteRequest;

    public SantaElfEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
        if (this.santaElfRequest == null) {
            this.santaElfRequest = SantaElfRequests.createRandomRequest(this.field_70170_p.func_82737_E());
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new TradeWithPlayerGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PickupRequestedItemGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwapToyPartsRequestGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtCustomerGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_PASSIVE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_HURT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        if (this.func_213706_dY().isEmpty()) {
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.field_70170_p.field_72995_K) {
            EffectInstance christmasDebuff = this.func_70660_b((Effect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get());
            if (christmasDebuff != null) {
                ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingEntity(this.field_70170_p, this.func_213303_ch());
                double discount = starTileEntity != null && starTileEntity.isBonusActive() ? 0.8 : 0.1 * (double)(christmasDebuff.func_76458_c() + 1);
                for (MerchantOffer merchantOffer : this.offers) {
                    merchantOffer.func_222209_b(0);
                    int j = (int)Math.floor(discount * (double)merchantOffer.func_222218_a().func_190916_E());
                    merchantOffer.func_222207_a(-Math.max(j, 1));
                }
            }
            this.func_70932_a_(playerEntity);
            this.func_213707_a(playerEntity, this.func_145748_c_(), 1);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public void func_70932_a_(@Nullable PlayerEntity playerEntity) {
        this.tradingPlayer = playerEntity;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.tradingPlayer;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void func_213703_a(@Nullable MerchantOffers merchantOffers) {
    }

    public void func_213704_a(MerchantOffer merchantOffer) {
        merchantOffer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.rewardTradeXp(merchantOffer);
        if (this.func_70931_l_() != null) {
            SantaElfEvent.Trade tradeEvent = new SantaElfEvent.Trade(this.func_70931_l_(), this);
            MinecraftForge.EVENT_BUS.post((Event)tradeEvent);
        }
    }

    public void func_110297_a_(ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getTradeUpdatedSound(!itemStack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public SoundEvent func_213714_ea() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_YES.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean b) {
        return b ? (SoundEvent)ChristmasSounds.SANTA_ELF_YES.get() : (SoundEvent)ChristmasSounds.SANTA_ELF_NO.get();
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int i) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    protected void updateTrades() {
        int randInt;
        MerchantOffer merchantOffer;
        MerchantOffer merchantOffer2;
        int randInt2;
        int i;
        MerchantOffers merchantOffers = this.func_213706_dY();
        ImmutableList tradesList = ImmutableList.of((Object)SantaElfTrades.SMALL_BALL_ORNAMENT_TRADES, (Object)SantaElfTrades.BIG_BALL_ORNAMENT_TRADES, (Object)SantaElfTrades.TINSEL_TRADES, (Object)SantaElfTrades.CHRISTMAS_LIGHT_TRADES);
        for (VillagerTrades.ITrade[] trades : tradesList) {
            for (i = 0; i < 1; ++i) {
                randInt2 = this.field_70146_Z.nextInt(trades.length);
                VillagerTrades.ITrade randomTrade = trades[randInt2];
                merchantOffer2 = randomTrade.func_221182_a((Entity)this, this.field_70146_Z);
                if (merchantOffer2 == null) continue;
                merchantOffers.add((Object)merchantOffer2);
            }
        }
        ImmutableList rareTradesList = ImmutableList.of((Object)SantaElfTrades.HEAD_ORNAMENT_TRADES, (Object)SantaElfTrades.SHEET_MUSIC_TRADES);
        int rareTradeRandInt = this.field_70146_Z.nextInt(rareTradesList.size());
        if (rareTradeRandInt == 0) {
            int randInt3 = this.field_70146_Z.nextInt(rareTradesList.size());
            MerchantOffer merchantOffer3 = ((VillagerTrades.ITrade[])rareTradesList.get(0))[randInt3].func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantOffer3 != null) {
                merchantOffers.add((Object)merchantOffer3);
            }
        } else if (rareTradeRandInt == 1) {
            for (i = 0; i < 2; ++i) {
                randInt2 = this.field_70146_Z.nextInt(((VillagerTrades.ITrade[])rareTradesList.get(1)).length);
                merchantOffer = ((VillagerTrades.ITrade[])rareTradesList.get(1))[randInt2].func_221182_a((Entity)this, this.field_70146_Z);
                if (merchantOffer == null) continue;
                merchantOffers.add((Object)merchantOffer);
            }
        }
        for (i = 0; i < 2; ++i) {
            int randInt4 = this.field_70146_Z.nextInt(SantaElfTrades.FOOD_TRADES.length);
            merchantOffer = SantaElfTrades.FOOD_TRADES[randInt4].func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
        }
        ItemsForEmeraldsTrade santaElfRequestTrade = new ItemsForEmeraldsTrade(this.santaElfRequest.getRequestPaper(), 1, 1, 1, 2);
        MerchantOffer santaElfRequestOffer = santaElfRequestTrade.func_221182_a((Entity)this, this.field_70146_Z);
        if (santaElfRequestOffer != null) {
            merchantOffers.add((Object)santaElfRequestOffer);
        }
        this.santaElfRequestOfferIndex = merchantOffers.indexOf((Object)santaElfRequestOffer);
        if (this.field_70146_Z.nextBoolean() && (merchantOffer2 = SantaElfTrades.SOMETIMES_APPEAR_TRADES[randInt = this.field_70146_Z.nextInt(SantaElfTrades.SOMETIMES_APPEAR_TRADES.length)].func_221182_a((Entity)this, this.field_70146_Z)) != null) {
            merchantOffers.add((Object)merchantOffer2);
        }
        for (int i2 = 0; i2 < SantaElfTrades.ALWAYS_APPEAR_TRADES.length; ++i2) {
            merchantOffer2 = SantaElfTrades.ALWAYS_APPEAR_TRADES[i2].func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantOffer2 == null) continue;
            merchantOffers.add((Object)merchantOffer2);
        }
    }

    public SantaElfRequest getRequest() {
        return this.santaElfRequest;
    }

    public void handleRequestItemOnGround(ItemEntity itemEntity) {
        SantaElfRequest.SingleElfRequest completedRequest = this.getRequest().tryFulfilRequest(itemEntity.func_92059_d());
        if (completedRequest != null) {
            this.pickUpSomeItems(itemEntity, completedRequest.getNumberOfItems());
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ChristmasSounds.SANTA_ELF_REQUEST_SINGLE_SUCCESS.get(), SoundCategory.VOICE, 1.0f, 1.0f);
            this.requestItemCooldown = 40;
            this.isRequestOutdated = true;
            itemEntity.func_70106_y();
        }
    }

    public void handleRequestPaperOnGround(ItemEntity itemEntity) {
        if (!this.isRewardThrown && this.santaElfRequest.isCompleted()) {
            this.timeToCompleteRequest = 24000 - this.despawnDelay;
            this.func_71001_a((Entity)itemEntity, itemEntity.func_92059_d().func_190916_E());
            this.throwRequestRewards();
            if (itemEntity.func_200214_m() != null) {
                PlayerEntity playerEntity = this.field_70170_p.func_217371_b(itemEntity.func_200214_m());
                NaughtyNiceMeter.evaluateAction(playerEntity, NaughtyNiceAction.HELP_SANTA_ELF_EVENT);
                SantaElfEvent.CompleteRequest completeRequestEvent = new SantaElfEvent.CompleteRequest(playerEntity, this, this.timeToCompleteRequest);
                MinecraftForge.EVENT_BUS.post((Event)completeRequestEvent);
            }
            this.isRewardThrown = true;
            itemEntity.func_70106_y();
        } else if (this.isRequestOutdated && !this.santaElfRequest.isCompleted()) {
            this.func_71001_a((Entity)itemEntity, itemEntity.func_92059_d().func_190916_E());
            this.func_199701_a_(this.getRequest().getRequestPaper());
            this.requestPaperCooldown = 40;
            this.isRequestOutdated = false;
            itemEntity.func_70106_y();
        }
    }

    public boolean isReadyToTakeRequestItem() {
        return this.requestItemCooldown <= 0;
    }

    public boolean isReadyToTakeRequestPaper() {
        return this.requestPaperCooldown <= 0;
    }

    public MerchantOffer getSantaElfRequestOffer() {
        return this.santaElfRequestOfferIndex == -1 ? null : (MerchantOffer)this.offers.get(this.santaElfRequestOfferIndex);
    }

    public void throwRequestRewards() {
        LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(SANTA_ELF_REQUEST_LOOT_TABLE);
        LootContext ctx = this.func_213363_a(true, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
        ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingEntity(this.field_70170_p, this.func_213303_ch());
        double modifier = starTileEntity != null ? (starTileEntity.isBonusActive() ? 2.0 : 1.0 + (double)starTileEntity.getCurrentTier() * 0.1) : 1.0;
        lootTable.func_216113_a(ctx).forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(24) + 1 + 12);
            } else if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(4) + 1 + 4);
            } else if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).func_190903_i())) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(6) + 1 + 12);
            }
            itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * modifier));
            this.func_199701_a_((ItemStack)itemStack);
        });
        double ornamentDropChance = 0.2 * modifier;
        if (ornamentDropChance > this.field_70146_Z.nextDouble()) {
            ItemStack elfOrnamentItem = ((ChristmasBlockItem)ChristmasItems.SANTA_ELF_ORNAMENT.get()).func_190903_i();
            this.func_199701_a_(elfOrnamentItem);
        }
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ChristmasSounds.SANTA_ELF_REQUEST_COMPLETE.get(), SoundCategory.VOICE, 1.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)new FireworkRocketEntity(this.field_70170_p, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.createCelebratoryFireworks()));
        this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 36));
    }

    private ItemStack createCelebratoryFireworks() {
        ItemStack fireworkStack = Items.field_196152_dE.func_190903_i();
        CompoundNBT fireworkNBT = new CompoundNBT();
        fireworkNBT.func_74768_a("Flight", 2);
        CompoundNBT explosionsNBT = new CompoundNBT();
        explosionsNBT.func_74774_a("Type", (byte)0);
        ArrayList colorList = Lists.newArrayList();
        colorList.add(((DyeItem)Items.field_222079_lj).func_195962_g().func_196060_f());
        colorList.add(((DyeItem)Items.field_222078_li).func_195962_g().func_196060_f());
        explosionsNBT.func_197646_b("Colors", (List)colorList);
        ListNBT listWrapper = new ListNBT();
        listWrapper.add((Object)explosionsNBT);
        fireworkNBT.func_218657_a("Explosions", (INBT)listWrapper);
        fireworkStack.func_196082_o().func_218657_a("Fireworks", (INBT)fireworkNBT);
        return fireworkStack;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("DespawnDelay", this.despawnDelay);
        nbt.func_218657_a("SantaElfRequest", (INBT)this.santaElfRequest.createTag());
        nbt.func_218657_a("MerchantOffers", (INBT)this.func_213706_dY().func_222199_a());
        nbt.func_74757_a("IsRequestOutdated", this.isRequestOutdated);
        nbt.func_74757_a("IsRewardThrown", this.isRewardThrown);
        nbt.func_74768_a("TimeToCompleteRequest", this.timeToCompleteRequest);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = nbt.func_74762_e("DespawnDelay");
        }
        if (nbt.func_150297_b("SantaElfRequest", 10)) {
            this.santaElfRequest = SantaElfRequest.fromTag(nbt.func_74775_l("SantaElfRequest"));
        }
        if (nbt.func_150297_b("MerchantOffers", 10)) {
            this.offers = new MerchantOffers(nbt.func_74775_l("MerchantOffers"));
        }
        this.isRequestOutdated = nbt.func_74767_n("IsRequestOutdated");
        this.isRewardThrown = nbt.func_74767_n("IsRewardThrown");
        this.timeToCompleteRequest = nbt.func_74762_e("TimeToCompleteRequest");
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.maybeDespawn();
        }
        if (--this.requestItemCooldown > 0) {
            // empty if block
        }
        if (--this.requestPaperCooldown > 0) {
            // empty if block
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.isTrading() && --this.despawnDelay == 0) {
            this.despawnElf();
        }
    }

    public void despawnElf() {
        if (!this.field_70170_p.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            BasicParticleType particleType = ParticleTypes.field_197598_I;
            for (int i = 0; i < 5; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                serverWorld.func_195598_a((IParticleData)particleType, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
            }
            serverWorld.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_ELF_DESPAWN.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        this.func_70106_y();
    }

    public void pickUpSomeItems(ItemEntity itemEntity, int itemsToPickUpCount) {
        ItemStack itemStack = itemEntity.func_92059_d();
        this.func_233630_a_(itemEntity);
        this.func_71001_a((Entity)itemEntity, itemStack.func_190916_E());
        if (itemsToPickUpCount < itemStack.func_190916_E()) {
            ItemStack itemStackCopy = itemStack.func_77946_l();
            itemStackCopy.func_190920_e(itemStack.func_190916_E() - itemsToPickUpCount);
            this.func_199701_a_(itemStackCopy);
        }
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block blockItem, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(new ItemStack((IItemProvider)blockItem), emeraldCost, numberOfItems, maxUses, xp);
        }

        public ItemsForEmeraldsTrade(Item item, int emeraldCost, int numberOfItems, int xp) {
            this(new ItemStack((IItemProvider)item), emeraldCost, numberOfItems, 6, xp);
        }

        public ItemsForEmeraldsTrade(Item item, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(new ItemStack((IItemProvider)item), emeraldCost, numberOfItems, maxUses, xp);
        }

        public ItemsForEmeraldsTrade(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(itemStack, emeraldCost, numberOfItems, maxUses, xp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int xp, float priceMultiplier) {
            this.itemStack = itemStack;
            this.emeraldCost = emeraldCost;
            this.numberOfItems = numberOfItems;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack offerStack = new ItemStack((IItemProvider)this.itemStack.func_77973_b(), this.numberOfItems);
            offerStack.func_77982_d(this.itemStack.func_77978_p());
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCost), offerStack, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class EmeraldForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(IItemProvider itemProvider, int cost, int maxUses, int xp) {
            this.item = itemProvider.func_199767_j();
            this.cost = cost;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.item, this.cost);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    private static class SwapToyPartsRequestGoal
    extends Goal {
        private SantaElfEntity santaElfEntity;
        private ItemEntity targetedEntity;

        public SwapToyPartsRequestGoal(SantaElfEntity santaElfEntity) {
            this.santaElfEntity = santaElfEntity;
        }

        public boolean func_75250_a() {
            if (this.santaElfEntity.isRewardThrown) {
                return false;
            }
            List nearbyEntities = this.santaElfEntity.field_70170_p.func_217357_a(ItemEntity.class, this.santaElfEntity.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!ItemStack.func_179545_c((ItemStack)entity.func_92059_d(), (ItemStack)((ChristmasItem)ChristmasItems.TOY_PARTS_REQUEST.get()).func_190903_i())) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void func_75246_d() {
            if (this.targetedEntity != null || !this.targetedEntity.func_70089_S()) {
                this.santaElfEntity.func_70661_as().func_75497_a((Entity)this.targetedEntity, 1.0);
                if (this.santaElfEntity.isReadyToTakeRequestPaper() && this.targetedEntity.func_70068_e((Entity)this.santaElfEntity) < 2.0) {
                    this.santaElfEntity.handleRequestPaperOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class PickupRequestedItemGoal
    extends Goal {
        private SantaElfEntity santaElfEntity;
        private ItemEntity targetedEntity;

        public PickupRequestedItemGoal(SantaElfEntity santaElfEntity) {
            this.santaElfEntity = santaElfEntity;
        }

        public boolean func_75250_a() {
            MerchantOffer requestOffer = this.santaElfEntity.getSantaElfRequestOffer();
            if (requestOffer == null || !requestOffer.func_222217_o()) {
                return false;
            }
            SantaElfRequest request = this.santaElfEntity.getRequest();
            if (request.isCompleted()) {
                return false;
            }
            List nearbyEntities = this.santaElfEntity.field_70170_p.func_217357_a(ItemEntity.class, this.santaElfEntity.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!this.santaElfEntity.getRequest().isInRequest(entity.func_92059_d())) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void func_75246_d() {
            if (this.targetedEntity != null || !this.targetedEntity.func_70089_S()) {
                this.santaElfEntity.func_70661_as().func_75497_a((Entity)this.targetedEntity, 1.0);
                if (this.santaElfEntity.isReadyToTakeRequestItem() && this.targetedEntity.func_70068_e((Entity)this.santaElfEntity) < 2.0) {
                    this.santaElfEntity.handleRequestItemOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class LookAtCustomerGoal
    extends LookAtGoal {
        private final SantaElfEntity villager;

        public LookAtCustomerGoal(SantaElfEntity elfEntity) {
            super((MobEntity)elfEntity, PlayerEntity.class, 8.0f);
            this.villager = elfEntity;
        }

        public boolean func_75250_a() {
            if (this.villager.isTrading()) {
                this.field_75334_a = this.villager.func_70931_l_();
                return true;
            }
            return false;
        }
    }

    private static class TradeWithPlayerGoal
    extends Goal {
        private final SantaElfEntity mob;

        public TradeWithPlayerGoal(SantaElfEntity santaElfEntity) {
            this.mob = santaElfEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.mob.func_70089_S()) {
                return false;
            }
            if (this.mob.func_70090_H()) {
                return false;
            }
            if (!this.mob.func_233570_aj_()) {
                return false;
            }
            if (this.mob.field_70133_I) {
                return false;
            }
            PlayerEntity playerentity = this.mob.func_70931_l_();
            if (playerentity == null) {
                return false;
            }
            if (this.mob.func_70068_e((Entity)playerentity) > 16.0) {
                return false;
            }
            return playerentity.field_71070_bA != null;
        }

        public void func_75249_e() {
            this.mob.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.mob.func_70932_a_(null);
        }
    }
}

