/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;

public class SantaElfRequest {
    public Random random = new Random();
    public List<SingleElfRequest> requestedItemsList = new ArrayList<SingleElfRequest>();
    private long expiryTime;

    SantaElfRequest() {
    }

    public SingleElfRequest tryFulfilRequest(ItemStack stack) {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (request.isCompleted() || !request.tryFulfilRequest(stack)) continue;
            return request;
        }
        return null;
    }

    public boolean isInRequest(ItemStack stack) {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (!ItemStack.func_179545_c((ItemStack)request.getRequestedItems(), (ItemStack)stack) || request.getNumberOfItems() > stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getRequestPaper() {
        ItemStack requestPaper = ((ChristmasItem)ChristmasItems.TOY_PARTS_REQUEST.get()).func_190903_i();
        CompoundNBT nbt = requestPaper.func_196082_o();
        nbt.func_218657_a("SantaElfRequest", (INBT)this.createTag());
        return requestPaper;
    }

    public boolean isCompleted() {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (request.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public List<SingleElfRequest> getRequestedItems() {
        return this.requestedItemsList;
    }

    void addEntry(ItemStack itemStack, boolean isCompleted) {
        SingleElfRequest singleElfRequest = new SingleElfRequest(itemStack);
        if (isCompleted) {
            singleElfRequest.setCompleted();
        }
        this.requestedItemsList.add(singleElfRequest);
    }

    public static SantaElfRequest fromTag(CompoundNBT nbt) {
        SantaElfRequest santaElfRequest = new SantaElfRequest();
        ListNBT singleRequestsNBT = nbt.func_150295_c("SingleRequests", 10);
        byte[] completedRequestNBT = nbt.func_74770_j("RequestsCompleted");
        for (int i = 0; i < singleRequestsNBT.size(); ++i) {
            boolean isCompleted;
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)singleRequestsNBT.func_150305_b(i));
            boolean bl = isCompleted = completedRequestNBT[i] == 1;
            if (itemStack.func_190926_b()) continue;
            santaElfRequest.addEntry(itemStack, isCompleted);
        }
        santaElfRequest.setExpiryTime(nbt.func_74763_f("ExpiryTime"));
        return santaElfRequest;
    }

    public CompoundNBT createTag() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT singleRequestsNBT = new ListNBT();
        for (SingleElfRequest singleElfRequest : this.requestedItemsList) {
            ItemStack itemstack = singleElfRequest.getRequestedItems();
            if (itemstack.func_190926_b()) continue;
            singleRequestsNBT.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        ByteArrayNBT completedRequestNBT = new ByteArrayNBT(this.requestedItemsList.stream().map(request -> request.isCompleted() ? (byte)1 : (byte)0).collect(Collectors.toList()));
        nbt.func_218657_a("SingleRequests", (INBT)singleRequestsNBT);
        nbt.func_218657_a("RequestsCompleted", (INBT)completedRequestNBT);
        nbt.func_218657_a("ExpiryTime", (INBT)LongNBT.func_229698_a_((long)this.expiryTime));
        return nbt;
    }

    void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public class SingleElfRequest {
        private final ItemStack requestedItems;
        private boolean isCompleted;

        public SingleElfRequest(ItemStack requestedItems) {
            this.requestedItems = requestedItems;
        }

        public int getNumberOfItems() {
            return this.requestedItems.func_190916_E();
        }

        public ItemStack getRequestedItems() {
            return this.requestedItems;
        }

        public boolean tryFulfilRequest(ItemStack stack) {
            if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.requestedItems) && stack.func_190916_E() >= this.requestedItems.func_190916_E()) {
                this.setCompleted();
                return true;
            }
            return false;
        }

        public void setCompleted() {
            this.isCompleted = true;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public String toString() {
            if (this.requestedItems.func_77973_b() instanceof MusicDiscItem) {
                String itemName = ((MusicDiscItem)this.requestedItems.func_77973_b()).func_234801_g_().getString();
                return String.format("%d\u00d7 Music Disc [%s]", this.requestedItems.func_190916_E(), itemName);
            }
            String itemName = this.requestedItems.func_200301_q().getString();
            return String.format("%d\u00d7 %s", this.requestedItems.func_190916_E(), itemName);
        }
    }
}

