/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread;

import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GingerbreadPersonEntity
extends ChristmasEntity
implements IAnimatable {
    public static final float ENTITY_BOX_SIZE = 0.8f;
    public static final float ENTITY_BOX_HEIGHT = 2.0f;
    private static final ResourceLocation GINGERBREAD_CONVERSION_LOOT_TABLE = new ResourceLocation("happyholidays:entities/gingerbread_conversion");
    private static final double CONVERSION_ORNAMENT_DROP_BASE_CHANCE = 0.01;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean isLeader = false;

    public GingerbreadPersonEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowGingerbreadLeaderGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_PASSIVE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_HURT.get();
    }

    public void setLeader() {
        this.isLeader = true;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean func_230279_az_() {
        return false;
    }

    public void dropConversionLoot() {
        LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(GINGERBREAD_CONVERSION_LOOT_TABLE);
        LootContext ctx = this.func_213363_a(true, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
        ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingEntity(this.field_70170_p, this.func_213303_ch());
        double modifier = starTileEntity != null ? (starTileEntity.isBonusActive() ? 2.0 : 1.0 + (double)starTileEntity.getCurrentTier() * 0.1) : 1.0;
        lootTable.func_216113_a(ctx).forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(1) + 1 + 1);
            }
            itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * modifier));
            this.func_199701_a_((ItemStack)itemStack);
        });
        double ornamentDropChance = 0.01 * modifier;
        if (ornamentDropChance > this.field_70146_Z.nextDouble()) {
            ItemStack gingerbreadOrnamentItem = ((ChristmasBlockItem)ChristmasItems.GINGERBREAD_MAN_ORNAMENT.get()).func_190903_i();
            this.func_199701_a_(gingerbreadOrnamentItem);
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.gingerbread_man.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.gingerbread_man.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean checkGingerbreadSpawnRules(EntityType<? extends GingerbreadPersonEntity> entity, IWorld world, SpawnReason spawnReason, BlockPos pos, Random rand) {
        return world.func_226659_b_(pos, 0) > 8;
    }

    private static class FollowGingerbreadLeaderGoal
    extends Goal {
        private GingerbreadPersonEntity gingerbreadPerson;
        private GingerbreadPersonEntity leader;
        private int timeToRecalcPath;

        public FollowGingerbreadLeaderGoal(GingerbreadPersonEntity gingerbreadPerson) {
            this.gingerbreadPerson = gingerbreadPerson;
        }

        public boolean func_75250_a() {
            if (this.gingerbreadPerson.isLeader()) {
                return false;
            }
            List<GingerbreadPersonEntity> list = this.getSurroundingGingerbreadPeople();
            if (this.canBeLeader()) {
                this.gingerbreadPerson.setLeader();
                return false;
            }
            for (GingerbreadPersonEntity entity : list) {
                if (!entity.isLeader()) continue;
                this.leader = entity;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.leader.func_70089_S()) {
                if (this.canBeLeader()) {
                    this.gingerbreadPerson.setLeader();
                }
                return false;
            }
            double d0 = this.gingerbreadPerson.func_70068_e((Entity)this.leader);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        private boolean canBeLeader() {
            List<GingerbreadPersonEntity> entitiesAround = this.getSurroundingGingerbreadPeople();
            if (entitiesAround.isEmpty()) {
                return true;
            }
            for (GingerbreadPersonEntity entity : entitiesAround) {
                if (!entity.isLeader()) continue;
                return false;
            }
            return true;
        }

        private List<GingerbreadPersonEntity> getSurroundingGingerbreadPeople() {
            return this.gingerbreadPerson.field_70170_p.func_217357_a(GingerbreadPersonEntity.class, this.gingerbreadPerson.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
        }

        public void func_75251_c() {
            this.leader = null;
        }

        public void func_75246_d() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                this.gingerbreadPerson.func_70661_as().func_75497_a((Entity)this.leader, 1.0);
            }
        }
    }
}

