/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.grinch;

import com.jumpcutfindo.happyholidays.common.block.christmas.presents.PresentBlock;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.GrinchEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.gifts.ChristmasGiftItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GrinchEntity
extends ChristmasEntity
implements IAnimatable {
    public static final DataParameter<Integer> BREAK_ANIM_PROGRESS = EntityDataManager.func_187226_a(GrinchEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String ENTITY_ID = "grinch";
    public static final AttributeModifierMap ENTITY_ATTRIBUTES = MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233813_a_();
    public static final float ENTITY_BOX_SIZE = 0.5f;
    public static final float ENTITY_BOX_HEIGHT = 2.125f;
    private static final ResourceLocation GRINCH_APPEASEMENT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/grinch_appeasement");
    public static final double GRINCH_SPAWN_CHANCE = 0.2;
    public static final int MAX_GRINCHES_IN_VICINITY = 3;
    private static final int BREAK_PRESENT_ANIM_DURATION = 80;
    private static final int BREAK_PRESENT_INTERVAL = 100;
    private static final float AVOID_PLAYER_RADIUS = 6.0f;
    private static final int GRINCH_TIME_TO_DESPAWN = 200;
    public static final int PRESENT_SEARCH_RADIUS = 8;
    private static final double APPEASEMENT_ORNAMENT_DROP_BASE_CHANCE = 0.2;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int[] presentsBrokenCount = new int[]{0, 0, 0};
    private int presentBreakingProgress = -1;
    private boolean hasReceivedGift = false;
    private boolean isHappyWithGift = false;
    private int despawnTimer = 200;
    private boolean isReadyToDespawn = false;

    public GrinchEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BREAK_ANIM_PROGRESS, (Object)-1);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PickupGiftGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.5, livingEntity -> {
            PlayerEntity playerEntity;
            if (this.hasReceivedGift) {
                return false;
            }
            return !(livingEntity instanceof PlayerEntity) || !((playerEntity = (PlayerEntity)livingEntity).func_184614_ca().func_77973_b() instanceof ChristmasGiftItem) && !(playerEntity.func_184592_cb().func_77973_b() instanceof ChristmasGiftItem);
        }));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakPresentsGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ChristmasSounds.GRINCH_PASSIVE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)ChristmasSounds.GRINCH_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ChristmasSounds.GRINCH_HURT.get();
    }

    public boolean isPlayerAround() {
        List playerEntityList = this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0), null);
        return playerEntityList.size() > 0;
    }

    public void beginPresentBreaking() {
        this.field_70180_af.func_187227_b(BREAK_ANIM_PROGRESS, (Object)80);
    }

    public void updatePresentBreaking(int progress) {
        this.field_70180_af.func_187227_b(BREAK_ANIM_PROGRESS, (Object)progress);
    }

    public void endPresentBreaking(BlockPos targetPresentBlock) {
        this.field_70180_af.func_187227_b(BREAK_ANIM_PROGRESS, (Object)-1);
        if (this.field_70170_p.func_180495_p(targetPresentBlock).func_177230_c().func_235332_a_((Block)ChristmasBlocks.BABY_PRESENT.get())) {
            this.presentsBrokenCount[0] = this.presentsBrokenCount[0] + 1;
        } else if (this.field_70170_p.func_180495_p(targetPresentBlock).func_177230_c().func_235332_a_((Block)ChristmasBlocks.ADULT_PRESENT.get())) {
            this.presentsBrokenCount[1] = this.presentsBrokenCount[1] + 1;
        } else {
            this.presentsBrokenCount[2] = this.presentsBrokenCount[2] + 1;
        }
        this.field_70170_p.func_175655_b(targetPresentBlock, false);
        this.field_70170_p.func_184133_a(null, targetPresentBlock, (SoundEvent)ChristmasSounds.GRINCH_BREAK_BOX.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void handleGiftOnGround(ItemEntity itemEntity) {
        if (!this.hasReceivedGift) {
            CompoundNBT itemTag = itemEntity.func_92059_d().func_77978_p();
            this.func_71001_a((Entity)itemEntity, itemEntity.func_92059_d().func_190916_E());
            itemEntity.func_70106_y();
            if (itemTag != null && itemTag.func_74764_b("Gifts")) {
                this.hasReceivedGift = true;
                this.isHappyWithGift = true;
                this.throwAppeasementRewards();
                if (itemEntity.func_200214_m() != null) {
                    PlayerEntity thrower = this.field_70170_p.func_217371_b(itemEntity.func_200214_m());
                    NaughtyNiceMeter.evaluateAction(thrower, NaughtyNiceAction.APPEASE_GRINCH_EVENT);
                    MinecraftForge.EVENT_BUS.post((Event)new GrinchEvent.Appease(this, thrower));
                }
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
                }
                this.field_70699_by.func_75492_a(this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 32.0 + 128.0, this.func_226278_cu_(), this.field_70146_Z.nextDouble() * 32.0 + 128.0, 2.0);
                this.isReadyToDespawn = true;
            } else {
                this.isHappyWithGift = false;
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197609_b, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
                }
                this.field_70699_by.func_75492_a(this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 64.0 + 128.0, this.func_226278_cu_(), this.field_70146_Z.nextDouble() * 64.0 + 128.0, 2.0);
                this.isReadyToDespawn = true;
            }
        }
    }

    public void throwAppeasementRewards() {
        this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 50));
        ItemStack scraps = ((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).func_190903_i();
        scraps.func_190920_e(this.presentsBrokenCount[0] + this.presentsBrokenCount[1] * 2 + this.presentsBrokenCount[2] * 3);
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), scraps));
        LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(GRINCH_APPEASEMENT_LOOT_TABLE);
        LootContext ctx = this.func_213363_a(true, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
        ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingEntity(this.field_70170_p, this.func_213303_ch());
        double modifier = starTileEntity != null ? (starTileEntity.isBonusActive() ? 2.0 : 1.0 + (double)starTileEntity.getCurrentTier() * 0.1) : 1.0;
        lootTable.func_216113_a(ctx).forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(24) + 1 + 12);
            } else if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(4) + 1 + 4);
            } else if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).func_190903_i())) {
                itemStack.func_190920_e(this.field_70146_Z.nextInt(6) + 1 + 12);
            } else if (ChristmasItems.isFoodItem(itemStack)) {
                if (ChristmasItems.isLargeFoodItem(itemStack)) {
                    itemStack.func_190920_e(this.field_70146_Z.nextInt(2) + 1 + 2);
                } else {
                    itemStack.func_190920_e(this.field_70146_Z.nextInt(4) + 1 + 12);
                }
            }
            if (!(itemStack.func_77973_b() instanceof SwordItem || itemStack.func_77973_b() instanceof HoeItem || itemStack.func_77973_b() instanceof AxeItem || itemStack.func_77973_b() instanceof PickaxeItem || itemStack.func_77973_b() instanceof ShovelItem)) {
                itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * modifier));
            }
            this.func_199701_a_((ItemStack)itemStack);
        });
        double ornamentDropChance = 0.2 * modifier;
        if (ornamentDropChance > this.field_70146_Z.nextDouble()) {
            ItemStack grinchOrnamentItem = ((ChristmasBlockItem)ChristmasItems.GRINCH_ORNAMENT.get()).func_190903_i();
            this.func_199701_a_(grinchOrnamentItem);
        }
    }

    public void despawnGrinch() {
        if (!this.field_70170_p.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            BasicParticleType particleType = ParticleTypes.field_197598_I;
            for (int i = 0; i < 5; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                serverWorld.func_195598_a((IParticleData)particleType, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
            }
            serverWorld.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.GRINCH_DESPAWN.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        this.func_70106_y();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d()) {
            this.presentBreakingProgress = (Integer)this.field_70180_af.func_187225_a(BREAK_ANIM_PROGRESS);
        }
        if (this.isReadyToDespawn && this.field_70173_aa % 3 == 0) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            BasicParticleType particleType = this.isHappyWithGift ? ParticleTypes.field_197633_z : ParticleTypes.field_197609_b;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
        }
        if (this.isReadyToDespawn && --this.despawnTimer <= 0) {
            this.despawnGrinch();
        }
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p.func_82737_E() % 60L == 0L) {
            List<PlayerEntity> playersAround = HappyHolidaysUtils.findPlayersInRadius(this.field_70170_p, this.func_213303_ch(), 6.0);
            for (PlayerEntity playerEntity : playersAround) {
                MinecraftForge.EVENT_BUS.post((Event)new GrinchEvent.Encounter(this, playerEntity));
            }
        }
    }

    public static boolean canSpawnInArea(BlockPos blockPos, ServerWorld serverWorld) {
        AxisAlignedBB searchBox = new AxisAlignedBB(blockPos).func_186662_g(40.0);
        boolean isPlayerInVicinity = serverWorld.func_217357_a(PlayerEntity.class, searchBox).size() > 0;
        boolean isGrinchesAround = serverWorld.func_217357_a(GrinchEntity.class, searchBox).size() > 3;
        return isPlayerInVicinity && !isGrinchesAround && serverWorld.func_226690_K_();
    }

    public static void spawnGrinchAround(BlockPos blockPos, ServerWorld serverWorld, Random random) {
        if (random.nextDouble() <= 0.2) {
            int randomX = random.nextInt(16) * (random.nextBoolean() ? -1 : 1);
            int randomY = 0;
            int randomZ = random.nextInt(16) * (random.nextBoolean() ? -1 : 1);
            GrinchEntity grinchEntity = (GrinchEntity)((EntityType)ChristmasEntities.GRINCH.get()).func_200721_a((World)serverWorld);
            grinchEntity.func_225653_b_(blockPos.func_177958_n() + randomX, blockPos.func_177956_o() + randomY, blockPos.func_177952_p() + randomZ);
            serverWorld.func_217376_c((Entity)grinchEntity);
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74783_a("PresentsBroken", this.presentsBrokenCount);
        nbt.func_74757_a("HasReceivedGift", this.hasReceivedGift);
        nbt.func_74757_a("IsReadyToDespawn", this.isReadyToDespawn);
        nbt.func_74768_a("DespawnTimer", this.despawnTimer);
        nbt.func_74757_a("IsHappyWithGift", this.isHappyWithGift);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        int[] tempArray = nbt.func_74759_k("PresentsBroken");
        this.presentsBrokenCount = tempArray.length == 3 ? tempArray : new int[]{0, 0, 0};
        this.hasReceivedGift = nbt.func_74767_n("HasReceivedGift");
        this.isReadyToDespawn = nbt.func_74767_n("IsReadyToDespawn");
        int tempDespawnTimer = nbt.func_74762_e("DespawnTimer");
        this.despawnTimer = tempDespawnTimer == 0 ? 200 : tempDespawnTimer;
        this.isHappyWithGift = nbt.func_74767_n("IsHappyWithGift");
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        ItemStack scraps = ((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).func_190903_i();
        scraps.func_190920_e(this.presentsBrokenCount[0] + this.presentsBrokenCount[1] + this.presentsBrokenCount[2]);
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), scraps));
    }

    private <E extends GrinchEntity> PlayState predicate(AnimationEvent<E> event) {
        if (this.presentBreakingProgress >= 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.break", Boolean.valueOf(false)));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private static class PickupGiftGoal
    extends Goal {
        private final GrinchEntity grinchEntity;
        private ItemEntity targetedEntity;

        public PickupGiftGoal(GrinchEntity grinchEntity) {
            this.grinchEntity = grinchEntity;
        }

        public boolean func_75250_a() {
            if (this.grinchEntity.hasReceivedGift) {
                return false;
            }
            List nearbyEntities = this.grinchEntity.field_70170_p.func_217357_a(ItemEntity.class, this.grinchEntity.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!(entity.func_92059_d().func_77973_b() instanceof ChristmasGiftItem)) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void func_75246_d() {
            if (this.targetedEntity != null && this.targetedEntity.func_70089_S()) {
                this.grinchEntity.func_70661_as().func_75497_a((Entity)this.targetedEntity, 1.0);
                if (this.targetedEntity.func_70068_e((Entity)this.grinchEntity) < 2.0) {
                    this.grinchEntity.handleGiftOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class BreakPresentsGoal
    extends Goal {
        private static final float MOVE_TO_PRESENT_SPEED = 0.8f;
        private final GrinchEntity grinchEntity;
        private BlockPos targetPresentBlockPos = null;
        private int presentBreakingProgress = 80;
        private int timeLeftToNextSearch = 0;

        public BreakPresentsGoal(GrinchEntity grinchEntity) {
            this.grinchEntity = grinchEntity;
        }

        public boolean func_75250_a() {
            if (this.grinchEntity.hasReceivedGift) {
                return false;
            }
            if (this.grinchEntity.func_70660_b((Effect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get()) != null) {
                this.targetPresentBlockPos = null;
                this.resetPresentBreaking();
                return false;
            }
            if (!this.grinchEntity.isPlayerAround()) {
                return true;
            }
            this.targetPresentBlockPos = null;
            this.resetPresentBreaking();
            return false;
        }

        public void func_75246_d() {
            if (this.targetPresentBlockPos == null && this.timeLeftToNextSearch == 0) {
                BlockPos startPos = this.grinchEntity.func_233580_cy_();
                boolean isFound = false;
                block0: for (int y = -4; y < 4 && !isFound; ++y) {
                    int X = 16;
                    int Z = 16;
                    int x = 0;
                    int z = 0;
                    int dx = 0;
                    int dz = -1;
                    int t = Math.max(X, Z);
                    int maxI = t * t;
                    for (int i = 0; i < maxI; ++i) {
                        BlockPos currPos;
                        if (-X / 2 <= x && x <= X / 2 && -Z / 2 <= z && z <= Z / 2 && this.grinchEntity.field_70170_p.func_180495_p(currPos = startPos.func_177982_a(x, y, z)).func_177230_c() instanceof PresentBlock) {
                            if (ChristmasStarTileEntity.getStarInfluencingEntity(this.grinchEntity.field_70170_p, new Vector3d((double)currPos.func_177958_n(), (double)currPos.func_177956_o(), (double)currPos.func_177952_p())) != null) continue;
                            this.targetPresentBlockPos = currPos;
                            this.presentBreakingProgress = 80;
                            isFound = true;
                            continue block0;
                        }
                        if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                            t = dx;
                            dx = -dz;
                            dz = t;
                        }
                        x += dx;
                        z += dz;
                    }
                }
            } else if (this.targetPresentBlockPos != null) {
                if (this.grinchEntity.field_70170_p.func_175623_d(this.targetPresentBlockPos)) {
                    this.targetPresentBlockPos = null;
                    this.grinchEntity.updatePresentBreaking(-1);
                    this.timeLeftToNextSearch = 100;
                } else {
                    int presentZ;
                    int presentY;
                    int presentX = this.targetPresentBlockPos.func_177958_n();
                    if (this.grinchEntity.func_70092_e(presentX, presentY = this.targetPresentBlockPos.func_177956_o(), presentZ = this.targetPresentBlockPos.func_177952_p()) > 3.0) {
                        this.grinchEntity.field_70699_by.func_75492_a((double)presentX, (double)presentY, (double)presentZ, (double)0.8f);
                        this.grinchEntity.field_70749_g.func_220679_a((double)presentX, (double)presentY, (double)presentZ);
                        if (this.grinchEntity.field_70699_by.func_244428_t()) {
                            this.grinchEntity.field_70767_i.func_75660_a();
                        }
                    } else {
                        if (this.presentBreakingProgress == 80) {
                            this.grinchEntity.beginPresentBreaking();
                        } else if (this.presentBreakingProgress == 0) {
                            this.grinchEntity.endPresentBreaking(this.targetPresentBlockPos);
                            this.targetPresentBlockPos = null;
                            this.timeLeftToNextSearch = 100;
                        } else {
                            this.grinchEntity.updatePresentBreaking(this.presentBreakingProgress);
                        }
                        --this.presentBreakingProgress;
                    }
                }
            }
            if (this.timeLeftToNextSearch > 0) {
                --this.timeLeftToNextSearch;
            }
        }

        private void resetPresentBreaking() {
            this.presentBreakingProgress = 80;
            this.grinchEntity.updatePresentBreaking(-1);
        }
    }
}

