/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy.HappySantaEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SantaGifts {
    public static final String NAME_HAPPY_SANTA = "entity.happyholidays.happy_santa";
    public static final String NAME_ANGRY_SANTA = "entity.happyholidays.angry_santa";
    public static final String NAME_BASIC_GIFT = "item.happyholidays.santa.basic_gift";
    public static final String NAME_RARE_GIFT = "item.happyholidays.santa.rare_gift";
    public static final String NAME_LEGENDARY_GIFT = "item.happyholidays.santa.legendary_gift";
    public static final ResourceLocation BASIC_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_basic_gift");
    public static final ResourceLocation RARE_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_rare_gift");
    public static final ResourceLocation LEGENDARY_GIFT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_legendary_gift");

    public static ItemStack generateGift(SantaGiftType type, BaseSantaEntity santaEntity, ServerWorld level, LootContext lootContext) {
        ItemStack giftItem = ItemStack.field_190927_a;
        List items = Lists.newArrayList();
        switch (type) {
            case BASIC: {
                giftItem = ((ChristmasItem)ChristmasItems.BLUE_CHRISTMAS_GIFT_ITEM.get()).func_190903_i();
                giftItem.func_200302_a((ITextComponent)new TranslationTextComponent(NAME_BASIC_GIFT));
                LootTable lootTable = level.func_73046_m().func_200249_aQ().func_186521_a(BASIC_GIFT_LOOT_TABLE);
                items = lootTable.func_216113_a(lootContext);
                for (ItemStack item : items) {
                    if (!(item.func_77973_b() instanceof BlockItem) || !((BlockItem)item.func_77973_b()).func_179223_d().func_203417_a((ITag)BlockTags.field_200031_h)) continue;
                    item.func_190920_e(santaEntity.func_70681_au().nextInt(6) + 6);
                }
                break;
            }
            case RARE: {
                giftItem = ((ChristmasItem)ChristmasItems.GREEN_CHRISTMAS_GIFT_ITEM.get()).func_190903_i();
                giftItem.func_200302_a((ITextComponent)new TranslationTextComponent(NAME_RARE_GIFT));
                LootTable lootTable = level.func_73046_m().func_200249_aQ().func_186521_a(RARE_GIFT_LOOT_TABLE);
                items = lootTable.func_216113_a(lootContext);
                break;
            }
            case LEGENDARY: {
                giftItem = ((ChristmasItem)ChristmasItems.GOLD_CHRISTMAS_GIFT_ITEM.get()).func_190903_i();
                giftItem.func_200302_a((ITextComponent)new TranslationTextComponent(NAME_LEGENDARY_GIFT));
                LootTable lootTable = level.func_73046_m().func_200249_aQ().func_186521_a(LEGENDARY_GIFT_LOOT_TABLE);
                items = lootTable.func_216113_a(lootContext);
                break;
            }
        }
        CompoundNBT giftItemsNBT = new CompoundNBT();
        NonNullList nonNullList = NonNullList.func_191197_a((int)items.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < items.size(); ++i) {
            nonNullList.set(i, items.get(i));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)giftItemsNBT, (NonNullList)nonNullList);
        String name = santaEntity instanceof HappySantaEntity ? NAME_HAPPY_SANTA : NAME_ANGRY_SANTA;
        CompoundNBT giftTag = giftItem.func_196082_o();
        giftTag.func_218657_a("Gifts", (INBT)giftItemsNBT);
        giftTag.func_74778_a("WrappedBy", new TranslationTextComponent(name).getString());
        return giftItem;
    }
}

