/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGifts;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.ExplosivePresentEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.ExplosivePresentsAttackGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.Phase;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.PhaseSwitchGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.SleighAttackGoal;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.SleighEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.TeleportGoal;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class AngrySantaEntity
extends BaseSantaEntity {
    public static final DataParameter<Integer> SANTA_PHASE = EntityDataManager.func_187226_a(AngrySantaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ATTACK_HIT_ANIM_TIMER = EntityDataManager.func_187226_a(AngrySantaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ATTACK_SLEIGHS_ANIM_TIMER = EntityDataManager.func_187226_a(AngrySantaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ATTACK_TELEPORT_ANIM_TIMER = EntityDataManager.func_187226_a(AngrySantaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String ENTITY_ID = "angry_santa";
    public static final int ATTACK_PHASE_SWITCH_TIMER_MAX = 200;
    public static final int ATTACK_PHASE_SWITCH_TIMER_MIN = 80;
    public static final int ATTACK_SLEIGH_CHARGE_TIME = 10;
    public static final int ATTACK_SLEIGH_INTERVAL = 40;
    public static final int ATTACK_SLEIGH_LIFETIME = 80;
    public static final int ATTACK_PRESENTS_CONSIDERATION_RADIUS = 30;
    public static final int ATTACK_PRESENTS_INTERVAL = 30;
    public static final int ATTACK_TELEPORT_CHARGE_TIME = 40;
    public static final int ATTACK_TELEPORT_INTERVAL = 60;
    public static final int ATTACK_TELEPORT_CONSIDERATION_RADIUS = 30;
    public static final float ATTACK_TELEPORT_DAMAGE = 8.0f;
    public static final int ATTACK_TELEPORT_DAMAGE_RADIUS = 4;
    public static final int NUM_LEGENDARY_PRESENTS_MIN = 6;
    public static final int NUM_LEGENDARY_PRESENTS_MAX = 10;
    public static final int NUM_RARE_PRESENTS_MIN = 10;
    public static final int NUM_RARE_PRESENTS_MAX = 16;
    public static final int NUM_BASIC_PRESENTS_MIN = 12;
    public static final int NUM_BASIC_PRESENTS_MAX = 20;
    public static final int AMT_XP_DROP = 4800;
    public static final int NUM_XP_ORBS_MIN = 32;
    public static final int NUM_XP_ORBS_MAX = 48;
    private static final Vector3d[] HORIZONTALS = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, -1.0)};
    private static final Vector3d[] DIAGONALS = new Vector3d[]{new Vector3d(1.0, 0.0, 1.0), new Vector3d(1.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, 1.0)};
    private Phase currentPhase = Phase.SLEIGHS;
    private boolean isTeleportCharging;
    private Vector3d teleportTarget;
    private final ServerBossInfo bossEvent = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    private int hitAnimTimer;
    private int sleighAnimTimer;
    private int teleportAnimTimer;
    private boolean isDamagedByPlayer;

    public AngrySantaEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 4));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new PhaseSwitchGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SleighAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ExplosivePresentsAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportGoal(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SANTA_PHASE, (Object)Phase.SLEIGHS.ordinal());
        this.field_70180_af.func_187214_a(ATTACK_SLEIGHS_ANIM_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_TELEPORT_ANIM_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_HIT_ANIM_TIMER, (Object)0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.currentPhase = Phase.SLEIGHS;
    }

    public boolean func_180431_b(DamageSource dmgSource) {
        return dmgSource.func_94541_c();
    }

    private void createBossBar() {
        this.bossEvent.func_186735_a(this.func_110143_aJ() / 200.0f);
        AxisAlignedBB areaOfEffect = new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(40.0);
        List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, areaOfEffect);
        for (PlayerEntity playerEntity : playerList) {
            this.bossEvent.func_186760_a((ServerPlayerEntity)playerEntity);
        }
    }

    public void setPhase(Phase phase) {
        this.currentPhase = phase;
        this.field_70180_af.func_187227_b(SANTA_PHASE, (Object)phase.ordinal());
    }

    public void changePhaseRandomly() {
        Phase newPhase;
        this.currentPhase = newPhase = Phase.values()[this.field_70146_Z.nextInt(Phase.values().length)];
        this.field_70180_af.func_187227_b(SANTA_PHASE, (Object)newPhase.ordinal());
    }

    public float getAttackIntervalMultiplier() {
        int currentHealth = (int)this.func_110143_aJ();
        return currentHealth >= 150 ? 1.0f : (currentHealth >= 100 ? 1.5f : (currentHealth >= 50 ? 2.0f : 2.5f));
    }

    public void fireHorizontalSleighs() {
        for (Vector3d horizontal : HORIZONTALS) {
            this.fireSleigh(horizontal);
        }
    }

    public void fireDiagonalSleighs() {
        for (Vector3d diagonal : DIAGONALS) {
            this.fireSleigh(diagonal);
        }
    }

    public void fireSleigh(Vector3d vector) {
        this.field_70180_af.func_187227_b(ATTACK_SLEIGHS_ANIM_TIMER, (Object)20);
        this.sleighAnimTimer = 20;
        SleighEntity sleighEntity = ((SleighEntity)((EntityType)ChristmasEntities.SLEIGH.get()).func_200721_a(this.field_70170_p)).setRotation(vector);
        sleighEntity.func_233576_c_(this.func_213303_ch().func_178787_e(sleighEntity.func_189651_aD().func_216372_d(3.0, 3.0, 3.0)));
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_SUMMON_SLEIGHS.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)sleighEntity);
        for (int i = 0; i < 5; ++i) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197601_L, sleighEntity.func_213303_ch().field_72450_a + this.field_70146_Z.nextDouble(), sleighEntity.func_213303_ch().field_72448_b + this.field_70146_Z.nextDouble(), sleighEntity.func_213303_ch().field_72449_c + this.field_70146_Z.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void spawnExplosives(List<PlayerEntity> playerEntities) {
        for (PlayerEntity playerEntity : playerEntities) {
            if (!playerEntity.func_70089_S()) continue;
            Vector3d playerPos = playerEntity.func_213303_ch();
            ExplosivePresentEntity explosive = (ExplosivePresentEntity)((EntityType)ChristmasEntities.EXPLOSIVE_PRESENT.get()).func_200721_a(this.field_70170_p);
            Vector3d explosivePos = playerPos.func_178787_e(new Vector3d(0.0, 2.0, 0.0));
            explosive.func_233576_c_(explosivePos);
            for (int i = 0; i < 5; ++i) {
                this.summonPresentsParticles(explosivePos);
            }
            this.field_70170_p.func_217376_c((Entity)explosive);
        }
    }

    public void startTeleportAttack(Vector3d target) {
        this.teleportTarget = target;
        this.field_70180_af.func_187227_b(ATTACK_TELEPORT_ANIM_TIMER, (Object)40);
        this.teleportAnimTimer = 40;
        this.isTeleportCharging = true;
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_PREPARE_TELEPORT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        this.field_70170_p.func_184133_a(null, new BlockPos(target), (SoundEvent)ChristmasSounds.SANTA_PREPARE_TELEPORT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
    }

    public void stopTeleportCharging() {
        this.isTeleportCharging = false;
    }

    public void teleportAttack(Vector3d position) {
        this.isTeleportCharging = false;
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_TELEPORT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        this.func_70634_a(position.field_72450_a, position.field_72448_b + 2.0, position.field_72449_c);
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_TELEPORT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        List playerEntities = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g((double)(4.0f / this.getAttackIntervalMultiplier())));
        this.summonStompParticles(position);
        for (PlayerEntity playerEntity : playerEntities) {
            playerEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 8.0f * this.getAttackIntervalMultiplier());
        }
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        if (this.func_174813_aQ().func_186662_g(1.0).func_72326_a(playerEntity.func_174813_aQ())) {
            playerEntity.func_70097_a(DamageSource.field_76377_j, 12.0f);
            playerEntity.func_213293_j(this.field_70146_Z.nextDouble() * 2.0, this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble() * 2.0);
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ChristmasSounds.SANTA_FLICK.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.hitAnimTimer = 10;
        }
    }

    public Phase getPhase() {
        return this.currentPhase;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d()) {
            this.currentPhase = Phase.values()[(Integer)this.field_70180_af.func_187225_a(SANTA_PHASE)];
            if (this.currentPhase == Phase.SLEIGHS) {
                this.sleighAnimTimer = (Integer)this.field_70180_af.func_187225_a(ATTACK_SLEIGHS_ANIM_TIMER);
            }
            if (this.currentPhase == Phase.TELEPORT) {
                this.teleportAnimTimer = (Integer)this.field_70180_af.func_187225_a(ATTACK_TELEPORT_ANIM_TIMER);
            }
            this.hitAnimTimer = (Integer)this.field_70180_af.func_187225_a(ATTACK_HIT_ANIM_TIMER);
        } else {
            if (this.sleighAnimTimer > 0) {
                --this.sleighAnimTimer;
                this.field_70180_af.func_187227_b(ATTACK_SLEIGHS_ANIM_TIMER, (Object)this.sleighAnimTimer);
            }
            if (this.teleportAnimTimer > 0) {
                --this.teleportAnimTimer;
                this.field_70180_af.func_187227_b(ATTACK_TELEPORT_ANIM_TIMER, (Object)this.teleportAnimTimer);
            }
            if (this.hitAnimTimer > 0) {
                --this.hitAnimTimer;
                this.field_70180_af.func_187227_b(ATTACK_HIT_ANIM_TIMER, (Object)this.hitAnimTimer);
            }
            if (this.isTeleportCharging) {
                this.summonTeleportationParticles(this.func_213303_ch());
                this.summonTeleportationParticles(this.teleportTarget);
            }
            if (this.currentPhase == Phase.PRESENTS) {
                this.summonSantaPresentsParticles();
            }
            if (this.func_70089_S() && this.field_70170_p.func_82737_E() % 60L == 0L) {
                if (this.bossEvent == null) {
                    this.createBossBar();
                }
                AxisAlignedBB areaOfEffect = new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(40.0);
                List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, areaOfEffect);
                for (ServerPlayerEntity serverPlayerEntity : this.bossEvent.func_186757_c()) {
                    if (playerList.contains(serverPlayerEntity)) continue;
                    this.bossEvent.func_186761_b(serverPlayerEntity);
                }
                for (PlayerEntity playerEntity : playerList) {
                    ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
                    if (this.bossEvent.func_186757_c().contains(serverPlayerEntity)) continue;
                    this.bossEvent.func_186760_a((ServerPlayerEntity)playerEntity);
                }
            }
        }
    }

    private void summonPresentsParticles(Vector3d pos) {
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        BasicParticleType particleType = ParticleTypes.field_197601_L;
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, pos.field_72450_a, pos.field_72448_b + d1, pos.field_72449_c, 2, d0, d1, d2, 0.0);
    }

    private void summonSantaPresentsParticles() {
        Vector3d pos = this.func_213303_ch();
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        BasicParticleType particleType = ParticleTypes.field_197601_L;
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, pos.field_72450_a + Math.random() * 2.0 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), pos.field_72448_b + d1, pos.field_72449_c + Math.random() * 2.0 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), 2, d0, d1, d2, 0.0);
    }

    private void summonTeleportationParticles(Vector3d pos) {
        double d0 = Math.random() * 0.1 + 0.25;
        double d1 = Math.random() * 0.1 + 0.25;
        double d2 = Math.random() * 0.1 + 0.25;
        double d = Math.random();
        BasicParticleType particleType = d < 0.5 ? (BasicParticleType)ChristmasParticles.CHRISTMAS_SANTA_GREEN_SPAWN_PARTICLE.get() : (BasicParticleType)ChristmasParticles.CHRISTMAS_SANTA_RED_SPAWN_PARTICLE.get();
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, pos.field_72450_a, pos.field_72448_b + d1, pos.field_72449_c, 2, d0, d1, d2, 0.0);
    }

    private void summonStompParticles(Vector3d pos) {
        BasicParticleType particleType = ParticleTypes.field_197613_f;
        for (int i = 0; i < 25; ++i) {
            double d0 = Math.random() * 4.0 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            double d1 = Math.random() * 1.5;
            double d2 = Math.random() * 4.0 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            double dv0 = Math.random() * 0.1 + 0.25;
            double dv1 = Math.random() * 0.1 + 0.25;
            double dv2 = Math.random() * 0.1 + 0.25;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, pos.field_72450_a + d0, pos.field_72448_b + d1, pos.field_72449_c + d2, 2, dv0, dv1, dv2, 0.0);
        }
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        for (ItemStack gift : this.generateDrops()) {
            this.func_199701_a_(gift);
        }
        int numOrbs = this.field_70146_Z.nextInt(16) + 32;
        for (int i = 0; i < numOrbs; ++i) {
            int xpDrop = ExperienceOrbEntity.func_70527_a((int)((int)(1.0 / (double)numOrbs * 4800.0)));
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), xpDrop));
        }
    }

    private List<ItemStack> generateDrops() {
        int i;
        int numLegendaryPresents = this.field_70146_Z.nextInt(4) + 6;
        int numRarePresents = this.field_70146_Z.nextInt(6) + 10;
        int numBasicPresents = this.field_70146_Z.nextInt(8) + 12;
        LootContext ctx = this.func_213363_a(true, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
        ArrayList gifts = Lists.newArrayList();
        for (i = 0; i < numLegendaryPresents; ++i) {
            ItemStack legendaryGift = SantaGifts.generateGift(SantaGiftType.LEGENDARY, this, (ServerWorld)this.field_70170_p, ctx);
            gifts.add(legendaryGift);
        }
        for (i = 0; i < numRarePresents; ++i) {
            ItemStack rareGift = SantaGifts.generateGift(SantaGiftType.RARE, this, (ServerWorld)this.field_70170_p, ctx);
            gifts.add(rareGift);
        }
        for (i = 0; i < numBasicPresents; ++i) {
            ItemStack basicGift = SantaGifts.generateGift(SantaGiftType.BASIC, this, (ServerWorld)this.field_70170_p, ctx);
            gifts.add(basicGift);
        }
        gifts.add(((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).func_190903_i());
        return gifts;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        boolean flag = super.func_70097_a(p_70097_1_, p_70097_2_);
        if (p_70097_1_.func_76346_g() instanceof PlayerEntity) {
            this.isDamagedByPlayer = true;
        }
        this.bossEvent.func_186735_a(this.func_110143_aJ() / 200.0f);
        return flag;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (!this.isDamagedByPlayer) {
            AxisAlignedBB searchBox = new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(40.0);
            List playerEntities = this.field_70170_p.func_217357_a(PlayerEntity.class, searchBox);
            for (PlayerEntity playerEntity : playerEntities) {
                SantaEvent.AngryDie event = new SantaEvent.AngryDie(this, playerEntity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
        this.bossEvent.func_201360_b();
    }

    public boolean isDamagedByPlayer() {
        return this.isDamagedByPlayer;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ChristmasSounds.SANTA_ANGRY_PASSIVE.get();
    }

    @Override
    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.hitAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.attack", Boolean.valueOf(false)));
        } else if (this.currentPhase == Phase.SLEIGHS && this.sleighAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon_sleighs", Boolean.valueOf(true)));
        } else if (this.currentPhase == Phase.TELEPORT && this.teleportAnimTimer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.teleporting", Boolean.valueOf(false)));
        } else if (this.currentPhase == Phase.PRESENTS) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon", Boolean.valueOf(true)));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("IsDamagedByPlayer", this.isDamagedByPlayer);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.isDamagedByPlayer = nbt.func_74767_n("IsDamagedByPlayer");
    }
}

