/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SleighEntity
extends Entity
implements IAnimatable {
    public static final String ENTITY_ID = "sleigh";
    public static final float ENTITY_BOX_SIZE = 2.0f;
    public static final float ENTITY_BOX_HEIGHT = 0.75f;
    @OnlyIn(value=Dist.CLIENT)
    private double lxd;
    @OnlyIn(value=Dist.CLIENT)
    private double lyd;
    @OnlyIn(value=Dist.CLIENT)
    private double lzd;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int remainingCharging = Integer.MAX_VALUE;
    private boolean isCharged;
    private int remainingLifespan = Integer.MAX_VALUE;
    private boolean isMoving;

    public SleighEntity(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.remainingCharging = 10;
        this.remainingLifespan = 80;
        this.field_70145_X = false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.remainingCharging > 0) {
            this.func_213317_d(this.func_189651_aD().func_216372_d(0.01, 0.01, 0.01));
        }
        if (!this.isCharged && --this.remainingCharging <= 0) {
            this.func_213317_d(this.func_189651_aD());
            this.isCharged = true;
            this.isMoving = true;
        }
        if (this.isMoving && --this.remainingLifespan <= 0) {
            this.explode(false);
        }
        if (!this.func_189652_ae() && !this.func_233570_aj_()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        if (!this.isDiagonal() && this.isMoving && this.func_213322_ci().field_72450_a == 0.0 && this.func_213322_ci().field_72449_c == 0.0) {
            this.func_213317_d(this.func_189651_aD());
            this.func_233576_c_(this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0));
        } else if (this.isDiagonal() && this.isMoving && (this.func_213322_ci().field_72450_a == 0.0 || this.func_213322_ci().field_72449_c == 0.0)) {
            this.func_213317_d(this.func_189651_aD());
            this.func_233576_c_(this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0));
        }
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        super.func_70100_b_(playerEntity);
        if (playerEntity.func_174813_aQ().func_72326_a(this.func_174813_aQ())) {
            this.explode(true);
        }
    }

    public boolean func_230269_aK_() {
        return true;
    }

    public SleighEntity setRotation(Vector3d vector) {
        this.field_70177_z = (float)Math.atan2(vector.field_72449_c, vector.field_72450_a) * 180.0f / (float)Math.PI;
        return this;
    }

    public boolean isDiagonal() {
        return this.field_70177_z % 90.0f != 0.0f;
    }

    private void explode(boolean isHitPlayer) {
        float explosivePower = isHitPlayer ? 3.0f : 1.0f;
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), explosivePower, Explosion.Mode.NONE);
        this.func_70106_y();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.func_213293_j(this.lxd, this.lyd, this.lzd);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.lxd = p_70016_1_;
        this.lyd = p_70016_3_;
        this.lzd = p_70016_5_;
        this.func_213293_j(this.lxd, this.lyd, this.lzd);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

