/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy;

import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGiftType;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.SantaGifts;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.happy.SummonGiftsGoal;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.sound.christmas.SantaSummonSound;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class HappySantaEntity
extends BaseSantaEntity {
    public static final DataParameter<Boolean> IS_SUMMONING = EntityDataManager.func_187226_a(HappySantaEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final String ENTITY_ID = "happy_santa";
    public static final int DEFAULT_DESPAWN_DELAY = 12000;
    public static final int NUM_GIFTS_TO_SUMMON = 150;
    public static final int GIFT_SUMMON_RADIUS = 20;
    public static final int GIFT_SUMMON_HEIGHT = 5;
    public static final int GIFT_LIFESPAN = 160;
    public static final int GIFT_SPAWN_INTERVAL_MIN = 5;
    public static final int GIFT_SPAWN_INTERVAL_MAX = 10;
    public static final double BASIC_GIFT_SPAWN_CHANCE_THRESHOLD = 1.0;
    public static final double RARE_GIFT_SPAWN_CHANCE_THRESHOLD = 0.25;
    public static final double LEGENDARY_GIFT_SPAWN_CHANCE_THRESHOLD = 0.05;
    private BlockPos summoningPos = null;
    private boolean hasStartedSummoningGifts = false;
    private boolean hasSummonedGifts = false;
    private boolean isSummoning = false;
    private int giftsRemaining = -1;
    private int despawnDelay;
    private SantaSummonSound summonSound;
    private AxisAlignedBB areaOfEffect;
    private final ServerBossInfo bossEvent = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

    public HappySantaEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SUMMONING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SummonGiftsGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean isSummoning() {
        return this.isSummoning;
    }

    public boolean hasSummonedGifts() {
        return this.hasSummonedGifts;
    }

    public int getGiftsRemaining() {
        return this.giftsRemaining;
    }

    public void startDropParty() {
        if (!this.hasStartedSummoningGifts) {
            this.giftsRemaining = 150;
        }
        this.isSummoning = true;
        this.field_70180_af.func_187227_b(IS_SUMMONING, (Object)true);
        this.hasStartedSummoningGifts = true;
        if (this.summoningPos == null) {
            this.summoningPos = this.func_233580_cy_();
        }
        this.summonSound = new SantaSummonSound(this.func_233580_cy_());
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.summonSound);
        if (!this.field_70170_p.func_201670_d()) {
            this.bossEvent.func_186735_a((float)this.giftsRemaining / 150.0f);
            this.areaOfEffect = new AxisAlignedBB(this.summoningPos).func_186662_g(40.0);
            List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, this.areaOfEffect);
            for (PlayerEntity playerEntity : playerList) {
                this.bossEvent.func_186760_a((ServerPlayerEntity)playerEntity);
            }
        }
    }

    public void stopDropParty() {
        this.isSummoning = false;
        this.field_70180_af.func_187227_b(IS_SUMMONING, (Object)false);
        this.hasSummonedGifts = true;
        this.summoningPos = null;
        if (this.summonSound != null) {
            this.summonSound.stopTrack();
        }
        this.bossEvent.func_201360_b();
        this.despawnDelay = 12000;
        this.func_199701_a_(((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).func_190903_i());
        if (!this.field_70170_p.func_201670_d()) {
            AxisAlignedBB searchBox = new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(40.0);
            List playerEntities = this.field_70170_p.func_217357_a(PlayerEntity.class, searchBox);
            for (PlayerEntity playerEntity : playerEntities) {
                SantaEvent.CompleteDropParty event = new SantaEvent.CompleteDropParty(this, playerEntity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
    }

    public void summonGift() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        int randomX = this.field_70146_Z.nextInt(20) * (this.field_70146_Z.nextBoolean() ? 1 : -1);
        int randomY = this.field_70146_Z.nextInt(5);
        int randomZ = this.field_70146_Z.nextInt(20) * (this.field_70146_Z.nextBoolean() ? 1 : -1);
        BlockPos randomPos = this.func_233580_cy_().func_177982_a(randomX, randomY, randomZ);
        BlockState currState = this.field_70170_p.func_180495_p(randomPos);
        for (int counter = 0; !this.field_70170_p.func_180495_p(randomPos).func_203425_a(Blocks.field_150350_a) && counter <= 20; ++counter) {
            randomPos = randomPos.func_177984_a();
        }
        if (!this.field_70170_p.func_180495_p(randomPos).func_203425_a(Blocks.field_150350_a)) {
            return;
        }
        ItemStack giftItem = ItemStack.field_190927_a;
        LootContext ctx = this.func_213363_a(true, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d);
        BasicParticleType particleType = null;
        double giftChance = this.field_70146_Z.nextDouble();
        if (giftChance < 0.05) {
            giftItem = SantaGifts.generateGift(SantaGiftType.LEGENDARY, this, (ServerWorld)this.field_70170_p, ctx);
            particleType = (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GOLD_PARTICLE.get();
        } else if (giftChance < 0.25) {
            giftItem = SantaGifts.generateGift(SantaGiftType.RARE, this, (ServerWorld)this.field_70170_p, ctx);
            particleType = (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get();
        } else {
            giftItem = SantaGifts.generateGift(SantaGiftType.BASIC, this, (ServerWorld)this.field_70170_p, ctx);
            particleType = (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_BLUE_PARTICLE.get();
        }
        ItemEntity giftEntity = new ItemEntity(this.field_70170_p, (double)randomPos.func_177958_n(), (double)randomPos.func_177956_o(), (double)randomPos.func_177952_p(), giftItem);
        giftEntity.lifespan = 160;
        for (int i = 0; i < 3; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, (double)randomPos.func_177958_n() + this.field_70146_Z.nextDouble(), (double)randomPos.func_177956_o() + this.field_70146_Z.nextDouble(), (double)randomPos.func_177952_p() + this.field_70146_Z.nextDouble(), 1, d0, d1, d2, 0.0);
        }
        this.field_70170_p.func_217376_c((Entity)giftEntity);
        this.field_70170_p.func_184148_a(null, (double)randomPos.func_177958_n(), (double)randomPos.func_177956_o(), (double)randomPos.func_177952_p(), (SoundEvent)ChristmasSounds.SANTA_ITEM_APPEAR.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        --this.giftsRemaining;
        this.bossEvent.func_186735_a((float)this.giftsRemaining / 150.0f);
    }

    public void createSummoningParticle() {
        double d0 = (double)(this.field_70146_Z.nextFloat() * 0.1f) + 0.25;
        double d1 = (double)(this.field_70146_Z.nextFloat() * 0.1f) + 0.25;
        double d2 = (double)(this.field_70146_Z.nextFloat() * 0.1f) + 0.25;
        double d = this.field_70146_Z.nextDouble();
        BasicParticleType particleType = d < 0.25 ? (BasicParticleType)ChristmasParticles.CHRISTMAS_SMALL_RED_PARTICLE.get() : (d < 0.5 ? (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_RED_PARTICLE.get() : (d < 0.75 ? (BasicParticleType)ChristmasParticles.CHRISTMAS_SMALL_GREEN_PARTICLE.get() : (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get()));
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)particleType, this.func_226277_ct_(), this.func_226278_cu_() + d1 + 1.5, this.func_226281_cx_(), 2, d0, d1, d2, 0.0);
    }

    public BlockPos getSummoningPos() {
        return this.summoningPos;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("HasSummonedGifts", this.hasSummonedGifts);
        nbt.func_74757_a("HasStartedSummoningGifts", this.hasStartedSummoningGifts);
        nbt.func_74768_a("GiftsRemaining", this.giftsRemaining);
        nbt.func_74768_a("DespawnDelay", this.despawnDelay);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.hasSummonedGifts = nbt.func_74767_n("HasSummonedGifts");
        this.hasStartedSummoningGifts = nbt.func_74767_n("HasStartedSummoningGifts");
        this.giftsRemaining = nbt.func_74762_e("GiftsRemaining");
        this.despawnDelay = nbt.func_74762_e("DespawnDelay");
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        this.bossEvent.func_201360_b();
        this.isSummoning = false;
        if (this.summonSound != null) {
            this.summonSound.stopTrack();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d()) {
            this.isSummoning = (Boolean)this.field_70180_af.func_187225_a(IS_SUMMONING);
        } else if (this.isSummoning) {
            this.createSummoningParticle();
            if (this.func_70089_S() && this.field_70170_p.func_82737_E() % 60L == 0L) {
                List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, this.areaOfEffect);
                for (ServerPlayerEntity serverPlayerEntity : this.bossEvent.func_186757_c()) {
                    if (playerList.contains(serverPlayerEntity)) continue;
                    this.bossEvent.func_186761_b(serverPlayerEntity);
                }
                for (PlayerEntity playerEntity : playerList) {
                    ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
                    if (this.bossEvent.func_186757_c().contains(serverPlayerEntity)) continue;
                    this.bossEvent.func_186760_a((ServerPlayerEntity)playerEntity);
                }
            }
        } else {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ChristmasSounds.SANTA_PASSIVE.get();
    }

    @Override
    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isSummoning) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.santa.summon", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return super.predicate(event);
    }
}

