/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.events.christmas.handlers;

import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.angry.AngrySantaEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.ChristmasStarEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.GingerbreadConversionEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.GrinchEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaEvent;
import com.jumpcutfindo.happyholidays.common.events.christmas.StockingEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.food.ChristmasFoodItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.music.SheetMusicItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTriggers;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="happyholidays", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChristmasEvents {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        PlayerEntity playerEntity;
        EffectInstance effectInstance;
        if (event.getEntity() instanceof PlayerEntity && event.getItem().func_222117_E() && (effectInstance = (playerEntity = (PlayerEntity)event.getEntity()).func_70660_b((Effect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get())) != null) {
            ItemStack foodItemStack = event.getItem();
            int effectAmplifier = effectInstance.func_76458_c();
            int nutritionValue = foodItemStack.func_77973_b().func_219967_s().func_221466_a();
            if (ChristmasFoodItem.isChristmasFood(foodItemStack.getStack())) {
                playerEntity.func_71024_bL().func_75122_a((int)((double)(effectAmplifier + 1) * 0.2 * (double)nutritionValue), 0.0f);
            } else {
                playerEntity.func_71024_bL().func_75122_a((int)((double)(effectAmplifier + 1) * 0.1 * (double)nutritionValue), 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof PlayerEntity && ChristmasBlocks.isInfluencedByStar(event.getPlacedBlock().func_177230_c())) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
            ChristmasStarTileEntity starTileEntity = ChristmasStarTileEntity.getStarInfluencingBlock(playerEntity.field_70170_p, event.getPos());
            if (starTileEntity != null && starTileEntity.isPosAffected(event.getPos())) {
                BlockPos placedBlockPos = event.getBlockSnapshot().getPos();
                int particleCount = starTileEntity.getCurrentTier() + (starTileEntity.isBonusActive() ? 1 : 0);
                for (int i = 0; i < starTileEntity.getCurrentTier(); ++i) {
                    double d0 = (double)(playerEntity.func_70681_au().nextFloat() * 0.1f) + 0.25;
                    double d1 = (double)(playerEntity.func_70681_au().nextFloat() * 0.1f) + 0.25;
                    double d2 = (double)(playerEntity.func_70681_au().nextFloat() * 0.1f) + 0.25;
                    BasicParticleType particleType = playerEntity.func_70681_au().nextBoolean() ? (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_RED_PARTICLE.get() : (BasicParticleType)ChristmasParticles.CHRISTMAS_MEDIUM_GREEN_PARTICLE.get();
                    ((ServerWorld)playerEntity.field_70170_p).func_195598_a((IParticleData)particleType, (double)placedBlockPos.func_177958_n() + 0.5, (double)placedBlockPos.func_177956_o() + 0.5, (double)placedBlockPos.func_177952_p() + 0.5, 1, d0, d1, d2, 0.0);
                }
                ((ServerWorld)playerEntity.field_70170_p).func_184133_a(null, event.getPos(), (SoundEvent)ChristmasSounds.CHRISTMAS_STAR_BLOCK_PLACE.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onItemInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getEntity();
            ItemStack itemInHand = playerEntity.func_184586_b(event.getHand());
            BlockState blockState = playerEntity.field_70170_p.func_180495_p(event.getPos());
            if (itemInHand.func_77973_b() instanceof SheetMusicItem && blockState.func_203425_a((Block)ChristmasBlocks.MUSIC_BOX.get())) {
                ChristmasTriggers.CHRISTMAS_PLAY_MUSIC_BOX.trigger(playerEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onGingerbreadConversion(GingerbreadConversionEvent event) {
        if (event instanceof GingerbreadConversionEvent.ToSoggy) {
            ChristmasTriggers.CHRISTMAS_GINGERBREAD_MAN_TURN_SOGGY.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof GingerbreadConversionEvent.ToDry) {
            ChristmasTriggers.CHRISTMAS_GINGERBREAD_MAN_TURN_DRY.trigger((ServerPlayerEntity)event.getPlayerEntity());
        }
    }

    @SubscribeEvent
    public static void onSantaElfInteract(SantaElfEvent event) {
        if (event instanceof SantaElfEvent.Summon) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_SUMMON.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof SantaElfEvent.Trade) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_TRADE.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof SantaElfEvent.CompleteRequest) {
            ChristmasTriggers.CHRISTMAS_SANTA_ELF_COMPLETE_REQUEST.trigger((ServerPlayerEntity)event.getPlayerEntity());
            if (((SantaElfEvent.CompleteRequest)event).getTimeTaken() <= 6000) {
                ChristmasTriggers.CHRISTMAS_SANTA_ELF_COMPLETE_REQUEST_QUICK.trigger((ServerPlayerEntity)event.getPlayerEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onGrinchInteract(GrinchEvent event) {
        if (event instanceof GrinchEvent.Encounter) {
            ChristmasTriggers.CHRISTMAS_GRINCH_ENCOUNTER.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof GrinchEvent.Appease) {
            ChristmasTriggers.CHRISTMAS_GRINCH_APPEASE.trigger((ServerPlayerEntity)event.getPlayerEntity());
        }
    }

    @SubscribeEvent
    public static void onSantaInteract(SantaEvent event) {
        if (event instanceof SantaEvent.AngryDie) {
            ChristmasTriggers.CHRISTMAS_SANTA_ANGRY_DIE.trigger((ServerPlayerEntity)event.getPlayerEntity());
            AngrySantaEntity angrySantaEntity = (AngrySantaEntity)event.getSantaEntity();
            if (!angrySantaEntity.isDamagedByPlayer()) {
                ChristmasTriggers.CHRISTMAS_SANTA_NO_TOUCHY.trigger((ServerPlayerEntity)event.getPlayerEntity());
            }
        } else if (event instanceof SantaEvent.CompleteDropParty) {
            ChristmasTriggers.CHRISTMAS_SANTA_DROP_PARTY_COMPLETE.trigger((ServerPlayerEntity)event.getPlayerEntity());
        }
    }

    @SubscribeEvent
    public static void onStockingFill(StockingEvent event) {
        if (event instanceof StockingEvent.Fill) {
            ChristmasTriggers.CHRISTMAS_STOCKING_FILL.trigger((ServerPlayerEntity)event.getPlayerEntity());
        }
    }

    @SubscribeEvent
    public static void onChristmasStarInteract(ChristmasStarEvent event) {
        if (event instanceof ChristmasStarEvent.PutOrnament) {
            ChristmasTriggers.CHRISTMAS_STAR_PUT_ORNAMENT.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof ChristmasStarEvent.IncreaseTier) {
            ChristmasStarEvent.IncreaseTier increaseTierEvent = (ChristmasStarEvent.IncreaseTier)event;
            if (increaseTierEvent.getTier() == 5) {
                ChristmasTriggers.CHRISTMAS_STAR_MAXED_TIER.trigger((ServerPlayerEntity)event.getPlayerEntity());
            }
        } else if (event instanceof ChristmasStarEvent.SummonSanta) {
            ChristmasTriggers.CHRISTMAS_STAR_SUMMON_SANTA.trigger((ServerPlayerEntity)event.getPlayerEntity());
        } else if (event instanceof ChristmasStarEvent.ReachBonus) {
            ChristmasTriggers.CHRISTMAS_STAR_REACH_BONUS.trigger((ServerPlayerEntity)event.getPlayerEntity());
        }
    }
}

