/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.events.christmas.handlers;

import com.jumpcutfindo.happyholidays.common.capabilities.christmas.CapabilityNaughtyNice;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.INaughtyNiceHandler;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import java.util.Optional;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="happyholidays", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NaughtyNiceEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        PlayerEntity originalPlayer = event.getOriginal();
        if (event.isWasDeath()) {
            Optional newCapability;
            PlayerEntity newPlayer = event.getPlayer();
            Optional oldCapability = originalPlayer.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
            if (oldCapability.isPresent() && (newCapability = newPlayer.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve()).isPresent()) {
                NaughtyNiceMeter naughtyNiceMeter = (NaughtyNiceMeter)newCapability.get();
                naughtyNiceMeter.setValue(((INaughtyNiceHandler)oldCapability.get()).getValue());
            }
        }
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity killedEntity = event.getEntityLiving();
            if (killedEntity.getClassification(false) != EntityClassification.MONSTER) {
                if (killedEntity instanceof SantaElfEntity) {
                    NaughtyNiceMeter.evaluateAction(player, NaughtyNiceAction.KILL_SANTA_ELF_EVENT);
                } else {
                    NaughtyNiceMeter.evaluateAction(player, NaughtyNiceAction.KILL_PASSIVE_MOB_EVENT);
                }
            } else if (!(killedEntity instanceof BaseSantaEntity)) {
                NaughtyNiceMeter.evaluateAction(player, NaughtyNiceAction.KILL_HOSTILE_MOB_EVENT);
            }
        }
    }
}

