/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.guide;

import com.jumpcutfindo.happyholidays.common.guide.sections.ISection;
import com.jumpcutfindo.happyholidays.common.guide.sections.ImageSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.ItemSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.RecipeSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.SerializedSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.TextSection;
import java.util.List;
import java.util.stream.Collectors;

public class Chapter {
    public final String title;
    public final String description;
    public final ImageSection image;
    public List<ISection> unserializedSections;
    private List<SerializedSection> sections;

    public Chapter(String title, String description, ImageSection image) {
        this.title = title;
        this.description = description;
        this.image = image;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ISection> getSections() {
        if (this.unserializedSections == null) {
            this.unserializedSections = this.sections.stream().map(serializedSection -> {
                if (serializedSection.type.equals("text")) {
                    return new TextSection(serializedSection.title, serializedSection.caption, serializedSection.content);
                }
                if (serializedSection.type.equals("image")) {
                    return new ImageSection(serializedSection.source, serializedSection.x, serializedSection.y, serializedSection.width, serializedSection.height, 1.0f);
                }
                if (serializedSection.type.equals("items")) {
                    return ItemSection.from(serializedSection.items);
                }
                if (serializedSection.type.equals("recipes")) {
                    return RecipeSection.from(serializedSection.recipes);
                }
                return null;
            }).collect(Collectors.toList());
        }
        return this.unserializedSections;
    }

    public ImageSection getImage() {
        return this.image;
    }
}

