/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.item.christmas.misc;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasRarity;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.sound.christmas.SantaBellSound;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SantaElfBellItem
extends ChristmasItem {
    public static final String ITEM_ID = "santa_elf_bell";
    public static final int ITEM_USE_DURATION = 35;
    public static final int ITEM_COOLDOWN = 24000;
    private static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200916_a(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP).func_200917_a(1).func_200915_b(24000);
    private SantaBellSound bellSound;

    public SantaElfBellItem() {
        super(ITEM_PROPERTIES);
        this.christmasRarity = ChristmasRarity.LEGENDARY;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        CompoundNBT nbt = player.func_184586_b(hand).func_77978_p();
        long nextUseTime = nbt.func_74763_f("NextUseTime");
        if (world.func_82737_E() > nextUseTime) {
            player.func_184598_c(hand);
            player.func_184185_a((SoundEvent)ChristmasSounds.SANTA_ELF_BELL.get(), 1.0f, 1.0f);
            return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)world.func_201670_d());
        }
        long timeRemaining = nbt.func_74763_f("NextUseTime") - world.func_82737_E();
        TranslationTextComponent chatComponent = new TranslationTextComponent("chat.happyholidays.santa_elf_bell.not_ready", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
        chatComponent.func_240699_a_(TextFormatting.RED);
        player.func_146105_b((ITextComponent)chatComponent, true);
        return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)livingEntity;
            BlockPos playerPos = playerEntity.func_233580_cy_();
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74772_a("NextUseTime", world.func_82737_E() + 24000L);
            BlockPos posAhead = HappyHolidaysUtils.getPosInFront(playerEntity.func_174811_aO(), playerPos, 4.0);
            double spawnX = posAhead.func_177958_n();
            double spawnY = posAhead.func_177956_o();
            double spawnZ = posAhead.func_177952_p();
            SantaElfEntity santaElfEntity = (SantaElfEntity)((EntityType)ChristmasEntities.SANTA_ELF.get()).func_200721_a(world);
            santaElfEntity.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)santaElfEntity);
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0);
            world.func_184133_a(null, posAhead, (SoundEvent)ChristmasSounds.SANTA_ELF_ARRIVAL.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            SantaElfEvent.Summon elfSummonEvent = new SantaElfEvent.Summon(playerEntity, santaElfEntity);
            MinecraftForge.EVENT_BUS.post((Event)elfSummonEvent);
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 35;
    }

    public boolean func_77636_d(ItemStack p_77636_1_) {
        return true;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag tooltipFlag) {
        long timeRemaining;
        CompoundNBT nbt = itemStack.func_77978_p();
        if (nbt != null && world != null && (timeRemaining = nbt.func_74763_f("NextUseTime") - world.func_82737_E()) > 0L) {
            TranslationTextComponent textComponent = new TranslationTextComponent("item.happyholidays.santa_elf_bell.cooldown", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
            textComponent.func_240699_a_(TextFormatting.GRAY);
            textComponents.add((ITextComponent)textComponent);
        }
    }
}

