/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.item.christmas.misc;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequest;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasRarity;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ToyPartsRequestItem
extends ChristmasItem {
    public static final String ITEM_ID = "toy_parts_request";
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200916_a(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP).func_200917_a(1);

    public ToyPartsRequestItem() {
        super(ITEM_PROPERTIES);
        this.christmasRarity = ChristmasRarity.UNIQUE;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag tooltipFlag) {
        CompoundNBT nbt = itemStack.func_77978_p();
        if (nbt != null) {
            SantaElfRequest santaElfRequest = SantaElfRequest.fromTag(nbt.func_74775_l("SantaElfRequest"));
            for (SantaElfRequest.SingleElfRequest request : santaElfRequest.getRequestedItems()) {
                StringTextComponent formattableTextComponent = new StringTextComponent(request.toString());
                if (request.isCompleted()) {
                    formattableTextComponent.func_240699_a_(TextFormatting.STRIKETHROUGH);
                }
                textComponents.add((ITextComponent)formattableTextComponent.func_240699_a_(TextFormatting.GRAY));
            }
            long timeRemaining = santaElfRequest.getExpiryTime() - world.func_82737_E();
            if (timeRemaining > 0L) {
                textComponents.add((ITextComponent)new StringTextComponent(""));
                TranslationTextComponent expiryTextComponent = new TranslationTextComponent("item.happyholidays.toy_parts_request.expires_in", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)});
                expiryTextComponent.func_240699_a_(TextFormatting.GRAY);
                textComponents.add((ITextComponent)expiryTextComponent);
            }
        }
    }
}

