/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.tileentity.christmas;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.block.christmas.misc.ChristmasStarBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.misc.ChristmasStarTier;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarContainer;
import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.ChristmasStarEvent;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTileEntities;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.IChristmasTileEntity;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import com.jumpcutfindo.happyholidays.server.data.SantaSummonSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ChristmasStarTileEntity
extends LockableTileEntity
implements IChristmasTileEntity,
ITickableTileEntity {
    public static final String TILE_ENTITY_ID = "christmas_star";
    public static final int SLOTS = 6;
    public static final int BONUS_SLOT_INDEX = 5;
    public static final int MAX_POINTS = 100;
    public static final int MAX_RADIUS_INDEX = 5;
    public static final int[] PLAYER_EFFECT_RADIUS = new int[]{0, 8, 16, 24, 32, 40};
    public static final int[] ENTITY_EFFECT_RADIUS = new int[]{0, 8, 16, 24, 32, 40};
    public static final int[] BLOCK_EFFECT_RADIUS = new int[]{0, 4, 8, 12, 16, 20};
    private int currentTier;
    private int currentPoints;
    private boolean isSummoningSanta;
    private boolean isGoodSanta;
    private int summonSantaProgress;
    private AxisAlignedBB areaOfEffect;
    private final ServerBossInfo summonEvent = new ServerBossInfo((ITextComponent)new TranslationTextComponent("entity.happyholidays.santa_is_coming"), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int code) {
            switch (code) {
                case 0: {
                    return ChristmasStarTileEntity.this.currentTier;
                }
                case 1: {
                    return ChristmasStarTileEntity.this.currentPoints;
                }
            }
            return 0;
        }

        public void func_221477_a(int code, int value) {
            switch (code) {
                case 0: {
                    ChristmasStarTileEntity.this.currentTier = value;
                    break;
                }
                case 1: {
                    ChristmasStarTileEntity.this.currentPoints = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);

    public ChristmasStarTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public ChristmasStarTileEntity() {
        this((TileEntityType)ChristmasTileEntities.CHRISTMAS_STAR_ENTITY_TYPE.get());
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.happyholidays.christmas_star");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInv) {
        return new ChristmasStarContainer(id, playerInv, this);
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int start, int end) {
        return ItemStackHelper.func_188382_a(this.items, (int)start, (int)end);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.items.set(index, (Object)itemStack);
    }

    public boolean func_70300_a(PlayerEntity playerEntity) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return playerEntity.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void applyPlayerEffects() {
        if (!this.field_145850_b.func_201670_d() && this.currentTier > 0) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)PLAYER_EFFECT_RADIUS[this.currentTier]);
            List playerList = this.field_145850_b.func_217357_a(PlayerEntity.class, axisAlignedBB);
            for (PlayerEntity playerEntity : playerList) {
                if (playerEntity.func_70660_b((Effect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get()) == null) {
                    ((ServerWorld)this.field_145850_b).func_184133_a(null, playerEntity.func_233580_cy_(), (SoundEvent)ChristmasSounds.CHRISTMAS_STAR_EFFECT_APPLY.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
                playerEntity.func_195064_c(new EffectInstance((Effect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get(), 200, this.currentTier - 1, true, true));
            }
        }
    }

    public void applyEntityEffects() {
        if (!this.field_145850_b.func_201670_d() && this.currentTier > 0) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)ENTITY_EFFECT_RADIUS[this.currentTier]);
            List christmasEntities = this.field_145850_b.func_217357_a(ChristmasEntity.class, axisAlignedBB);
            for (ChristmasEntity entity : christmasEntities) {
                entity.func_195064_c(new EffectInstance((Effect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get(), 200, this.currentTier - 1, true, true));
            }
        }
    }

    public void summonSanta() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            SantaSummonSavedData santaData = (SantaSummonSavedData)serverWorld.func_217481_x().func_215752_a(SantaSummonSavedData::new, "happyholidays_santa");
            this.areaOfEffect = new AxisAlignedBB(this.func_174877_v()).func_186662_g(40.0);
            boolean isTierOK = this.getCurrentTier() >= 5;
            boolean isValidTime = santaData.canSummon(serverWorld.func_82737_E());
            if (!isTierOK) {
                return;
            }
            if (!isValidTime) {
                long timeRemaining = santaData.getNextSummonTime() - serverWorld.func_82737_E();
                for (ServerPlayerEntity serverPlayerEntity : serverWorld.func_217490_a(playerEntity -> this.areaOfEffect.func_72318_a(playerEntity.func_213303_ch()))) {
                    serverPlayerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.happyholidays.christmas_star.santa_not_ready", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)}).func_240699_a_(TextFormatting.RED), UUID.randomUUID());
                }
                return;
            }
            santaData.setLastSummonTime(this.field_145850_b.func_82737_E());
            santaData.func_76185_a();
            int totalValue = 0;
            int totalPlayers = 0;
            for (ServerPlayerEntity serverPlayerEntity : serverWorld.func_217490_a(playerEntity -> this.areaOfEffect.func_72318_a(playerEntity.func_213303_ch()))) {
                int value = NaughtyNiceMeter.getMeterValue((PlayerEntity)serverPlayerEntity);
                totalValue += value;
                ++totalPlayers;
                NaughtyNiceMeter.resetMeter((PlayerEntity)serverPlayerEntity);
                this.summonEvent.func_186735_a((float)this.summonSantaProgress / 200.0f);
                this.summonEvent.func_186760_a(serverPlayerEntity);
            }
            if (totalPlayers == 0) {
                return;
            }
            int averageValue = totalValue / totalPlayers;
            if (averageValue >= 10) {
                this.isGoodSanta = true;
            } else if (averageValue <= -10) {
                this.isGoodSanta = false;
            } else {
                boolean bl = this.isGoodSanta = Math.random() < 0.5;
            }
            if (this.isGoodSanta) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)ChristmasSounds.SANTA_SPAWNING_GOOD.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)ChristmasSounds.SANTA_SPAWNING_BAD.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            this.isSummoningSanta = true;
            this.summonSantaProgress = 200;
        }
    }

    public void finishSummonSanta() {
        BaseSantaEntity santaEntity = null;
        IFormattableTextComponent santaText = null;
        if (this.isGoodSanta) {
            santaEntity = (BaseSantaEntity)((EntityType)ChristmasEntities.HAPPY_SANTA.get()).func_200721_a(this.field_145850_b);
            santaText = new TranslationTextComponent("entity.happyholidays.santa_arrival_happy").func_240699_a_(TextFormatting.AQUA);
        } else {
            santaEntity = (BaseSantaEntity)((EntityType)ChristmasEntities.ANGRY_SANTA.get()).func_200721_a(this.field_145850_b);
            santaText = new TranslationTextComponent("entity.happyholidays.santa_arrival_angry").func_240699_a_(TextFormatting.RED);
        }
        List playerList = this.field_145850_b.func_217357_a(PlayerEntity.class, this.areaOfEffect);
        IFormattableTextComponent finalSantaText = santaText;
        playerList.forEach(arg_0 -> this.lambda$finishSummonSanta$2((ITextComponent)finalSantaText, arg_0));
        santaEntity.func_225653_b_((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, this.func_174877_v().func_177952_p());
        this.field_145850_b.func_217376_c((Entity)santaEntity);
        this.isSummoningSanta = false;
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)ChristmasSounds.SANTA_SPAWN.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        this.summonEvent.func_201360_b();
    }

    public int getCurrentTier() {
        return this.currentTier;
    }

    public boolean isBonusActive() {
        return !((ItemStack)this.items.get(5)).func_190926_b();
    }

    public boolean isPosAffected(BlockPos pos) {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)BLOCK_EFFECT_RADIUS[this.currentTier]).func_197744_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    private void updatePoints() {
        int newPoints = 0;
        ArrayList itemStackList = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStackList.stream().anyMatch(itemStack1 -> ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)itemStack1))) continue;
            itemStackList.add(itemStack);
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                newPoints += 5;
                continue;
            }
            if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                newPoints += 10;
                continue;
            }
            if (!ChristmasItems.isLegendaryOrnamentItem(itemStack)) continue;
            newPoints += 20;
        }
        this.currentPoints = Math.min(newPoints, 100);
        if (this.currentPoints < 20) {
            this.changeTier(0);
        } else if (this.currentPoints < 40) {
            this.changeTier(1);
        } else if (this.currentPoints < 60) {
            this.changeTier(2);
        } else if (this.currentPoints < 80) {
            this.changeTier(3);
        } else if (this.currentPoints < 100) {
            this.changeTier(4);
        } else {
            this.changeTier(5);
        }
    }

    private void changeTier(int newTier) {
        BlockPos blockPos;
        PlayerEntity playerEntity;
        int oldTier = this.currentTier;
        this.currentTier = newTier;
        if (oldTier != newTier && this.field_145850_b != null) {
            ChristmasStarTier starTier = newTier == 0 ? ChristmasStarTier.TIER_0 : (newTier == 1 ? ChristmasStarTier.TIER_1 : (newTier == 2 ? ChristmasStarTier.TIER_2 : (newTier == 3 ? ChristmasStarTier.TIER_3 : (newTier == 4 ? ChristmasStarTier.TIER_4 : ChristmasStarTier.TIER_5))));
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(ChristmasStarBlock.STAR_TIER, (Comparable)((Object)starTier)), 0);
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 1.0f, 1.0f + (float)newTier * 0.1f);
        }
        if (oldTier < newTier && !this.field_145850_b.func_201670_d() && (playerEntity = this.field_145850_b.func_217366_a((double)(blockPos = this.func_174877_v()).func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0, false)) != null) {
            ChristmasStarEvent.IncreaseTier event = new ChristmasStarEvent.IncreaseTier(this, playerEntity);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (this.field_145850_b.func_82737_E() % 80L == 0L) {
                this.applyPlayerEffects();
                this.applyEntityEffects();
            }
            if (this.isSummoningSanta) {
                double d0 = Math.random() * 0.1 + 0.25;
                double d1 = Math.random() * 0.1 + 0.25;
                double d2 = Math.random() * 0.1 + 0.25;
                double d = Math.random();
                BasicParticleType particleType = d < 0.5 ? (BasicParticleType)ChristmasParticles.CHRISTMAS_SANTA_GREEN_SPAWN_PARTICLE.get() : (BasicParticleType)ChristmasParticles.CHRISTMAS_SANTA_RED_SPAWN_PARTICLE.get();
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)particleType, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + d1 + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, 2, d0, d1, d2, 0.0);
                if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                    List playerList = this.field_145850_b.func_217357_a(PlayerEntity.class, this.areaOfEffect);
                    for (ServerPlayerEntity serverPlayerEntity : this.summonEvent.func_186757_c()) {
                        if (playerList.contains(serverPlayerEntity)) continue;
                        this.summonEvent.func_186761_b(serverPlayerEntity);
                    }
                    for (PlayerEntity playerEntity : playerList) {
                        ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
                        if (this.summonEvent.func_186757_c().contains(serverPlayerEntity)) continue;
                        this.summonEvent.func_186760_a((ServerPlayerEntity)playerEntity);
                    }
                }
                this.summonEvent.func_186735_a((float)(200 - this.summonSantaProgress) / 200.0f);
            }
            if (this.isSummoningSanta && --this.summonSantaProgress <= 0) {
                this.finishSummonSanta();
            }
        }
        this.updatePoints();
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.currentTier = nbt.func_74762_e("CurrentTier");
        this.currentPoints = nbt.func_74762_e("CurrentPoints");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        nbt.func_74768_a("CurrentTier", this.currentTier);
        nbt.func_74768_a("CurrentPoints", this.currentPoints);
        return nbt;
    }

    public static ChristmasStarTileEntity getStarInfluencingBlock(World world, BlockPos blockPos) {
        int maxRadius = BLOCK_EFFECT_RADIUS[5];
        AxisAlignedBB blockBoundingBox = new AxisAlignedBB(blockPos).func_186662_g((double)maxRadius);
        List tileEntityList = world.field_147482_g.stream().filter(tileEntity -> tileEntity instanceof ChristmasStarTileEntity && blockBoundingBox.func_197744_e((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p())).collect(Collectors.toList());
        ChristmasStarTileEntity influencingTileEntity = null;
        for (TileEntity tileEntity2 : tileEntityList) {
            if (!(tileEntity2 instanceof ChristmasStarTileEntity)) continue;
            ChristmasStarTileEntity christmasStarTileEntity = (ChristmasStarTileEntity)tileEntity2;
            int effectRadius = BLOCK_EFFECT_RADIUS[christmasStarTileEntity.getCurrentTier()];
            AxisAlignedBB effectBoundingBox = new AxisAlignedBB(tileEntity2.func_174877_v()).func_186662_g((double)effectRadius);
            if (!effectBoundingBox.func_197744_e((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()) || influencingTileEntity != null && christmasStarTileEntity.getCurrentTier() <= influencingTileEntity.getCurrentTier()) continue;
            influencingTileEntity = christmasStarTileEntity;
        }
        return influencingTileEntity;
    }

    public static ChristmasStarTileEntity getStarInfluencingEntity(World world, Vector3d vector3d) {
        int maxRadius = ENTITY_EFFECT_RADIUS[5];
        AxisAlignedBB blockBoundingBox = new AxisAlignedBB(new BlockPos(vector3d)).func_186662_g((double)maxRadius);
        List tileEntityList = world.field_147482_g.stream().filter(tileEntity -> tileEntity instanceof ChristmasStarTileEntity && blockBoundingBox.func_197744_e((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p())).collect(Collectors.toList());
        ChristmasStarTileEntity influencingTileEntity = null;
        for (TileEntity tileEntity2 : tileEntityList) {
            if (!(tileEntity2 instanceof ChristmasStarTileEntity)) continue;
            ChristmasStarTileEntity christmasStarTileEntity = (ChristmasStarTileEntity)tileEntity2;
            int effectRadius = ENTITY_EFFECT_RADIUS[christmasStarTileEntity.getCurrentTier()];
            AxisAlignedBB effectBoundingBox = new AxisAlignedBB(tileEntity2.func_174877_v()).func_186662_g((double)effectRadius);
            if (!effectBoundingBox.func_72318_a(vector3d) || influencingTileEntity != null && christmasStarTileEntity.getCurrentTier() <= influencingTileEntity.getCurrentTier()) continue;
            influencingTileEntity = christmasStarTileEntity;
        }
        return influencingTileEntity;
    }

    private /* synthetic */ void lambda$finishSummonSanta$2(ITextComponent finalSantaText, PlayerEntity playerEntity) {
        playerEntity.func_145747_a(finalSantaText, UUID.randomUUID());
        ChristmasStarEvent.SummonSanta summonEvent = new ChristmasStarEvent.SummonSanta(this, playerEntity);
        MinecraftForge.EVENT_BUS.post((Event)summonEvent);
    }
}

