/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.tileentity.christmas;

import com.jumpcutfindo.happyholidays.common.item.christmas.music.ChristmasMusic;
import com.jumpcutfindo.happyholidays.common.item.christmas.music.SheetMusicItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTileEntities;
import com.jumpcutfindo.happyholidays.common.sound.christmas.MusicBoxSound;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.IChristmasTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MusicBoxTileEntity
extends TileEntity
implements IChristmasTileEntity,
IClearable,
IAnimatable {
    public static final String TILE_ENTITY_ID = "music_box";
    private ItemStack sheetMusic = ItemStack.field_190927_a;
    private MusicBoxSound currentMusic = null;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MusicBoxTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public MusicBoxTileEntity() {
        this((TileEntityType)ChristmasTileEntities.MUSIC_BOX_ENTITY_TYPE.get());
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        if (p_230337_2_.func_150297_b("SheetMusicItem", 10)) {
            this.setSheetMusic(ItemStack.func_199557_a((CompoundNBT)p_230337_2_.func_74775_l("SheetMusicItem")), false);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.getSheetMusic().func_190926_b()) {
            p_189515_1_.func_218657_a("SheetMusicItem", (INBT)this.getSheetMusic().func_77955_b(new CompoundNBT()));
        }
        return p_189515_1_;
    }

    public ItemStack getSheetMusic() {
        return this.sheetMusic;
    }

    public void setSheetMusic(ItemStack itemStack, boolean isPlayerAction) {
        ItemStack itemStackCopy = itemStack.func_77946_l();
        itemStackCopy.func_190920_e(1);
        this.sheetMusic = itemStackCopy;
        this.func_70296_d();
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d() && !isPlayerAction) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void func_174888_l() {
        this.sheetMusic = ItemStack.field_190927_a;
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        nbtTag.func_74757_a("PlayMusic", !this.getSheetMusic().func_190926_b());
        if (this.sheetMusic.func_77973_b() instanceof SheetMusicItem) {
            nbtTag.func_74768_a("SheetMusicId", ((SheetMusicItem)this.sheetMusic.func_77973_b()).getMusic().getId());
        }
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbtTag = pkt.func_148857_g();
        if (nbtTag.func_74767_n("PlayMusic")) {
            int id = nbtTag.func_74762_e("SheetMusicId");
            this.currentMusic = SheetMusicItem.createMusicBoxSound(ChristmasMusic.getMusic(id), this.field_174879_c);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.currentMusic);
        } else if (this.currentMusic != null) {
            this.currentMusic.stopTrack();
            this.currentMusic = null;
        }
    }

    public void stopMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stopTrack();
            this.currentMusic = null;
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.currentMusic != null && !this.currentMusic.func_147667_k()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.playing", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

