/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.tileentity.christmas;

import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc.StockingBlock;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasTileEntities;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.IChristmasTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StockingTileEntity
extends TileEntity
implements IChristmasTileEntity {
    public static final String TILE_ENTITY_ID = "stocking";
    private static final ResourceLocation STOCKING_PRESENTS_LOOT_TABLE = new ResourceLocation("happyholidays:blocks/stocking_presents");
    private boolean isEmpty = true;
    private boolean isDoneForNight = false;
    private Random random = new Random();

    public StockingTileEntity(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public StockingTileEntity() {
        this((TileEntityType)ChristmasTileEntities.STOCKING_ENTITY_TYPE.get());
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isDoneForNight() {
        return this.isDoneForNight;
    }

    public void resetStocking() {
        this.isDoneForNight = false;
    }

    public void fillStocking() {
        this.isEmpty = false;
        this.isDoneForNight = true;
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)StockingBlock.FILLED, (Comparable)Boolean.valueOf(true)), 2);
        for (int i = 0; i < 5; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197632_y, this.random.nextDouble(), this.random.nextDouble() + 0.5, this.random.nextDouble(), 1, d0, d1, d2, 0.0);
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void dropStockingItems() {
        LootTable lootTable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(STOCKING_PRESENTS_LOOT_TABLE);
        LootContext ctx = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.random).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())).func_216015_a(LootParameters.field_216287_g, (Object)this.func_195044_w()).func_216015_a(LootParameters.field_216289_i, (Object)Items.field_151017_I.func_190903_i()).func_216022_a(LootParameterSets.field_216267_h);
        lootTable.func_216113_a(ctx).forEach(itemStack -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)itemStack));
        this.isEmpty = true;
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)StockingBlock.FILLED, (Comparable)Boolean.valueOf(false)), 2);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("IsEmpty", this.isEmpty);
        nbt.func_74757_a("IsDoneForNight", this.isDoneForNight);
        return nbt;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.isEmpty = nbt.func_74767_n("IsEmpty");
        this.isDoneForNight = nbt.func_74767_n("IsDoneForNight");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        nbtTag.func_74757_a("IsEmpty", this.isEmpty);
        nbtTag.func_74757_a("IsDoneForNight", this.isDoneForNight);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbtTag = pkt.func_148857_g();
        this.isEmpty = nbtTag.func_74767_n("IsEmpty");
        this.isDoneForNight = nbtTag.func_74767_n("IsDoneForNight");
    }
}

