/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.utils;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HappyHolidaysUtils {
    public static VoxelShape rotateShape(VoxelShape shape, Rotation rotationDir) {
        double x1 = shape.func_197752_a().field_72340_a;
        double x2 = shape.func_197752_a().field_72336_d;
        double y1 = shape.func_197752_a().field_72338_b;
        double y2 = shape.func_197752_a().field_72337_e;
        double z1 = shape.func_197752_a().field_72339_c;
        double z2 = shape.func_197752_a().field_72334_f;
        if (rotationDir == Rotation.CLOCKWISE_90 || rotationDir == Rotation.COUNTERCLOCKWISE_90) {
            double temp = z1;
            z1 = x1;
            x1 = temp;
            temp = z2;
            z2 = x2;
            x2 = temp;
        }
        if (rotationDir == Rotation.CLOCKWISE_90 || rotationDir == Rotation.CLOCKWISE_180) {
            x1 = 1.0 - x1;
            x2 = 1.0 - x2;
        }
        if (rotationDir == Rotation.COUNTERCLOCKWISE_90 || rotationDir == Rotation.CLOCKWISE_180) {
            z1 = 1.0 - z1;
            z2 = 1.0 - z2;
        }
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape combineShapes(VoxelShape[] voxelShapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : voxelShapes) {
            result = VoxelShapes.func_197878_a((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return result;
    }

    public static BlockPos getPosInFront(Direction facingDirection, BlockPos pos, double offset) {
        BlockPos resultPos = pos;
        if (facingDirection == Direction.NORTH || facingDirection == Direction.UP || facingDirection == Direction.DOWN) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.func_177978_c();
                ++i;
            }
        } else if (facingDirection == Direction.SOUTH) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.func_177968_d();
                ++i;
            }
        } else if (facingDirection == Direction.EAST) {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.func_177974_f();
                ++i;
            }
        } else {
            int i = 0;
            while ((double)i < offset) {
                resultPos = resultPos.func_177976_e();
                ++i;
            }
        }
        return resultPos;
    }

    public static String convertTicksToString(long ticks) {
        long seconds = ticks / 20L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }

    public static BlockPos findBlockInRadius(IWorld world, BlockPos currPos, Block block, int radius) {
        BlockPos startPos = currPos.func_177982_a(-radius, -radius, -radius);
        for (int x = 0; x < radius * 2; ++x) {
            for (int y = 0; y < radius * 2; ++y) {
                for (int z = 0; z < radius * 2; ++z) {
                    BlockPos checkingPos = startPos.func_177982_a(x, y, z);
                    if (!world.func_180495_p(checkingPos).func_177230_c().func_235332_a_(block)) continue;
                    return checkingPos;
                }
            }
        }
        return null;
    }

    public static List<PlayerEntity> findPlayersInRadius(World world, Vector3d pos, double radius) {
        AxisAlignedBB box = new AxisAlignedBB(new BlockPos(pos)).func_186662_g(radius);
        return world.func_217357_a(PlayerEntity.class, box);
    }
}

