/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarContainer;
import com.jumpcutfindo.happyholidays.common.handlers.PacketHandler;
import com.jumpcutfindo.happyholidays.common.network.christmas.SummonSantaPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ChristmasStarScreen
extends AbstractContainerScreen<ChristmasStarContainer> {
    private static final ResourceLocation CHRISTMAS_STAR_GUI = new ResourceLocation("happyholidays", "textures/gui/container/christmas_star.png");
    private static final int[] STAR_HEIGHTS = new int[]{0, 6, 12, 18, 24, 31};

    public ChristmasStarScreen(ChristmasStarContainer screenContainer, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)screenContainer, playerInv, title);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 190;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.createMenuControls();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_96570_(matrixStack, null, mouseX, mouseY);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CHRISTMAS_STAR_GUI);
        int x = (this.f_96543_ - this.getXSize()) / 2;
        int y = (this.f_96544_ - this.getYSize()) / 2;
        this.m_93228_(matrixStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int tier = ((ChristmasStarContainer)this.f_97732_).getCurrentTier();
        this.m_93228_(matrixStack, x + 72, y + 39 + (31 - STAR_HEIGHTS[tier]), 176, 31 - STAR_HEIGHTS[tier], 32, STAR_HEIGHTS[tier]);
        TranslatableComponent tierComponent = new TranslatableComponent("block.happyholidays.christmas_star.tier", new Object[]{tier});
        if (((ChristmasStarContainer)this.f_97732_).blockEntity.isBonusActive()) {
            tierComponent.m_7220_((Component)new TranslatableComponent("block.happyholidays.christmas_star.bonus"));
        }
        this.f_96547_.m_92889_(matrixStack, (Component)tierComponent, (float)(x + this.f_97728_), (float)(y + this.f_97729_), 0x404040);
        String christmasPointsString = String.format("%d", ((ChristmasStarContainer)this.f_97732_).getCurrentPoints());
        this.f_96547_.m_92883_(matrixStack, christmasPointsString, (float)(x + 89 - this.f_96547_.m_92895_(christmasPointsString) / 2), (float)(y + 52), 0x404040);
    }

    protected void m_7025_(PoseStack p_230459_1_, int p_230459_2_, int p_230459_3_) {
        super.m_7025_(p_230459_1_, p_230459_2_, p_230459_3_);
    }

    protected void m_7027_(PoseStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.f_96547_.m_92889_(p_230451_1_, this.getBlockEntity().m_5446_(), (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    private void createMenuControls() {
        int x = (this.f_96543_ - this.getXSize()) / 2;
        int y = (this.f_96544_ - this.getYSize()) / 2;
        this.m_142416_((GuiEventListener)new SummonSantaButton(this, x + 72, y + 39, 32, 31, CommonComponents.f_130655_, pred -> {
            if (((ChristmasStarContainer)this.f_97732_).blockEntity.getCurrentTier() >= 5) {
                Minecraft.m_91087_().m_91152_((Screen)null);
                PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new SummonSantaPacket(((ChristmasStarContainer)this.f_97732_).blockEntity.m_58899_()));
            }
        }));
    }

    public ChristmasStarBlockEntity getBlockEntity() {
        return ((ChristmasStarContainer)this.f_97732_).getBlockEntity();
    }

    public void drawTooltip(PoseStack matrixStack, Component textComponent, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((PoseStack)matrixStack, (List)Lists.newArrayList((Object[])new Component[]{textComponent}), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
    }

    public class SummonSantaButton
    extends Button {
        private static final String SUMMON_SANTA_TOOLTIP = "block.happyholidays.christmas_star.summon_tooltip";
        private final ChristmasStarScreen screen;

        public SummonSantaButton(ChristmasStarScreen screen, int p_i232255_1_, int p_i232255_2_, int p_i232255_3_, int p_i232255_4_, Component p_i232255_5_, Button.OnPress p_i232255_6_) {
            super(p_i232255_1_, p_i232255_2_, p_i232255_3_, p_i232255_4_, p_i232255_5_, p_i232255_6_);
            this.screen = screen;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.screen.getBlockEntity().getCurrentTier() == 5) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)CHRISTMAS_STAR_GUI);
                this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 176, 31, 32, 31);
                if (this.f_93622_) {
                    ChristmasStarScreen.this.drawTooltip(matrixStack, (Component)new TranslatableComponent(SUMMON_SANTA_TOOLTIP), mouseX, mouseY);
                }
            }
        }
    }
}

