/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jumpcutfindo.happyholidays.client.screen.guides.GuideScreen;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.EmptyLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.ImageLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.ItemLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.RecipeLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.TextLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.pages.ContentPage;
import com.jumpcutfindo.happyholidays.client.screen.guides.pages.IPage;
import com.jumpcutfindo.happyholidays.client.screen.guides.pages.TitlePage;
import com.jumpcutfindo.happyholidays.common.guide.Chapter;
import com.jumpcutfindo.happyholidays.common.guide.Guide;
import com.jumpcutfindo.happyholidays.common.guide.sections.ISection;
import com.jumpcutfindo.happyholidays.common.guide.sections.ImageSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.ItemSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.RecipeSection;
import com.jumpcutfindo.happyholidays.common.guide.sections.TextSection;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class GuideProcessor {
    private float IMAGE_SCALE_VALUE = 0.5f;
    private final GuideScreen guideScreen;
    private final Guide guide;
    private IPage currentPage;
    private int currentPageIndex;
    Map<Integer, Integer> chapterPageMap;
    IPage titlePage;
    List<IPage> tocPages;
    List<IPage> contentPages;
    List<IPage> pages;

    public GuideProcessor(GuideScreen guideScreen, Guide guide) {
        this.guideScreen = guideScreen;
        this.guide = guide;
        this.pages = Lists.newArrayList();
        this.titlePage = new TitlePage(guideScreen, guide);
        this.pages.add(this.titlePage);
        this.chapterPageMap = Maps.newHashMap();
        this.generateContentPages();
        this.generateTableOfContentsPage();
        this.pages.addAll(this.tocPages);
        this.pages.addAll(this.contentPages);
        this.setCurrentPage(0, false);
    }

    public void draw(PoseStack matrixStack) {
        this.currentPage.draw(matrixStack);
    }

    public void generateContentPages() {
        Font font = this.guideScreen.getFontRenderer();
        this.contentPages = Lists.newArrayList();
        int linesPerPage = 19;
        ArrayList contentProcessors = Lists.newArrayList();
        int chapterCount = 1;
        for (Chapter chapter : this.guide.getChapters()) {
            ArrayList chapterProcessors = Lists.newArrayList();
            String chapterTitle = String.format("%d. %s", chapterCount, chapter.getTitle());
            chapterProcessors.addAll(font.m_92923_(FormattedText.m_130762_((String)chapterTitle, (Style)Style.f_131099_.m_131157_(ChatFormatting.BOLD)), 145).stream().map(processor -> new TextLine(this.guideScreen, (FormattedCharSequence)processor)).collect(Collectors.toList()));
            chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
            if (chapter.getImage() != null) {
                ImageSection newImage = chapter.getImage().scale(this.IMAGE_SCALE_VALUE);
                chapterProcessors.add(new ImageLine(this.guideScreen, newImage));
                for (int i = 0; i < newImage.getHeight() / 9; ++i) {
                    chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.BUFFER));
                }
            }
            int sectionCount = 1;
            for (ISection section : chapter.getSections()) {
                int i;
                int linesRemaining;
                if (section == null) continue;
                if (section instanceof TextSection) {
                    TextSection textSection = (TextSection)section;
                    if (textSection.getTitle() != null) {
                        String sectionTitle = String.format("%d.%d. %s", chapterCount, sectionCount, textSection.getTitle());
                        chapterProcessors.addAll(font.m_92923_(FormattedText.m_130762_((String)sectionTitle, (Style)Style.f_131099_.m_131157_(ChatFormatting.ITALIC)), 145).stream().map(processor -> new TextLine(this.guideScreen, (FormattedCharSequence)processor)).collect(Collectors.toList()));
                        ++sectionCount;
                    }
                    if (textSection.getContent() != null) {
                        chapterProcessors.addAll(font.m_92923_(FormattedText.m_130775_((String)textSection.getContent()), 145).stream().map(processor -> new TextLine(this.guideScreen, (FormattedCharSequence)processor)).collect(Collectors.toList()));
                    }
                    chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
                    continue;
                }
                if (section instanceof ImageSection) {
                    ImageSection imageSection = ((ImageSection)section).scale(this.IMAGE_SCALE_VALUE);
                    int imageLines = imageSection.getHeight() / 9;
                    linesRemaining = linesPerPage - chapterProcessors.size() % linesPerPage;
                    if (linesRemaining < imageLines) {
                        for (i = 0; i < linesRemaining; ++i) {
                            chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
                        }
                    }
                    chapterProcessors.add(new ImageLine(this.guideScreen, imageSection));
                    for (i = 0; i < imageSection.getHeight() / 9; ++i) {
                        chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.BUFFER));
                    }
                    continue;
                }
                if (section instanceof ItemSection) {
                    ItemSection itemSection = (ItemSection)section;
                    int itemLines = 2;
                    linesRemaining = linesPerPage - chapterProcessors.size() % linesPerPage;
                    if (linesRemaining < itemLines) {
                        for (i = 0; i < linesRemaining; ++i) {
                            chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
                        }
                    }
                    chapterProcessors.add(new ItemLine(this.guideScreen, itemSection));
                    for (i = 0; i < itemLines; ++i) {
                        chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.BUFFER));
                    }
                    continue;
                }
                if (!(section instanceof RecipeSection)) continue;
                RecipeSection recipeSection = (RecipeSection)section;
                int itemLines = 6;
                linesRemaining = linesPerPage - chapterProcessors.size() % linesPerPage;
                if (linesRemaining < itemLines) {
                    for (i = 0; i < linesRemaining; ++i) {
                        chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
                    }
                }
                chapterProcessors.add(new RecipeLine(this.guideScreen, recipeSection));
                for (i = 0; i < itemLines; ++i) {
                    chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.BUFFER));
                }
            }
            ++chapterCount;
            contentProcessors.add(chapterProcessors);
        }
        for (int chapter = 0; chapter < contentProcessors.size(); ++chapter) {
            int i;
            List chapterProcessors = (List)contentProcessors.get(chapter);
            this.chapterPageMap.put(chapter, this.contentPages.size() + 1);
            int processorPages = chapterProcessors.size() / (linesPerPage * 2) + 1;
            int currProcessorsSize = chapterProcessors.size();
            for (i = 0; i < processorPages * (linesPerPage * 2) - currProcessorsSize; ++i) {
                chapterProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
            }
            for (i = 0; i < chapterProcessors.size() / (linesPerPage * 2); ++i) {
                int start = i * (linesPerPage * 2);
                ContentPage contentPage = new ContentPage(this.guideScreen, chapterProcessors.subList(start, start + linesPerPage), chapterProcessors.subList(start + linesPerPage, start + linesPerPage * 2));
                this.contentPages.add(contentPage);
            }
        }
    }

    public void generateTableOfContentsPage() {
        Font font = this.guideScreen.getFontRenderer();
        ArrayList tableOfContentsProcessors = Lists.newArrayList();
        for (int i = 0; i < this.guide.getChapters().size(); ++i) {
            if (i == 0) {
                tableOfContentsProcessors.addAll(font.m_92923_(FormattedText.m_130762_((String)this.guide.getTableOfContentsTitle(), (Style)Style.f_131099_.m_131157_(ChatFormatting.BOLD)), 145).stream().map(processor -> new TextLine(this.guideScreen, (FormattedCharSequence)processor)).collect(Collectors.toList()));
                tableOfContentsProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
            }
            Chapter chapter = this.guide.getChapters().get(i);
            int pageIndex = this.chapterPageMap.get(i);
            tableOfContentsProcessors.addAll(font.m_92923_(FormattedText.m_130762_((String)String.format("%d. %s", i + 1, chapter.getTitle()), (Style)Style.f_131099_.m_131157_(ChatFormatting.ITALIC).m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, Integer.toString(pageIndex)))), 145).stream().map(processor -> new TextLine(this.guideScreen, (FormattedCharSequence)processor)).collect(Collectors.toList()));
        }
        int linesPerPage = 19;
        int processorPages = tableOfContentsProcessors.size() / (linesPerPage * 2) + 1;
        int currProcessorsSize = tableOfContentsProcessors.size();
        for (int i = 0; i < processorPages * (linesPerPage * 2) - currProcessorsSize; ++i) {
            tableOfContentsProcessors.add(new EmptyLine(this.guideScreen, EmptyLine.Type.SPACING));
        }
        ArrayList contentPages = Lists.newArrayList();
        for (int i = 0; i < tableOfContentsProcessors.size() / (linesPerPage * 2); ++i) {
            int start = i * (linesPerPage * 2);
            ContentPage contentPage = new ContentPage(this.guideScreen, tableOfContentsProcessors.subList(start, start + linesPerPage), tableOfContentsProcessors.subList(start + linesPerPage, start + linesPerPage * 2));
            contentPages.add(contentPage);
        }
        this.tocPages = contentPages;
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void pageForward() {
        if (this.currentPageIndex < this.getNumPages() - 1) {
            ++this.currentPageIndex;
        }
        this.currentPage = this.pages.get(this.currentPageIndex);
    }

    public void pageBack() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
        }
        this.currentPage = this.pages.get(this.currentPageIndex);
    }

    public boolean setCurrentPage(int index, boolean isContentPageIndex) {
        if (isContentPageIndex) {
            int actualIndex = index + 1 + this.tocPages.size();
            if (actualIndex >= 0 && actualIndex < this.getNumPages()) {
                this.currentPageIndex = actualIndex;
                this.currentPage = this.pages.get(this.currentPageIndex);
            }
            return true;
        }
        if (index >= 0 && index < this.getNumPages()) {
            this.currentPageIndex = index;
            this.currentPage = this.pages.get(index);
            return true;
        }
        return false;
    }

    public boolean isTablePage() {
        return this.tocPages.contains(this.currentPage);
    }

    public boolean isTitlePage() {
        return this.titlePage.equals(this.currentPage);
    }

    public IPageLine getLineAt(double mouseX, double mouseY) {
        return this.currentPage.getLineAtPos(mouseX, mouseY);
    }

    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        IPageLine line = this.currentPage.getLineAtPos(mouseX, mouseY);
        if (line instanceof TextLine) {
            return this.guideScreen.getFontRenderer().m_92865_().m_92338_(((TextLine)line).getProcessor(), 16);
        }
        return null;
    }
}

