/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.client.screen.guides.GuideProcessor;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.common.guide.Guide;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class GuideScreen
extends Screen {
    public static final ResourceLocation DEFAULT_BOOK_GUI = new ResourceLocation("happyholidays", "textures/gui/guide/guide_book.png");
    public static final ResourceLocation CHRISTMAS_GUIDE_BOOK_GUI = new ResourceLocation("happyholidays", "textures/gui/guide/christmas_guide_book.png");
    public static final int PAGE_LEFT_X_START = 12;
    public static final int PAGE_LEFT_X_END = 157;
    public static final int PAGE_RIGHT_X_START = 180;
    public static final int PAGE_RIGHT_X_END = 325;
    public static final int PAGE_Y_START = 12;
    public static final int PAGE_Y_END = 188;
    public static final int PAGE_WIDTH = 145;
    public static final int PAGE_HEIGHT = 176;
    private final Guide guide;
    private GuideProcessor guideProcessor;
    public final int bgWidth;
    public final int bgHeight;
    public final int textureWidth;
    public final int textureHeight;
    public final ResourceLocation guideBookGUI;
    private PageButton forwardButton;
    private PageButton backButton;
    private PageButton tableOfContentsButton;
    private RecipeManager recipeManager;
    private IPageLine hoveredLine;
    public double mouseX;
    public double mouseY;

    public GuideScreen(Guide guide) {
        super((Component)new TextComponent("Guide Book"));
        this.guide = guide;
        this.bgWidth = 337;
        this.bgHeight = 200;
        this.textureWidth = 512;
        this.textureHeight = 512;
        this.guideBookGUI = this.guide.getId().equals("christmas") ? CHRISTMAS_GUIDE_BOOK_GUI : DEFAULT_BOOK_GUI;
    }

    protected void m_7856_() {
        this.guideProcessor = new GuideProcessor(this, this.guide);
        this.createMenuControls();
        this.createPageControlButtons();
        this.recipeManager = this.f_96541_ != null ? this.f_96541_.f_91073_.m_7465_() : null;
    }

    public void m_6305_(PoseStack matrixStack, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.guideBookGUI);
        int x = (this.f_96543_ - this.bgWidth) / 2;
        int y = (this.f_96544_ - this.bgHeight) / 2;
        GuideScreen.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.bgWidth, (int)this.bgHeight, (int)this.textureWidth, (int)this.textureHeight);
        super.m_6305_(matrixStack, p_230430_2_, p_230430_3_, p_230430_4_);
        this.guideProcessor.draw(matrixStack);
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    protected void pageBack() {
        this.guideProcessor.pageBack();
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        this.guideProcessor.pageForward();
        this.updateButtonVisibility();
    }

    protected void pageTableOfContents() {
        this.guideProcessor.setCurrentPage(1, false);
        this.updateButtonVisibility();
    }

    protected void createMenuControls() {
        int x = (this.f_96543_ - this.bgWidth) / 2;
        int y = (this.f_96544_ - this.bgHeight) / 2;
        this.m_142416_((GuiEventListener)new GuideCloseButton(x + 338 - 9, y - 9, 18, 18, CommonComponents.f_130655_, p_214161_1_ -> this.f_96541_.m_91152_((Screen)null)));
    }

    protected void createPageControlButtons() {
        int x = (this.f_96543_ - this.bgWidth) / 2;
        int y = (this.f_96544_ - this.bgHeight) / 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new GuideChangePageButton(x + 306, y + 198, true, p_214159_1_ -> this.pageForward(), true));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new GuideChangePageButton(x + 281, y + 198, false, p_214158_1_ -> this.pageBack(), true));
        this.tableOfContentsButton = (PageButton)this.m_142416_((GuiEventListener)new GuideTableOfContentsButton(x + 259, y + 195, true, p_onPress_1_ -> this.pageTableOfContents(), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = this.guideProcessor.getCurrentPageIndex() < this.guideProcessor.getNumPages() - 1;
        this.backButton.f_93624_ = this.guideProcessor.getCurrentPageIndex() > 0;
        this.tableOfContentsButton.f_93624_ = !this.guideProcessor.isTablePage() && !this.guideProcessor.isTitlePage();
    }

    private void setMousePos(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.setMousePos(mouseX, mouseY);
        IPageLine pageLine = this.guideProcessor.getLineAt(mouseX, mouseY);
        if (pageLine != null) {
            if (this.hoveredLine == null) {
                this.hoveredLine = pageLine;
                pageLine.setHovered(true);
            } else if (!this.hoveredLine.equals(pageLine)) {
                this.hoveredLine.setHovered(false);
                this.hoveredLine = pageLine;
                pageLine.setHovered(true);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int value) {
        Style style;
        if (value == 0 && this.guideProcessor.isTablePage() && (style = this.guideProcessor.getClickedComponentStyleAt(mouseX, mouseY)) != null && this.m_5561_(style)) {
            this.updateButtonVisibility();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, value);
    }

    public boolean m_5561_(Style p_230455_1_) {
        ClickEvent clickevent = p_230455_1_.m_131182_();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.m_130623_();
            try {
                int i = Integer.parseInt(s) - 1;
                return this.guideProcessor.setCurrentPage(i, true);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void drawTooltip(PoseStack matrixStack, Component textComponent, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((PoseStack)matrixStack, (List)Lists.newArrayList((Object[])new Component[]{textComponent}), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
    }

    public class GuideCloseButton
    extends Button {
        private static final String CLOSE_BUTTON_TOOLTIP = "guide.happyholidays.close_button.tooltip";

        public GuideCloseButton(int p_i232255_1_, int p_i232255_2_, int p_i232255_3_, int p_i232255_4_, Component p_i232255_5_, Button.OnPress p_i232255_6_) {
            super(p_i232255_1_, p_i232255_2_, p_i232255_3_, p_i232255_4_, p_i232255_5_, p_i232255_6_);
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 26;
            GuideCloseButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)i, (float)j, (int)18, (int)18, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.f_93622_) {
                GuideScreen.this.drawTooltip(matrixStack, (Component)new TranslatableComponent(CLOSE_BUTTON_TOOLTIP), mouseX, mouseY);
            }
        }
    }

    public class GuideChangePageButton
    extends PageButton {
        private static final String FORWARD_BUTTON_TOOLTIP = "guide.happyholidays.forward_button.tooltip";
        private static final String BACKWARD_BUTTON_TOOLTIP = "guide.happyholidays.backward_button.tooltip";
        private final boolean isForward;
        private final boolean playTurnSound;

        public GuideChangePageButton(int p_i51079_1_, int p_i51079_2_, boolean p_i51079_3_, Button.OnPress p_i51079_4_, boolean p_i51079_5_) {
            super(p_i51079_1_, p_i51079_2_, p_i51079_3_, p_i51079_4_, p_i51079_5_);
            this.isForward = p_i51079_3_;
            this.playTurnSound = p_i51079_5_;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 0;
            if (this.m_5702_()) {
                i += 23;
            }
            if (!this.isForward) {
                j += 13;
            }
            GuideChangePageButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)i, (float)j, (int)23, (int)13, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.f_93622_) {
                if (this.isForward) {
                    GuideScreen.this.drawTooltip(matrixStack, (Component)new TranslatableComponent(FORWARD_BUTTON_TOOLTIP), mouseX, mouseY);
                } else {
                    GuideScreen.this.drawTooltip(matrixStack, (Component)new TranslatableComponent(BACKWARD_BUTTON_TOOLTIP), mouseX, mouseY);
                }
            }
        }
    }

    public class GuideTableOfContentsButton
    extends PageButton {
        private static final String TABLE_OF_CONTENTS_TOOLTIP = "guide.happyholidays.table_of_contents_button.tooltip";
        private final boolean playTurnSound;

        public GuideTableOfContentsButton(int p_i51079_1_, int p_i51079_2_, boolean p_i51079_3_, Button.OnPress p_i51079_4_, boolean p_i51079_5_) {
            super(p_i51079_1_, p_i51079_2_, p_i51079_3_, p_i51079_4_, p_i51079_5_);
            this.playTurnSound = p_i51079_5_;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 44;
            if (this.m_5702_()) {
                i += 19;
            }
            GuideTableOfContentsButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)i, (float)j, (int)19, (int)18, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.f_93622_) {
                GuideScreen.this.drawTooltip(matrixStack, (Component)new TranslatableComponent(TABLE_OF_CONTENTS_TOOLTIP), mouseX, mouseY);
            }
        }
    }
}

