/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides.lines;

import com.jumpcutfindo.happyholidays.client.screen.guides.GuideScreen;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.common.guide.sections.ItemSection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemLine
implements IPageLine {
    public static final int ITEM_WIDTH = 18;
    public static final int ITEM_HEIGHT = 18;
    private final GuideScreen guideScreen;
    private final ItemSection itemSection;
    private boolean isHovered;

    public ItemLine(GuideScreen guideScreen, ItemSection itemSection) {
        this.guideScreen = guideScreen;
        this.itemSection = itemSection;
    }

    @Override
    public void draw(PoseStack matrixStack, int xPos, int yPos) {
        List<ItemStack> items = this.itemSection.getItems();
        int firstX = xPos + (145 - 18 * items.size()) / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.guideScreen.guideBookGUI);
        for (int i = 0; i < items.size(); ++i) {
            GuideScreen.m_93133_((PoseStack)matrixStack, (int)(firstX + 18 * i - 1), (int)(yPos - 1), (float)337.0f, (float)62.0f, (int)18, (int)18, (int)512, (int)512);
        }
        ItemRenderer itemRenderer = this.guideScreen.getItemRenderer();
        for (int i = 0; i < items.size(); ++i) {
            itemRenderer.m_115123_(items.get(i), firstX + 18 * i, yPos);
        }
        this.drawTooltip(matrixStack);
    }

    public void drawTooltip(PoseStack matrixStack) {
        ItemStack itemStack;
        if (this.isHovered && (itemStack = this.getItemAtPos(this.guideScreen.mouseX, this.guideScreen.mouseY)) != null) {
            this.guideScreen.drawTooltip(matrixStack, itemStack.m_41786_(), (int)this.guideScreen.mouseX, (int)this.guideScreen.mouseY);
        }
    }

    @Override
    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
    }

    public ItemStack getItemAtPos(double x, double y) {
        int screenX = (int)(x - (double)(this.guideScreen.f_96543_ - this.guideScreen.bgWidth) / 2.0);
        int screenY = (int)(y - (double)(this.guideScreen.f_96544_ - this.guideScreen.bgHeight) / 2.0);
        if (screenY > 12 && screenY <= 188) {
            if (screenX > 12 && screenX <= 157) {
                int lineX = screenX - 12;
                List<ItemStack> items = this.itemSection.getItems();
                int firstX = (145 - 18 * items.size()) / 2;
                int index = lineX - firstX > 0 ? (lineX - firstX) / 18 : -1;
                return index >= 0 && index <= items.size() - 1 ? items.get(index) : null;
            }
            if (screenX > 180 && screenX <= 325) {
                int lineX = screenX - 180;
                List<ItemStack> items = this.itemSection.getItems();
                int firstX = (145 - 18 * items.size()) / 2;
                int index = lineX - firstX > 0 ? (lineX - firstX) / 18 : -1;
                return index >= 0 && index <= items.size() - 1 ? items.get(index) : null;
            }
        }
        return null;
    }
}

