/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides.lines;

import com.jumpcutfindo.happyholidays.client.screen.guides.GuideScreen;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.common.guide.sections.RecipeSection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class RecipeLine
implements IPageLine {
    public static final int ITEM_WIDTH = 18;
    public static final int ITEM_HEIGHT = 18;
    private GuideScreen guideScreen;
    private RecipeSection recipeSection;
    private int recipeIndex;
    private int internalTimer;
    private boolean isHovered;
    private int xPos;
    private int yPos;

    public RecipeLine(GuideScreen guideScreen, RecipeSection recipeSection) {
        this.guideScreen = guideScreen;
        this.recipeSection = recipeSection;
        this.recipeIndex = 0;
    }

    @Override
    public void draw(PoseStack matrixStack, int xPos, int yPos) {
        List<Recipe> recipes = this.recipeSection.getRecipes();
        int baseX = xPos + 16;
        int baseY = yPos - 1;
        this.xPos = baseX;
        this.yPos = baseY;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.guideScreen.guideBookGUI);
        GuideScreen.m_93133_((PoseStack)matrixStack, (int)baseX, (int)baseY, (float)337.0f, (float)80.0f, (int)114, (int)54, (int)512, (int)512);
        this.nextRecipe();
        ItemRenderer itemRenderer = this.guideScreen.getItemRenderer();
        Recipe recipe = recipes.get(this.recipeIndex);
        int width = 3;
        int height = 3;
        if (recipe instanceof ShapedRecipe) {
            width = ((ShapedRecipe)recipe).m_44220_();
            height = ((ShapedRecipe)recipe).m_44221_();
        }
        for (int i = 0; i < height; ++i) {
            int currIndex;
            for (int j = 0; j < width && (currIndex = i * width + j) < recipe.m_7527_().size(); ++j) {
                Ingredient ingredient = (Ingredient)recipe.m_7527_().get(currIndex);
                ItemStack[] itemStacks = ingredient.m_43908_();
                if (itemStacks.length <= 0) continue;
                itemRenderer.m_115123_(itemStacks[0], baseX + j * 18 + 1, baseY + i * 18 + 1);
            }
        }
        itemRenderer.m_115123_(recipe.m_8043_(), baseX + 97, baseY + 19);
        this.drawTooltip(matrixStack);
    }

    private void nextRecipe() {
        if (++this.internalTimer == 200) {
            this.internalTimer = 0;
            this.recipeIndex = this.recipeIndex >= this.recipeSection.getRecipes().size() - 1 ? 0 : ++this.recipeIndex;
        }
    }

    public void drawTooltip(PoseStack matrixStack) {
        ItemStack itemStack;
        if (this.isHovered && (itemStack = this.getItemAtPos(this.guideScreen.mouseX, this.guideScreen.mouseY)) != null) {
            this.guideScreen.drawTooltip(matrixStack, itemStack.m_41786_(), (int)this.guideScreen.mouseX, (int)this.guideScreen.mouseY);
        }
    }

    public ItemStack getItemAtPos(double x, double y) {
        int screenX = (int)(x - (double)(this.guideScreen.f_96543_ - this.guideScreen.bgWidth) / 2.0);
        int screenY = (int)(y - (double)(this.guideScreen.f_96544_ - this.guideScreen.bgHeight) / 2.0);
        if (screenY > 12 && screenY <= 188) {
            if (screenX > 12 && screenX <= 157) {
                int lineX = (int)x - this.xPos;
                int lineY = (int)y - this.yPos;
                if (lineX <= 54 && lineY <= 54) {
                    int currIndex;
                    Recipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    int i = lineX / 18;
                    int j = lineY / 18;
                    int width = 3;
                    int height = 3;
                    if (recipe instanceof ShapedRecipe) {
                        width = ((ShapedRecipe)recipe).m_44220_();
                        height = ((ShapedRecipe)recipe).m_44221_();
                    }
                    if ((currIndex = j * width + i) < 0 || currIndex > recipe.m_7527_().size() - 1) {
                        return null;
                    }
                    Ingredient ingredient = (Ingredient)recipe.m_7527_().get(currIndex);
                    ItemStack[] itemStacks = ingredient.m_43908_();
                    if (itemStacks != null && itemStacks.length != 0) {
                        return itemStacks[0];
                    }
                } else if (lineX >= 97 && lineX <= 115 && lineY <= 54 && lineY >= 18) {
                    Recipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    return recipe.m_8043_();
                }
            } else if (screenX > 180 && screenX <= 325) {
                int lineX = (int)x - this.xPos;
                int lineY = (int)y - this.yPos;
                if (lineX <= 54 && lineY <= 54) {
                    int currIndex;
                    Recipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    int i = lineX / 18;
                    int j = lineY / 18;
                    int width = 3;
                    int height = 3;
                    if (recipe instanceof ShapedRecipe) {
                        width = ((ShapedRecipe)recipe).m_44220_();
                        height = ((ShapedRecipe)recipe).m_44221_();
                    }
                    if ((currIndex = j * width + i) < 0 || currIndex > recipe.m_7527_().size() - 1) {
                        return null;
                    }
                    Ingredient ingredient = (Ingredient)recipe.m_7527_().get(currIndex);
                    ItemStack[] itemStacks = ingredient.m_43908_();
                    if (itemStacks != null && itemStacks.length != 0) {
                        return itemStacks[0];
                    }
                } else if (lineX >= 97 && lineX <= 115 && lineY <= 36 && lineY >= 18) {
                    Recipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    return recipe.m_8043_();
                }
            }
        }
        return null;
    }

    @Override
    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
    }
}

