/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.candy;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BaseCandyCaneBlock
extends ChristmasBlock {
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.0f).m_60918_(SoundType.f_56742_);
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    public static final double ENCHANTED_CANDY_CANE_DROP_BASE_CHANCE = 0.005;

    public BaseCandyCaneBlock(String blockId) {
        super(BLOCK_PROPERTIES);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)Items.f_42424_.m_7968_());
        List<ItemStack> drops = explosion.m_46079_() != null ? this.getCustomDrops(state, pos, lootContextBuilder, DestroyReason.NATURAL_EXPLOSION) : this.getCustomDrops(state, pos, lootContextBuilder, DestroyReason.EXPLOSION);
        for (ItemStack drop : drops) {
            BaseCandyCaneBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public void m_6240_(Level world, Player playerEntity, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(world, playerEntity, blockPos, blockState, blockEntity, itemStack);
        if (!world.m_5776_()) {
            LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_78972_(LootContextParams.f_81463_, (Object)playerEntity.m_21205_()).m_78984_(LootContextParams.f_81462_, (Object)blockEntity);
            List<ItemStack> drops = this.getCustomDrops(blockState, blockPos, lootContextBuilder, DestroyReason.PLAYER);
            for (ItemStack drop : drops) {
                BaseCandyCaneBlock.m_49840_((Level)world, (BlockPos)blockPos, (ItemStack)drop);
            }
            blockState.m_60612_((ServerLevel)world, blockPos, itemStack);
        }
    }

    public List<ItemStack> getCustomDrops(BlockState blockState, BlockPos blockPos, LootContext.Builder builder, DestroyReason destroyReason) {
        ResourceLocation resourceLocation = this.m_60589_();
        if (resourceLocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootContext lootContext = builder.m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78975_(LootContextParamSets.f_81421_);
        ServerLevel serverWorld = lootContext.m_78952_();
        ChristmasStarBlockEntity starBlockEntity = ChristmasStarHelper.getStarInfluencingBlock((Level)serverWorld, blockPos);
        ArrayList drops = Lists.newArrayList();
        double chance = 0.0;
        chance = starBlockEntity == null ? 0.005 : (!starBlockEntity.isBonusActive() ? 0.005 + 0.005 * (double)starBlockEntity.getCurrentTier() * 0.2 : 0.015);
        switch (destroyReason) {
            case EXPLOSION: {
                chance *= 2.0;
                break;
            }
            case NATURAL_EXPLOSION: {
                chance *= 5.0;
            }
        }
        if (this.RANDOM.nextDouble() <= chance) {
            drops.add(((ChristmasItem)ChristmasItems.ENCHANTED_CANDY_CANE.get()).m_7968_());
        }
        return drops;
    }

    private static enum DestroyReason {
        PLAYER,
        EXPLOSION,
        NATURAL_EXPLOSION;

    }
}

