/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.WallDecorationShape;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedOrnamentBlock
extends ChristmasBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<WallDecorationShape> WALL_SHAPE = EnumProperty.m_61587_((String)"decoration_shape", WallDecorationShape.class);
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    private final VoxelShape shape;

    public ConnectedOrnamentBlock(BlockBehaviour.Properties blockProperties, VoxelShape shape) {
        super(blockProperties);
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(WALL_SHAPE, (Comparable)((Object)WallDecorationShape.STRAIGHT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void configureBlock() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110466_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate;
        Direction clickedFaceDirection = context.m_43719_();
        BlockPos clickedPos = context.m_8083_();
        Level world = context.m_43725_();
        if (!clickedFaceDirection.m_122434_().m_122479_()) {
            clickedFaceDirection = context.m_8125_().m_122424_();
        }
        boolean isWaterlogged = (fluidstate = context.m_43725_().m_6425_(context.m_8083_())).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickedFaceDirection)).m_61124_(WALL_SHAPE, (Comparable)((Object)this.getWallShapeState((LevelAccessor)world, clickedPos, clickedFaceDirection)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{WALL_SHAPE, FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        if (direction == Direction.SOUTH) {
            return this.shape;
        }
        if (direction == Direction.NORTH) {
            return HappyHolidaysUtils.rotateShape(this.shape, Rotation.CLOCKWISE_180);
        }
        if (direction == Direction.WEST) {
            return HappyHolidaysUtils.rotateShape(this.shape, Rotation.CLOCKWISE_90);
        }
        return HappyHolidaysUtils.rotateShape(this.shape, Rotation.COUNTERCLOCKWISE_90);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(pos1, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        Direction facingDirection = (Direction)blockState.m_61143_((Property)FACING);
        if (!this.m_7898_(blockState, (LevelReader)world, pos1)) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)((BlockState)blockState.m_61124_((Property)FACING, (Comparable)facingDirection)).m_61124_(WALL_SHAPE, (Comparable)((Object)this.getWallShapeState(world, pos1, facingDirection)));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos position) {
        BlockState onBlockState;
        Direction facingDirection = (Direction)blockState.m_61143_((Property)FACING);
        Object object = facingDirection == Direction.NORTH ? world.m_8055_(position.m_142128_()) : (facingDirection == Direction.SOUTH ? world.m_8055_(position.m_142127_()) : (facingDirection == Direction.EAST ? world.m_8055_(position.m_142125_()) : (onBlockState = facingDirection == Direction.WEST ? world.m_8055_(position.m_142126_()) : null)));
        if (onBlockState != null) {
            return onBlockState.m_60783_((BlockGetter)world, position, facingDirection) || onBlockState.m_60620_((Tag)BlockTags.f_13035_);
        }
        return false;
    }

    private WallDecorationShape getWallShapeState(LevelAccessor world, BlockPos blockPos, Direction facingDirection) {
        boolean isOppositeSupportive;
        Direction oppDir;
        Direction rightDir;
        Direction leftDir;
        BlockPos oppPos;
        BlockPos rightPos;
        BlockPos leftPos;
        if (facingDirection == Direction.NORTH) {
            leftPos = blockPos.m_142125_();
            rightPos = blockPos.m_142126_();
            oppPos = blockPos.m_142127_();
            leftDir = Direction.WEST;
            rightDir = Direction.EAST;
            oppDir = Direction.NORTH;
        } else if (facingDirection == Direction.SOUTH) {
            leftPos = blockPos.m_142126_();
            rightPos = blockPos.m_142125_();
            oppPos = blockPos.m_142128_();
            leftDir = Direction.EAST;
            rightDir = Direction.WEST;
            oppDir = Direction.SOUTH;
        } else if (facingDirection == Direction.EAST) {
            leftPos = blockPos.m_142127_();
            rightPos = blockPos.m_142128_();
            oppPos = blockPos.m_142126_();
            leftDir = Direction.NORTH;
            rightDir = Direction.SOUTH;
            oppDir = Direction.EAST;
        } else {
            leftPos = blockPos.m_142128_();
            rightPos = blockPos.m_142127_();
            oppPos = blockPos.m_142125_();
            leftDir = Direction.SOUTH;
            rightDir = Direction.NORTH;
            oppDir = Direction.WEST;
        }
        boolean isLeftSupportive = world.m_8055_(leftPos).m_60783_((BlockGetter)world, leftPos, leftDir) || world.m_8055_(leftPos).m_60620_((Tag)BlockTags.f_13035_);
        boolean isRightSupportive = world.m_8055_(rightPos).m_60783_((BlockGetter)world, rightPos, rightDir) || world.m_8055_(rightPos).m_60620_((Tag)BlockTags.f_13035_);
        boolean bl = isOppositeSupportive = world.m_8055_(oppPos).m_60783_((BlockGetter)world, oppPos, oppDir) || world.m_8055_(oppPos).m_60620_((Tag)BlockTags.f_13035_);
        if (isLeftSupportive && isRightSupportive && isOppositeSupportive) {
            return WallDecorationShape.ALL_FACE;
        }
        if (isLeftSupportive && isRightSupportive) {
            return WallDecorationShape.SIDE_FACE;
        }
        if (isLeftSupportive) {
            return WallDecorationShape.LEFT_FACE;
        }
        if (isRightSupportive) {
            return WallDecorationShape.RIGHT_FACE;
        }
        return WallDecorationShape.STRAIGHT;
    }
}

