/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrnamentBlock
extends ChristmasBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.1f).m_60918_(SoundType.f_56744_).m_60955_().m_60910_();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    public VoxelShape[] normalShape;
    public VoxelShape[] hangingShape;
    public VoxelShape[] wallShape;

    public OrnamentBlock(VoxelShape[][] ornamentShapes) {
        super(BLOCK_PROPERTIES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.normalShape = ornamentShapes[0];
        this.hangingShape = ornamentShapes[1];
        this.wallShape = ornamentShapes[2];
    }

    @Override
    public void configureBlock() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing;
        AttachFace attachFace;
        Direction clickedFaceDirection = context.m_43719_();
        Direction.Axis clickedFaceAxis = clickedFaceDirection.m_122434_();
        BlockPos blockPos = context.m_8083_();
        Level world = context.m_43725_();
        if (clickedFaceAxis == Direction.Axis.Y) {
            attachFace = clickedFaceDirection == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING;
            facing = context.m_8125_().m_122424_();
        } else {
            attachFace = AttachFace.WALL;
            facing = clickedFaceDirection;
        }
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(ATTACH_FACE, (Comparable)attachFace)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        return this.m_7898_(blockState, (LevelReader)world, blockPos) ? blockState : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{ATTACH_FACE, FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        AttachFace attachFace = (AttachFace)blockState.m_61143_(ATTACH_FACE);
        VoxelShape[] resultShapes = null;
        resultShapes = attachFace == AttachFace.FLOOR ? Arrays.copyOf(this.normalShape, this.normalShape.length) : (attachFace == AttachFace.CEILING ? Arrays.copyOf(this.hangingShape, this.hangingShape.length) : Arrays.copyOf(this.wallShape, this.wallShape.length));
        if (direction == Direction.SOUTH) {
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.NORTH) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_180);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.WEST) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_90);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        for (int i = 0; i < resultShapes.length; ++i) {
            resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.COUNTERCLOCKWISE_90);
        }
        return HappyHolidaysUtils.combineShapes(resultShapes);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(pos1, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.m_7898_(blockState, (LevelReader)world, pos1) ? blockState : Blocks.f_50016_.m_49966_();
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos position) {
        boolean canSupportCentre;
        Direction facingDirection = (Direction)blockState.m_61143_((Property)FACING);
        AttachFace attachFace = (AttachFace)blockState.m_61143_(ATTACH_FACE);
        Direction connectedDirection = facingDirection.m_122424_();
        boolean bl = attachFace == AttachFace.FLOOR ? Block.m_49863_((LevelReader)world, (BlockPos)position.m_142300_(Direction.DOWN), (Direction)Direction.UP) : (canSupportCentre = attachFace == AttachFace.CEILING ? Block.m_49863_((LevelReader)world, (BlockPos)position.m_142300_(Direction.UP), (Direction)Direction.DOWN) : Block.m_49863_((LevelReader)world, (BlockPos)position.m_142300_(connectedDirection), (Direction)connectedDirection.m_122424_()));
        BlockState onBlockState = facingDirection == Direction.NORTH ? world.m_8055_(position.m_142128_()) : (facingDirection == Direction.SOUTH ? world.m_8055_(position.m_142127_()) : (facingDirection == Direction.EAST ? world.m_8055_(position.m_142125_()) : (facingDirection == Direction.WEST ? world.m_8055_(position.m_142126_()) : null)));
        boolean canSupportHanging = onBlockState != null && onBlockState.m_60783_((BlockGetter)world, position, facingDirection);
        boolean isLeaves = onBlockState != null && onBlockState.m_60620_((Tag)BlockTags.f_13035_);
        return canSupportCentre || canSupportHanging || isLeaves;
    }
}

