/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc;

import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc.WallDecorationBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.StockingBlockEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.StockingEvent;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlockEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StockingBlock
extends WallDecorationBlock
implements EntityBlock {
    public static final String RED_STOCKING_ID = "red_stocking";
    public static final String BLUE_STOCKING_ID = "blue_stocking";
    public static final String YELLOW_STOCKING_ID = "yellow_stocking";
    public static final String GREEN_STOCKING_ID = "green_stocking";
    public static final String GOLD_STOCKING_ID = "gold_stocking";
    public static final String SILVER_STOCKING_ID = "silver_stocking";
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.1f).m_60918_(SoundType.f_56745_).m_60955_().m_60910_();
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5);

    public StockingBlock() {
        super(BLOCK_PROPERTIES, SHAPE);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{FILLED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.m_7898_(blockState, (LevelReader)world, pos1) ? blockState : Blocks.f_50016_.m_49966_();
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (!world.m_5776_() && blockEntity instanceof StockingBlockEntity) {
            StockingBlockEntity stockingBlockEntity = (StockingBlockEntity)blockEntity;
            if (!stockingBlockEntity.isEmpty()) {
                stockingBlockEntity.dropStockingItems();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ChristmasBlockEntities.STOCKING_ENTITY_TYPE.get()).m_155264_(pos, state);
    }

    public boolean m_6724_(BlockState blockState) {
        return true;
    }

    public void m_7455_(BlockState blockState, ServerLevel world, BlockPos blockPos, Random random) {
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof StockingBlockEntity) {
            int randInt;
            StockingBlockEntity stockingBlockEntity = (StockingBlockEntity)blockEntity;
            if (world.m_46462_() && !stockingBlockEntity.isDoneForNight() && stockingBlockEntity.isEmpty() && (randInt = random.nextInt(100)) < StockingBlock.getFillChance((Level)world, blockPos)) {
                stockingBlockEntity.fillStocking();
                AABB searchBox = new AABB(blockPos).m_82400_(4.0);
                List playersAround = world.m_45976_(Player.class, searchBox);
                for (Player playerEntity : playersAround) {
                    StockingEvent.Fill fillEvent = new StockingEvent.Fill(blockState, blockPos, playerEntity);
                    MinecraftForge.EVENT_BUS.post((Event)fillEvent);
                }
            }
            if (world.m_46461_() && stockingBlockEntity.isDoneForNight()) {
                stockingBlockEntity.resetStocking();
            }
        }
    }

    public static int getFillChance(Level world, BlockPos blockPos) {
        int chance = 0;
        int baseChance = 10;
        chance += baseChance;
        boolean isCookiesNear = HappyHolidaysUtils.findBlockInRadius((LevelAccessor)world, blockPos, (Block)ChristmasBlocks.MILK_AND_COOKIES.get(), 5) != null;
        return chance += isCookiesNear ? 20 : 0;
    }
}

