/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.food;

import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.Arrays;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChristmasFoodBlock
extends ChristmasBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private VoxelShape[] shape;
    private final int nutrition;
    private final float saturation;

    public ChristmasFoodBlock(BlockBehaviour.Properties properties, VoxelShape[] shape, int nutrition, float saturation) {
        super(properties);
        this.shape = shape;
        this.nutrition = nutrition;
        this.saturation = saturation;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.m_7898_(blockState, (LevelReader)world, pos1) ? blockState : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        VoxelShape[] resultShapes = Arrays.copyOf(this.shape, this.shape.length);
        if (direction == Direction.SOUTH) {
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.NORTH) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_180);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        if (direction == Direction.WEST) {
            for (int i = 0; i < resultShapes.length; ++i) {
                resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.CLOCKWISE_90);
            }
            return HappyHolidaysUtils.combineShapes(resultShapes);
        }
        for (int i = 0; i < resultShapes.length; ++i) {
            resultShapes[i] = HappyHolidaysUtils.rotateShape(resultShapes[i], Rotation.COUNTERCLOCKWISE_90);
        }
        return HappyHolidaysUtils.combineShapes(resultShapes);
    }

    @Override
    public void configureBlock() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110457_());
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos position) {
        return world.m_8055_(position.m_7495_()).m_60767_().m_76333_();
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public static boolean isChristmasFoodBlock(Block block) {
        return block instanceof ChristmasFoodBlock;
    }
}

