/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.presents;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.presents.BabyPresentBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.entity.christmas.grinch.GrinchEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class PresentBlock
extends ChristmasBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.25f).m_60918_(SoundType.f_56745_).m_60977_();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().m_41487_(64).m_41491_(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    public static final float GROWTH_PROBABILITY = 0.015625f;
    private VoxelShape shape;

    public PresentBlock(String blockId, VoxelShape shape) {
        super(BLOCK_PROPERTIES);
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    public void configureBlock() {
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos, CollisionContext context) {
        return this.shape;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    }

    public VoxelShape m_5909_(BlockState p_230322_1_, BlockGetter p_230322_2_, BlockPos p_230322_3_, CollisionContext p_230322_4_) {
        return this.shape;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(pos1, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.m_7898_(blockState, (LevelReader)world, pos1) ? blockState : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        return this.m_7898_(blockState, (LevelReader)context.m_43725_(), context.m_8083_()) ? blockState : null;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos position) {
        return PresentBlock.m_49863_((LevelReader)world, (BlockPos)position.m_142300_(Direction.DOWN), (Direction)Direction.UP);
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter p_196266_2_, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return false;
    }

    public float getGrowthProbability(Level world, BlockPos pos) {
        ChristmasStarBlockEntity starBlockEntity = ChristmasStarHelper.getStarInfluencingBlock(world, pos);
        if (starBlockEntity == null) {
            return 0.015625f;
        }
        return 0.015625f + 0.015625f * (float)starBlockEntity.getCurrentTier() * 0.2f;
    }

    public void m_6240_(Level world, Player playerEntity, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        playerEntity.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        playerEntity.m_36399_(0.005f);
        if (!world.m_5776_()) {
            LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerLevel)world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_78972_(LootContextParams.f_81463_, (Object)playerEntity.m_21205_()).m_78984_(LootContextParams.f_81462_, (Object)blockEntity);
            List<ItemStack> drops = this.getCustomDrops(blockState, blockPos, lootContextBuilder);
            for (ItemStack drop : drops) {
                PresentBlock.m_49840_((Level)world, (BlockPos)blockPos, (ItemStack)drop);
            }
            blockState.m_60612_((ServerLevel)world, blockPos, itemStack);
        }
    }

    public List<ItemStack> getCustomDrops(BlockState blockState, BlockPos blockPos, LootContext.Builder builder) {
        ResourceLocation resourceLocation = this.m_60589_();
        if (resourceLocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootContext lootContext = builder.m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78975_(LootContextParamSets.f_81421_);
        ServerLevel serverWorld = lootContext.m_78952_();
        LootTable lootTable = serverWorld.m_142572_().m_129898_().m_79217_(resourceLocation);
        ChristmasStarBlockEntity starBlockEntity = ChristmasStarHelper.getStarInfluencingBlock((Level)serverWorld, blockPos);
        List drops = lootTable.m_79129_(lootContext);
        for (ItemStack drop : drops) {
            if (!ChristmasItems.isBasicOrnamentItem(drop)) continue;
            if (blockState.m_60713_((Block)ChristmasBlocks.BABY_PRESENT.get())) {
                drop.m_41764_(this.RANDOM.nextInt(1) + 1 + 1);
                continue;
            }
            if (blockState.m_60713_((Block)ChristmasBlocks.ADULT_PRESENT.get())) {
                drop.m_41764_(this.RANDOM.nextInt(2) + 1 + 2);
                continue;
            }
            drop.m_41764_(this.RANDOM.nextInt(2) + 1 + 3);
        }
        if (starBlockEntity != null && starBlockEntity.isBonusActive()) {
            for (ItemStack drop : drops) {
                if (ItemStack.m_41746_((ItemStack)drop, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).m_7968_()) || ChristmasItems.isPresentItem(drop)) continue;
                drop.m_41764_(drop.m_41613_() * 2);
            }
        }
        return drops;
    }

    public void m_7455_(BlockState blockState, ServerLevel serverWorld, BlockPos blockPos, Random random) {
        super.m_7455_(blockState, serverWorld, blockPos, random);
        if (PresentBlock.isGrowable(blockState)) {
            boolean isGrow;
            boolean bl = PresentBlock.canGrow((LevelAccessor)serverWorld, blockState, blockPos) && ForgeHooks.onCropsGrowPre((Level)serverWorld, (BlockPos)blockPos, (BlockState)blockState, (random.nextInt((int)(1.0 / (double)this.getGrowthProbability((Level)serverWorld, blockPos))) == 0 ? 1 : 0) != 0) ? true : (isGrow = false);
            if (isGrow) {
                PresentBlock.grow(blockState, serverWorld, blockPos, random);
            }
        }
        if (GrinchEntity.canSpawnInArea(blockPos, serverWorld)) {
            GrinchEntity.spawnGrinchAround(blockPos, serverWorld, random);
        }
    }

    public static void grow(BlockState blockState, ServerLevel serverWorld, BlockPos blockPos, Random random) {
        BlockState nextBlockState = blockState.m_60734_() instanceof BabyPresentBlock ? ((ChristmasBlock)ChristmasBlocks.ADULT_PRESENT.get()).m_49966_() : ((ChristmasBlock)ChristmasBlocks.ELDER_PRESENT.get()).m_49966_();
        serverWorld.m_7731_(blockPos, nextBlockState, 2);
        serverWorld.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_12639_, SoundSource.BLOCKS, 1.0f, 1.0f);
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)blockPos.m_123341_() + random.nextDouble(), (double)blockPos.m_123342_() + random.nextDouble(), (double)blockPos.m_123343_() + random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        ForgeHooks.onCropsGrowPost((Level)serverWorld, (BlockPos)blockPos, (BlockState)blockState);
    }

    public static boolean canGrow(LevelAccessor world, BlockState blockState, BlockPos blockPos) {
        return !world.m_8055_(blockPos.m_7494_()).m_60620_((Tag)BlockTags.f_13035_) && !blockState.m_60783_((BlockGetter)world, blockPos, Direction.UP);
    }

    public static boolean isGrowable(BlockState blockState) {
        return blockState.m_60713_((Block)ChristmasBlocks.BABY_PRESENT.get()) || blockState.m_60713_((Block)ChristmasBlocks.ADULT_PRESENT.get());
    }
}

