/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.blockentity.christmas;

import com.jumpcutfindo.happyholidays.common.blockentity.christmas.ChristmasEntityBlock;
import com.jumpcutfindo.happyholidays.common.item.christmas.music.ChristmasMusic;
import com.jumpcutfindo.happyholidays.common.item.christmas.music.SheetMusicItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlockEntities;
import com.jumpcutfindo.happyholidays.common.sound.christmas.MusicBoxSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MusicBoxBlockEntity
extends BlockEntity
implements ChristmasEntityBlock,
Clearable,
IAnimatable {
    public static final String BLOCK_ENTITY_ID = "music_box";
    private ItemStack sheetMusic = ItemStack.f_41583_;
    private MusicBoxSound currentMusic = null;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MusicBoxBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public MusicBoxBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ChristmasBlockEntities.MUSIC_BOX_ENTITY_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        if (p_230337_2_.m_128425_("SheetMusicItem", 10)) {
            this.setSheetMusic(ItemStack.m_41712_((CompoundTag)p_230337_2_.m_128469_("SheetMusicItem")), false);
        }
    }

    public CompoundTag m_6945_(CompoundTag p_189515_1_) {
        super.m_6945_(p_189515_1_);
        if (!this.getSheetMusic().m_41619_()) {
            p_189515_1_.m_128365_("SheetMusicItem", (Tag)this.getSheetMusic().m_41739_(new CompoundTag()));
        }
        return p_189515_1_;
    }

    public ItemStack getSheetMusic() {
        return this.sheetMusic;
    }

    public void setSheetMusic(ItemStack itemStack, boolean isPlayerAction) {
        ItemStack itemStackCopy = itemStack.m_41777_();
        itemStackCopy.m_41764_(1);
        this.sheetMusic = itemStackCopy;
        this.m_6596_();
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && !isPlayerAction) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void m_6211_() {
        this.sheetMusic = ItemStack.f_41583_;
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.m_128379_("PlayMusic", !this.getSheetMusic().m_41619_());
        if (this.sheetMusic.m_41720_() instanceof SheetMusicItem) {
            nbtTag.m_128405_("SheetMusicId", ((SheetMusicItem)this.sheetMusic.m_41720_()).getMusic().getId());
        }
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, nbtTag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbtTag = pkt.m_131708_();
        if (nbtTag.m_128471_("PlayMusic")) {
            int id = nbtTag.m_128451_("SheetMusicId");
            this.currentMusic = SheetMusicItem.createMusicBoxSound(ChristmasMusic.getMusic(id), this.f_58858_);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.currentMusic);
        } else if (this.currentMusic != null) {
            this.currentMusic.stopTrack();
            this.currentMusic = null;
        }
    }

    public void stopMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stopTrack();
            this.currentMusic = null;
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.currentMusic != null && !this.currentMusic.m_7801_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.playing", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

