/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.blockentity.christmas;

import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.misc.StockingBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.ChristmasEntityBlock;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlockEntities;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class StockingBlockEntity
extends BlockEntity
implements ChristmasEntityBlock {
    public static final String BLOCK_ENTITY_ID = "stocking";
    private static final ResourceLocation STOCKING_PRESENTS_LOOT_TABLE = new ResourceLocation("happyholidays:blocks/stocking_presents");
    private boolean isEmpty = true;
    private boolean isDoneForNight = false;
    private Random random = new Random();

    public StockingBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public StockingBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ChristmasBlockEntities.STOCKING_ENTITY_TYPE.get(), pos, state);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isDoneForNight() {
        return this.isDoneForNight;
    }

    public void resetStocking() {
        this.isDoneForNight = false;
    }

    public void fillStocking() {
        this.isEmpty = false;
        this.isDoneForNight = true;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)StockingBlock.FILLED, (Comparable)Boolean.valueOf(true)), 2);
        for (int i = 0; i < 5; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.random.nextDouble(), this.random.nextDouble() + 0.5, this.random.nextDouble(), 1, d0, d1, d2, 0.0);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public void dropStockingItems() {
        LootTable lootTable = this.f_58857_.m_142572_().m_129898_().m_79217_(STOCKING_PRESENTS_LOOT_TABLE);
        LootContext ctx = new LootContext.Builder((ServerLevel)this.f_58857_).m_78977_(this.random).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_())).m_78972_(LootContextParams.f_81461_, (Object)this.m_58900_()).m_78972_(LootContextParams.f_81463_, (Object)Items.f_42424_.m_7968_()).m_78975_(LootContextParamSets.f_81421_);
        lootTable.m_79129_(ctx).forEach(itemStack -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStack));
        this.isEmpty = true;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)StockingBlock.FILLED, (Comparable)Boolean.valueOf(false)), 2);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128379_("IsEmpty", this.isEmpty);
        nbt.m_128379_("IsDoneForNight", this.isDoneForNight);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isEmpty = nbt.m_128471_("IsEmpty");
        this.isDoneForNight = nbt.m_128471_("IsDoneForNight");
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.m_128379_("IsEmpty", this.isEmpty);
        nbtTag.m_128379_("IsDoneForNight", this.isDoneForNight);
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, nbtTag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbtTag = pkt.m_131708_();
        this.isEmpty = nbtTag.m_128471_("IsEmpty");
        this.isDoneForNight = nbtTag.m_128471_("IsDoneForNight");
    }
}

