/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.blockentity.christmas.star;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.block.christmas.misc.ChristmasStarBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.misc.ChristmasStarTier;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.ChristmasEntityBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarContainer;
import com.jumpcutfindo.happyholidays.common.entity.christmas.IChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.santa.BaseSantaEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.ChristmasStarEvent;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlockEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasParticles;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import com.jumpcutfindo.happyholidays.server.data.SantaSummonSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ChristmasStarBlockEntity
extends BaseContainerBlockEntity
implements ChristmasEntityBlock {
    public static final String BLOCK_ENTITY_ID = "christmas_star";
    public static final int SLOTS = 6;
    public static final int BONUS_SLOT_INDEX = 5;
    public static final int MAX_POINTS = 100;
    public static final int MAX_RADIUS_INDEX = 5;
    public static final int[] PLAYER_EFFECT_RADIUS = new int[]{0, 8, 16, 24, 32, 40};
    public static final int[] ENTITY_EFFECT_RADIUS = new int[]{0, 8, 16, 24, 32, 40};
    public static final int[] BLOCK_EFFECT_RADIUS = new int[]{0, 4, 8, 12, 16, 20};
    private int currentTier;
    private int currentPoints;
    private boolean isSummoningSanta;
    private boolean isGoodSanta;
    private int summonSantaProgress;
    private AABB areaOfEffect;
    private final ServerBossEvent summonEvent = new ServerBossEvent((Component)new TranslatableComponent("entity.happyholidays.santa_is_coming"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int code) {
            switch (code) {
                case 0: {
                    return ChristmasStarBlockEntity.this.currentTier;
                }
                case 1: {
                    return ChristmasStarBlockEntity.this.currentPoints;
                }
            }
            return 0;
        }

        public void m_8050_(int code, int value) {
            switch (code) {
                case 0: {
                    ChristmasStarBlockEntity.this.currentTier = value;
                    break;
                }
                case 1: {
                    ChristmasStarBlockEntity.this.currentPoints = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);

    public ChristmasStarBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public ChristmasStarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ChristmasBlockEntities.CHRISTMAS_STAR_ENTITY_TYPE.get(), pos, state);
    }

    public void m_6339_() {
        ChristmasStarHelper.cacheStarLocation(this.m_58899_());
        super.m_6339_();
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.happyholidays.christmas_star");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new ChristmasStarContainer(id, playerInv, this);
    }

    public int m_6643_() {
        return 6;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int start, int end) {
        return ContainerHelper.m_18969_(this.items, (int)start, (int)end);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack itemStack) {
        this.items.set(index, (Object)itemStack);
    }

    public boolean m_6542_(Player playerEntity) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return playerEntity.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void applyPlayerEffects() {
        if (!this.f_58857_.m_5776_() && this.currentTier > 0) {
            AABB axisAlignedBB = new AABB(this.f_58858_).m_82400_((double)PLAYER_EFFECT_RADIUS[this.currentTier]);
            List playerList = this.f_58857_.m_45976_(Player.class, axisAlignedBB);
            for (Player playerEntity : playerList) {
                if (playerEntity.m_21124_((MobEffect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get()) == null) {
                    ((ServerLevel)this.f_58857_).m_5594_(null, playerEntity.m_142538_(), (SoundEvent)ChristmasSounds.CHRISTMAS_STAR_EFFECT_APPLY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                playerEntity.m_7292_(new MobEffectInstance((MobEffect)ChristmasEffects.SPIRIT_OF_CHRISTMAS_EFFECT.get(), 200, this.currentTier - 1, true, true));
            }
        }
    }

    public void applyEntityEffects() {
        if (!this.f_58857_.m_5776_() && this.currentTier > 0) {
            AABB axisAlignedBB = new AABB(this.f_58858_).m_82400_((double)ENTITY_EFFECT_RADIUS[this.currentTier]);
            List christmasEntities = this.f_58857_.m_6443_(LivingEntity.class, axisAlignedBB, entity -> entity instanceof IChristmasEntity);
            for (LivingEntity entity2 : christmasEntities) {
                entity2.m_7292_(new MobEffectInstance((MobEffect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get(), 200, this.currentTier - 1, true, true));
            }
        }
    }

    public void summonSanta() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            SantaSummonSavedData santaData = (SantaSummonSavedData)serverWorld.m_8895_().m_164861_(SantaSummonSavedData::createFromTag, SantaSummonSavedData::new, "happyholidays_santa");
            this.areaOfEffect = new AABB(this.m_58899_()).m_82400_(40.0);
            boolean isTierOK = this.getCurrentTier() >= 5;
            boolean isValidTime = santaData.canSummon(serverWorld.m_46467_());
            if (!isTierOK) {
                return;
            }
            if (!isValidTime) {
                long timeRemaining = santaData.getNextSummonTime() - serverWorld.m_46467_();
                for (ServerPlayer serverPlayerEntity : serverWorld.m_8795_(playerEntity -> this.areaOfEffect.m_82390_(playerEntity.m_20182_()))) {
                    serverPlayerEntity.m_6352_((Component)new TranslatableComponent("chat.happyholidays.christmas_star.santa_not_ready", new Object[]{HappyHolidaysUtils.convertTicksToString(timeRemaining)}).m_130940_(ChatFormatting.RED), UUID.randomUUID());
                }
                return;
            }
            santaData.setLastSummonTime(this.f_58857_.m_46467_());
            santaData.m_77762_();
            int totalValue = 0;
            int totalPlayers = 0;
            for (ServerPlayer serverPlayerEntity : serverWorld.m_8795_(playerEntity -> this.areaOfEffect.m_82390_(playerEntity.m_20182_()))) {
                int value = NaughtyNiceMeter.getMeterValue((Player)serverPlayerEntity);
                totalValue += value;
                ++totalPlayers;
                NaughtyNiceMeter.resetMeter((Player)serverPlayerEntity);
                this.summonEvent.m_142711_((float)this.summonSantaProgress / 200.0f);
                this.summonEvent.m_6543_(serverPlayerEntity);
            }
            if (totalPlayers == 0) {
                return;
            }
            int averageValue = totalValue / totalPlayers;
            if (averageValue >= 10) {
                this.isGoodSanta = true;
            } else if (averageValue <= -10) {
                this.isGoodSanta = false;
            } else {
                boolean bl = this.isGoodSanta = Math.random() < 0.5;
            }
            if (this.isGoodSanta) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ChristmasSounds.SANTA_SPAWNING_GOOD.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ChristmasSounds.SANTA_SPAWNING_BAD.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.isSummoningSanta = true;
            this.summonSantaProgress = 200;
        }
    }

    public void finishSummonSanta() {
        BaseSantaEntity santaEntity = null;
        MutableComponent santaText = null;
        if (this.isGoodSanta) {
            santaEntity = (BaseSantaEntity)((EntityType)ChristmasEntities.HAPPY_SANTA.get()).m_20615_(this.f_58857_);
            santaText = new TranslatableComponent("entity.happyholidays.santa_arrival_happy").m_130940_(ChatFormatting.AQUA);
        } else {
            santaEntity = (BaseSantaEntity)((EntityType)ChristmasEntities.ANGRY_SANTA.get()).m_20615_(this.f_58857_);
            santaText = new TranslatableComponent("entity.happyholidays.santa_arrival_angry").m_130940_(ChatFormatting.RED);
        }
        List playerList = this.f_58857_.m_45976_(Player.class, this.areaOfEffect);
        MutableComponent finalSantaText = santaText;
        playerList.forEach(arg_0 -> this.lambda$finishSummonSanta$3((Component)finalSantaText, arg_0));
        santaEntity.m_6027_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, this.m_58899_().m_123343_());
        this.f_58857_.m_7967_((Entity)santaEntity);
        this.isSummoningSanta = false;
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ChristmasSounds.SANTA_SPAWN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.summonEvent.m_7706_();
    }

    public int getCurrentTier() {
        return this.currentTier;
    }

    public boolean isBonusActive() {
        return !((ItemStack)this.items.get(5)).m_41619_();
    }

    public boolean isPosAffected(BlockPos pos) {
        return new AABB(this.m_58899_()).m_82400_((double)BLOCK_EFFECT_RADIUS[this.currentTier]).m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    private void updatePoints() {
        int newPoints = 0;
        ArrayList itemStackList = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStackList.stream().anyMatch(itemStack1 -> ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)itemStack1))) continue;
            itemStackList.add(itemStack);
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                newPoints += 5;
                continue;
            }
            if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                newPoints += 10;
                continue;
            }
            if (!ChristmasItems.isLegendaryOrnamentItem(itemStack)) continue;
            newPoints += 20;
        }
        this.currentPoints = Math.min(newPoints, 100);
        if (this.currentPoints < 20) {
            this.changeTier(0);
        } else if (this.currentPoints < 40) {
            this.changeTier(1);
        } else if (this.currentPoints < 60) {
            this.changeTier(2);
        } else if (this.currentPoints < 80) {
            this.changeTier(3);
        } else if (this.currentPoints < 100) {
            this.changeTier(4);
        } else {
            this.changeTier(5);
        }
    }

    private void changeTier(int newTier) {
        int oldTier = this.currentTier;
        this.currentTier = newTier;
        if (oldTier != newTier && this.f_58857_ != null) {
            ChristmasStarTier starTier = newTier == 0 ? ChristmasStarTier.TIER_0 : (newTier == 1 ? ChristmasStarTier.TIER_1 : (newTier == 2 ? ChristmasStarTier.TIER_2 : (newTier == 3 ? ChristmasStarTier.TIER_3 : (newTier == 4 ? ChristmasStarTier.TIER_4 : ChristmasStarTier.TIER_5))));
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ChristmasStarBlock.STAR_TIER, (Comparable)((Object)starTier)), 0);
            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 1.0f + (float)newTier * 0.1f);
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
        if (oldTier < newTier && !this.f_58857_.m_5776_()) {
            BlockPos blockPos = this.m_58899_();
            Player playerEntity = this.f_58857_.m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 10.0, false);
            if (playerEntity != null) {
                ChristmasStarEvent.IncreaseTier event = new ChristmasStarEvent.IncreaseTier(this, playerEntity);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.m_6596_();
        }
        if (oldTier < newTier && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("StarTier", this.currentTier);
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag.m_128441_("StarTier")) {
            this.changeTier(tag.m_128451_("StarTier"));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, ChristmasStarBlockEntity blockEntity) {
        if (level != null && !level.m_5776_()) {
            if (level.m_46467_() % 80L == 0L) {
                blockEntity.applyPlayerEffects();
                blockEntity.applyEntityEffects();
            }
            if (blockEntity.isSummoningSanta) {
                double d0 = Math.random() * 0.1 + 0.25;
                double d1 = Math.random() * 0.1 + 0.25;
                double d2 = Math.random() * 0.1 + 0.25;
                double d = Math.random();
                SimpleParticleType particleType = d < 0.5 ? (SimpleParticleType)ChristmasParticles.CHRISTMAS_SANTA_GREEN_SPAWN_PARTICLE.get() : (SimpleParticleType)ChristmasParticles.CHRISTMAS_SANTA_RED_SPAWN_PARTICLE.get();
                ((ServerLevel)level).m_8767_((ParticleOptions)particleType, (double)blockEntity.m_58899_().m_123341_() + 0.5, (double)blockEntity.m_58899_().m_123342_() + d1 + 1.5, (double)blockEntity.m_58899_().m_123343_() + 0.5, 2, d0, d1, d2, 0.0);
                if (level.m_46467_() % 60L == 0L) {
                    List playerList = level.m_45976_(Player.class, blockEntity.areaOfEffect);
                    for (ServerPlayer serverPlayerEntity : blockEntity.summonEvent.m_8324_()) {
                        if (playerList.contains(serverPlayerEntity)) continue;
                        blockEntity.summonEvent.m_6539_(serverPlayerEntity);
                    }
                    for (Player playerEntity : playerList) {
                        ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
                        if (blockEntity.summonEvent.m_8324_().contains(serverPlayerEntity)) continue;
                        blockEntity.summonEvent.m_6543_((ServerPlayer)playerEntity);
                    }
                }
                blockEntity.summonEvent.m_142711_((float)(200 - blockEntity.summonSantaProgress) / 200.0f);
            }
            if (blockEntity.isSummoningSanta && --blockEntity.summonSantaProgress <= 0) {
                blockEntity.finishSummonSanta();
            }
            if (blockEntity.isBonusActive() && level.m_46467_() % 80L == 0L) {
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ChristmasParticles.CHRISTMAS_STAR_PARTICLE.get()), (double)blockEntity.m_58899_().m_123341_() + 0.5, (double)blockEntity.m_58899_().m_123342_() + 0.5, (double)blockEntity.m_58899_().m_123343_() + 0.5, 3, 0.5, 0.0, 0.5, 0.0);
            }
        }
        blockEntity.updatePoints();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.currentTier = nbt.m_128451_("CurrentTier");
        this.currentPoints = nbt.m_128451_("CurrentPoints");
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        nbt.m_128405_("CurrentTier", this.currentTier);
        nbt.m_128405_("CurrentPoints", this.currentPoints);
        return nbt;
    }

    private /* synthetic */ void lambda$finishSummonSanta$3(Component finalSantaText, Player playerEntity) {
        playerEntity.m_6352_(finalSantaText, UUID.randomUUID());
        ChristmasStarEvent.SummonSanta summonEvent = new ChristmasStarEvent.SummonSanta(this, playerEntity);
        MinecraftForge.EVENT_BUS.post((Event)summonEvent);
    }
}

