/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.blockentity.christmas.star;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.WorldEvent;

public class ChristmasStarHelper {
    public static Set<BlockPos> starLocations = Sets.newHashSet();

    public static void onWorldLoad(WorldEvent.Load event) {
        ChristmasStarHelper.clearCache();
    }

    public static void clearCache() {
        starLocations = Sets.newHashSet();
    }

    public static void cacheStarLocation(BlockPos starLocation) {
        if (starLocation != null) {
            starLocations.add(starLocation);
        }
    }

    public static void removeStarLocation(BlockPos starLocation) {
        starLocations.remove(starLocation);
    }

    public static ChristmasStarBlockEntity getStarInfluencingPos(Level level, BlockPos blockPos, int[] radii, int maxIndex) {
        int maxRadius = radii[maxIndex];
        List<ChristmasStarBlockEntity> blockEntityList = ChristmasStarHelper.getStarsInRadius(level, blockPos, maxRadius);
        ChristmasStarBlockEntity influencingBlockEntity = null;
        for (ChristmasStarBlockEntity blockEntity : blockEntityList) {
            int effectRadius = radii[blockEntity.getCurrentTier()];
            AABB effectBoundingBox = new AABB(blockEntity.m_58899_()).m_82400_((double)effectRadius);
            if (!effectBoundingBox.m_82393_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()) || influencingBlockEntity != null && blockEntity.getCurrentTier() <= influencingBlockEntity.getCurrentTier()) continue;
            influencingBlockEntity = blockEntity;
        }
        return influencingBlockEntity;
    }

    public static ChristmasStarBlockEntity getStarInfluencingEntity(Level level, Vec3 vector3d) {
        return ChristmasStarHelper.getStarInfluencingPos(level, new BlockPos(vector3d), ChristmasStarBlockEntity.ENTITY_EFFECT_RADIUS, 5);
    }

    public static ChristmasStarBlockEntity getStarInfluencingBlock(Level level, BlockPos pos) {
        return ChristmasStarHelper.getStarInfluencingPos(level, pos, ChristmasStarBlockEntity.BLOCK_EFFECT_RADIUS, 5);
    }

    public static List<ChristmasStarBlockEntity> getStarsInRadius(Level level, BlockPos pos, int maxRadius) {
        AABB blockBoundingBox = new AABB(pos).m_82400_((double)maxRadius);
        List relevantLocations = starLocations.stream().filter(starLocation -> {
            int x = starLocation.m_123341_();
            int y = starLocation.m_123342_();
            int z = starLocation.m_123343_();
            return blockBoundingBox.m_82393_((double)x, (double)y, (double)z);
        }).collect(Collectors.toList());
        ArrayList starBlockEntities = Lists.newArrayList();
        for (BlockPos starLocation2 : relevantLocations) {
            BlockEntity blockEntity = level.m_7702_(starLocation2);
            if (!(blockEntity instanceof ChristmasStarBlockEntity)) continue;
            starBlockEntities.add((ChristmasStarBlockEntity)blockEntity);
        }
        return starBlockEntities;
    }
}

