/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.capabilities.christmas;

import com.jumpcutfindo.happyholidays.common.capabilities.christmas.CapabilityNaughtyNice;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.INaughtyNiceHandler;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class NaughtyNiceMeter
implements INaughtyNiceHandler {
    public static final int VALUE_NICE_MAX = 200;
    public static final int VALUE_NICE_MIN = 10;
    public static final int VALUE_NAUGHTY_MIN = -10;
    public static final int VALUE_NAUGHTY_MAX = -200;
    private int value;

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void addNaughty(int value) {
        this.addValue(-value);
    }

    @Override
    public void addNice(int value) {
        this.addValue(value);
    }

    private void addValue(int actualValue) {
        this.value += actualValue;
        if (this.value <= -200) {
            this.value = -200;
        }
        if (this.value >= 200) {
            this.value = 200;
        }
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public boolean isNaughty() {
        return this.value <= -10;
    }

    @Override
    public boolean isNice() {
        return this.value >= 10;
    }

    @Override
    public boolean isNeutral() {
        return this.value > -10 && this.value < 10;
    }

    public boolean isMaxNice() {
        return this.value == 200;
    }

    public boolean isMaxNaughty() {
        return this.value == -200;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("NaughtyNiceValue", this.getValue());
        return nbt;
    }

    public NaughtyNiceMeter readFromNBT(CompoundTag nbt) {
        this.value = nbt.m_128451_("NaughtyNiceValue");
        return this;
    }

    public static void evaluateAction(Player playerEntity, NaughtyNiceAction action) {
        if (playerEntity == null) {
            return;
        }
        Optional naughtyNiceCapability = playerEntity.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
        if (naughtyNiceCapability.isPresent()) {
            INaughtyNiceHandler naughtyNiceMeter = (INaughtyNiceHandler)naughtyNiceCapability.get();
            if (action.getActionType() == NaughtyNiceAction.Type.NAUGHTY) {
                naughtyNiceMeter.addNaughty(action.getCost());
            } else {
                naughtyNiceMeter.addNice(action.getCost());
            }
        }
    }

    public static int getMeterValue(Player playerEntity) {
        if (playerEntity == null) {
            return 0;
        }
        Optional naughtyNiceCapability = playerEntity.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
        if (naughtyNiceCapability.isPresent()) {
            NaughtyNiceMeter naughtyNiceMeter = (NaughtyNiceMeter)naughtyNiceCapability.get();
            return naughtyNiceMeter.getValue();
        }
        return 0;
    }

    public static void resetMeter(Player playerEntity) {
        if (playerEntity == null) {
            return;
        }
        Optional naughtyNiceCapability = playerEntity.getCapability(CapabilityNaughtyNice.NAUGHTY_NICE_CAPABILITY).resolve();
        if (naughtyNiceCapability.isPresent()) {
            NaughtyNiceMeter naughtyNiceMeter = (NaughtyNiceMeter)naughtyNiceCapability.get();
            naughtyNiceMeter.setValue(0);
        }
    }
}

