/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.container.christmas.gifts;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.GiftWrapperBlockEntity;
import com.jumpcutfindo.happyholidays.common.container.christmas.gifts.GiftWrapperResultSlot;
import com.jumpcutfindo.happyholidays.common.item.christmas.gifts.ChristmasGiftItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasContainers;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GiftWrapperContainer
extends AbstractContainerMenu {
    public static final String CONTAINER_ID = "gift_wrapping_station";
    public final GiftWrapperBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    private final Inventory playerInv;
    public Slot stringSlot;
    public Slot paperSlot;
    public Slot dyeSlot;
    public Slot resultSlot;
    public List<Slot> giftItemSlots;

    public GiftWrapperContainer(int windowId, Inventory playerInv, GiftWrapperBlockEntity blockEntity) {
        super((MenuType)ChristmasContainers.GIFT_WRAPPER_CONTAINER.get(), windowId);
        this.blockEntity = blockEntity;
        this.playerInv = playerInv;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.stringSlot = this.m_38897_(new Slot((Container)blockEntity, 0, 16, 16));
        this.paperSlot = this.m_38897_(new Slot((Container)blockEntity, 1, 16, 41));
        this.dyeSlot = this.m_38897_(new Slot((Container)blockEntity, 2, 16, 66));
        this.giftItemSlots = Lists.newArrayList();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.giftItemSlots.add(this.m_38897_(new Slot((Container)blockEntity, 3 + i * 3 + j, 51 + j * 18, 32 + i * 18)));
            }
        }
        this.resultSlot = this.m_38897_(new GiftWrapperResultSlot((Container)blockEntity, 9, 140, 40));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 189 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 165));
        }
    }

    public GiftWrapperContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, GiftWrapperContainer.getBlockEntity(playerInv, data));
    }

    public void m_6877_(Player p_75134_1_) {
        super.m_6877_(p_75134_1_);
        this.playerInv.m_5785_(p_75134_1_);
    }

    public static void handleSlotsChanged(int containerId, int stateId, Level world, Player playerEntity, Container playerInv, Container giftWrapperInv) {
        if (!world.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ItemStack itemStack = ItemStack.f_41583_;
            if (GiftWrapperContainer.checkAllItemsPresent(giftWrapperInv)) {
                itemStack = GiftWrapperBlockEntity.assembleGift(playerEntity, giftWrapperInv);
            }
            giftWrapperInv.m_6836_(9, itemStack);
            giftWrapperInv.m_6596_();
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(containerId, stateId, 9, itemStack));
        }
    }

    public static boolean checkAllItemsPresent(Container giftWrapperInv) {
        ItemStack stringItems = giftWrapperInv.m_8020_(0);
        ItemStack paperItems = giftWrapperInv.m_8020_(1);
        ItemStack dyeItems = giftWrapperInv.m_8020_(2);
        if (ItemStack.m_41746_((ItemStack)stringItems, (ItemStack)Items.f_42401_.m_7968_()) && stringItems.m_41613_() >= 2 && ItemStack.m_41746_((ItemStack)paperItems, (ItemStack)Items.f_42516_.m_7968_()) && paperItems.m_41613_() >= 4 && GiftWrapperBlockEntity.isValidColourModifier(dyeItems)) {
            for (int i = 3; i <= 8; ++i) {
                if (giftWrapperInv.m_8020_(i).m_41619_() || giftWrapperInv.m_8020_(i).m_41720_() instanceof ChristmasGiftItem) continue;
                return true;
            }
        }
        return false;
    }

    public void m_6199_(Container inventory) {
        this.canInteractWithCallable.m_39292_((world, blockPos) -> GiftWrapperContainer.handleSlotsChanged(this.f_38840_, this.m_182424_(), world, this.playerInv.f_35978_, (Container)this.playerInv, (Container)this.blockEntity));
    }

    public boolean m_6875_(Player playerEntity) {
        return this.playerInv.m_6542_(playerEntity);
    }

    private static GiftWrapperBlockEntity getBlockEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "Packet buffer cannot be null");
        BlockEntity te = playerInv.f_35978_.m_20193_().m_7702_(data.m_130135_());
        if (te instanceof GiftWrapperBlockEntity) {
            return (GiftWrapperBlockEntity)te;
        }
        throw new IllegalStateException("Incorrect tile entity!");
    }

    public ItemStack m_7648_(Player playerEntity, int selectedSlot) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(selectedSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (slot.equals(this.stringSlot) || slot.equals(this.paperSlot) || slot.equals(this.dyeSlot) || this.giftItemSlots.contains(slot) || slot.equals(this.resultSlot) ? !this.m_38903_(itemStack1, 10, 46, false) : (ItemStack.m_41746_((ItemStack)itemStack1, (ItemStack)Items.f_42401_.m_7968_()) ? !this.m_38903_(itemStack1, this.stringSlot.getSlotIndex(), this.stringSlot.getSlotIndex() + 1, false) : (ItemStack.m_41746_((ItemStack)itemStack1, (ItemStack)Items.f_42516_.m_7968_()) ? !this.m_38903_(itemStack1, this.paperSlot.getSlotIndex(), this.paperSlot.getSlotIndex() + 1, false) : (GiftWrapperBlockEntity.isValidColourModifier(itemStack) ? !this.m_38903_(itemStack1, this.dyeSlot.getSlotIndex(), this.dyeSlot.getSlotIndex() + 1, false) : !this.m_38903_(itemStack1, 3, 3 + this.giftItemSlots.size(), false))))) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerEntity, itemStack1);
        }
        return ItemStack.f_41583_;
    }
}

