/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.container.christmas.star;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarBonusSlot;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarSlot;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasContainers;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChristmasStarContainer
extends AbstractContainerMenu {
    public static final String CONTAINER_ID = "christmas_star";
    public final ChristmasStarBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    private final Container container;
    private final ContainerData data;
    private List<Slot> ornamentSlots;
    private Slot bonusSlot;

    public ChristmasStarContainer(int windowId, Inventory playerInv, ChristmasStarBlockEntity blockEntity) {
        super((MenuType)ChristmasContainers.CHRISTMAS_STAR_CONTAINER.get(), windowId);
        this.blockEntity = blockEntity;
        this.container = playerInv;
        this.data = blockEntity.dataAccess;
        this.m_38884_(this.blockEntity.dataAccess);
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.ornamentSlots = Lists.newArrayList((Object[])new Slot[]{this.m_38897_(new ChristmasStarSlot(blockEntity, 0, 80, 15)), this.m_38897_(new ChristmasStarSlot(blockEntity, 1, 48, 43)), this.m_38897_(new ChristmasStarSlot(blockEntity, 2, 112, 43)), this.m_38897_(new ChristmasStarSlot(blockEntity, 3, 58, 77)), this.m_38897_(new ChristmasStarSlot(blockEntity, 4, 102, 77))});
        this.bonusSlot = this.m_38897_(new ChristmasStarBonusSlot(blockEntity, 5, 152, 77));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 190 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 166));
        }
    }

    public ChristmasStarContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, ChristmasStarContainer.getBlockEntity(playerInv, data));
    }

    public ItemStack m_7648_(Player playerEntity, int selectedSlot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(selectedSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            for (Slot ornamentSlot : this.ornamentSlots) {
                if (!slot.equals(ornamentSlot) || this.m_38903_(itemstack1, 6, 42, false)) continue;
                return ItemStack.f_41583_;
            }
            if (slot.equals(this.bonusSlot) && !this.m_38903_(itemstack1, 6, 42, false)) {
                return ItemStack.f_41583_;
            }
            if (ChristmasItems.isOrnamentItem(itemstack1) && !this.m_38903_(itemstack1, this.ornamentSlots.get(0).getSlotIndex(), this.ornamentSlots.get(this.ornamentSlots.size() - 1).getSlotIndex() + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (ItemStack.m_41746_((ItemStack)itemstack1, (ItemStack)((ChristmasItem)ChristmasItems.ENCHANTED_SANTA_HAT.get()).m_7968_()) && !this.m_38903_(itemstack1, this.bonusSlot.getSlotIndex(), this.bonusSlot.getSlotIndex() + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerEntity, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player p_75134_1_) {
        super.m_6877_(p_75134_1_);
        this.container.m_5785_(p_75134_1_);
    }

    public boolean m_6875_(Player playerEntity) {
        return this.container.m_6542_(playerEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentPoints() {
        return this.data.m_6413_(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentTier() {
        return this.data.m_6413_(0);
    }

    public ChristmasStarBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private static ChristmasStarBlockEntity getBlockEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "Packet buffer cannot be null");
        BlockEntity te = playerInv.f_35978_.m_20193_().m_7702_(data.m_130135_());
        if (te instanceof ChristmasStarBlockEntity) {
            return (ChristmasStarBlockEntity)te;
        }
        throw new IllegalStateException("Incorrect tile entity!");
    }
}

