/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarBlockEntity;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.IChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequest;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequests;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRewards;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfTrades;
import com.jumpcutfindo.happyholidays.common.events.christmas.SantaElfEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SantaElfEntity
extends PathfinderMob
implements IAnimatable,
Merchant,
IChristmasEntity {
    public static final String ENTITY_ID = "santa_elf";
    public static final AttributeSupplier ENTITY_ATTRIBUTES = Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.27).m_22265_();
    public static final float ENTITY_BOX_SIZE = 0.8f;
    public static final float ENTITY_BOX_HEIGHT = 1.375f;
    public static final int DEFAULT_DESPAWN_DELAY = 24000;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    private int despawnDelay = 24000;
    private SantaElfRequest santaElfRequest;
    private int santaElfRequestOfferIndex = -1;
    private int requestItemCooldown = 0;
    private int requestPaperCooldown = 0;
    private boolean isRewardThrown = false;
    private boolean isRequestOutdated = false;
    private int timeToCompleteRequest;

    public SantaElfEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        if (this.santaElfRequest == null) {
            this.santaElfRequest = SantaElfRequests.createRandomRequest(this.f_19853_.m_46467_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TradeWithPlayerGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PickupRequestedItemGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SwapToyPartsRequestGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtCustomerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_PASSIVE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_HURT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player playerEntity, InteractionHand hand) {
        if (this.m_6616_().isEmpty()) {
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.f_19853_.f_46443_) {
            MobEffectInstance christmasDebuff = this.m_21124_((MobEffect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get());
            if (christmasDebuff != null) {
                ChristmasStarBlockEntity starBlockEntity = ChristmasStarHelper.getStarInfluencingEntity(this.f_19853_, this.m_20182_());
                double discount = starBlockEntity != null && starBlockEntity.isBonusActive() ? 0.8 : 0.1 * (double)(christmasDebuff.m_19564_() + 1);
                for (MerchantOffer merchantOffer : this.offers) {
                    merchantOffer.m_45359_(0);
                    int j = (int)Math.floor(discount * (double)merchantOffer.m_45352_().m_41613_());
                    merchantOffer.m_45353_(-Math.max(j, 1));
                }
            }
            this.m_7189_(playerEntity);
            this.m_45301_(playerEntity, this.m_5446_(), 1);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void m_7189_(@Nullable Player playerEntity) {
        this.tradingPlayer = playerEntity;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void m_6255_(@Nullable MerchantOffers merchantOffers) {
    }

    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(merchantOffer);
        if (this.m_7962_() != null) {
            SantaElfEvent.Trade tradeEvent = new SantaElfEvent.Trade(this, this.m_7962_());
            MinecraftForge.EVENT_BUS.post((Event)tradeEvent);
        }
    }

    public void m_7713_(ItemStack itemStack) {
        if (!this.f_19853_.f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!itemStack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)ChristmasSounds.SANTA_ELF_YES.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean b) {
        return b ? (SoundEvent)ChristmasSounds.SANTA_ELF_YES.get() : (SoundEvent)ChristmasSounds.SANTA_ELF_NO.get();
    }

    public Level m_7133_() {
        return this.f_19853_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int i) {
    }

    public boolean m_7826_() {
        return false;
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.m_45383_()) {
            int i = 3 + this.f_19796_.nextInt(4);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    protected void updateTrades() {
        int randInt;
        MerchantOffer merchantOffer;
        MerchantOffer merchantOffer2;
        int randInt2;
        int i;
        MerchantOffers merchantOffers = this.m_6616_();
        ImmutableList tradesList = ImmutableList.of((Object)SantaElfTrades.SMALL_BALL_ORNAMENT_TRADES, (Object)SantaElfTrades.BIG_BALL_ORNAMENT_TRADES, (Object)SantaElfTrades.TINSEL_TRADES, (Object)SantaElfTrades.CHRISTMAS_LIGHT_TRADES);
        for (VillagerTrades.ItemListing[] trades : tradesList) {
            for (i = 0; i < 1; ++i) {
                randInt2 = this.f_19796_.nextInt(trades.length);
                VillagerTrades.ItemListing randomTrade = trades[randInt2];
                merchantOffer2 = randomTrade.m_5670_((Entity)this, this.f_19796_);
                if (merchantOffer2 == null) continue;
                merchantOffers.add((Object)merchantOffer2);
            }
        }
        ImmutableList rareTradesList = ImmutableList.of((Object)SantaElfTrades.HEAD_ORNAMENT_TRADES, (Object)SantaElfTrades.SHEET_MUSIC_TRADES);
        int rareTradeRandInt = this.f_19796_.nextInt(rareTradesList.size());
        if (rareTradeRandInt == 0) {
            int randInt3 = this.f_19796_.nextInt(rareTradesList.size());
            MerchantOffer merchantOffer3 = ((VillagerTrades.ItemListing[])rareTradesList.get(0))[randInt3].m_5670_((Entity)this, this.f_19796_);
            if (merchantOffer3 != null) {
                merchantOffers.add((Object)merchantOffer3);
            }
        } else if (rareTradeRandInt == 1) {
            for (i = 0; i < 2; ++i) {
                randInt2 = this.f_19796_.nextInt(((VillagerTrades.ItemListing[])rareTradesList.get(1)).length);
                merchantOffer = ((VillagerTrades.ItemListing[])rareTradesList.get(1))[randInt2].m_5670_((Entity)this, this.f_19796_);
                if (merchantOffer == null) continue;
                merchantOffers.add((Object)merchantOffer);
            }
        }
        for (i = 0; i < 2; ++i) {
            int randInt4 = this.f_19796_.nextInt(SantaElfTrades.FOOD_TRADES.length);
            merchantOffer = SantaElfTrades.FOOD_TRADES[randInt4].m_5670_((Entity)this, this.f_19796_);
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
        }
        ItemsForEmeraldsTrade santaElfRequestTrade = new ItemsForEmeraldsTrade(this.santaElfRequest.getRequestPaper(), 1, 1, 1, 2);
        MerchantOffer santaElfRequestOffer = santaElfRequestTrade.m_5670_((Entity)this, this.f_19796_);
        if (santaElfRequestOffer != null) {
            merchantOffers.add((Object)santaElfRequestOffer);
        }
        this.santaElfRequestOfferIndex = merchantOffers.indexOf((Object)santaElfRequestOffer);
        if (this.f_19796_.nextBoolean() && (merchantOffer2 = SantaElfTrades.SOMETIMES_APPEAR_TRADES[randInt = this.f_19796_.nextInt(SantaElfTrades.SOMETIMES_APPEAR_TRADES.length)].m_5670_((Entity)this, this.f_19796_)) != null) {
            merchantOffers.add((Object)merchantOffer2);
        }
        for (int i2 = 0; i2 < SantaElfTrades.ALWAYS_APPEAR_TRADES.length; ++i2) {
            merchantOffer2 = SantaElfTrades.ALWAYS_APPEAR_TRADES[i2].m_5670_((Entity)this, this.f_19796_);
            if (merchantOffer2 == null) continue;
            merchantOffers.add((Object)merchantOffer2);
        }
    }

    public SantaElfRequest getRequest() {
        return this.santaElfRequest;
    }

    public void handleRequestItemOnGround(ItemEntity itemEntity) {
        SantaElfRequest.SingleElfRequest completedRequest = this.getRequest().tryFulfilRequest(itemEntity.m_32055_());
        if (completedRequest != null) {
            this.pickUpSomeItems(itemEntity, completedRequest.getNumberOfItems());
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ChristmasSounds.SANTA_ELF_REQUEST_SINGLE_SUCCESS.get(), SoundSource.VOICE, 1.0f, 1.0f);
            this.requestItemCooldown = 40;
            this.isRequestOutdated = true;
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void handleRequestPaperOnGround(ItemEntity itemEntity) {
        if (!this.isRewardThrown && this.santaElfRequest.isCompleted()) {
            this.timeToCompleteRequest = 24000 - this.despawnDelay;
            this.m_7938_((Entity)itemEntity, itemEntity.m_32055_().m_41613_());
            this.throwRequestRewards();
            if (itemEntity.m_32057_() != null) {
                Player playerEntity = this.f_19853_.m_46003_(itemEntity.m_32057_());
                NaughtyNiceMeter.evaluateAction(playerEntity, NaughtyNiceAction.HELP_SANTA_ELF_EVENT);
                SantaElfEvent.CompleteRequest completeRequestEvent = new SantaElfEvent.CompleteRequest(this, playerEntity, this.timeToCompleteRequest);
                MinecraftForge.EVENT_BUS.post((Event)completeRequestEvent);
            }
            this.isRewardThrown = true;
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (this.isRequestOutdated && !this.santaElfRequest.isCompleted()) {
            this.m_7938_((Entity)itemEntity, itemEntity.m_32055_().m_41613_());
            this.m_19983_(this.getRequest().getRequestPaper());
            this.requestPaperCooldown = 40;
            this.isRequestOutdated = false;
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean isReadyToTakeRequestItem() {
        return this.requestItemCooldown <= 0;
    }

    public boolean isReadyToTakeRequestPaper() {
        return this.requestPaperCooldown <= 0;
    }

    public MerchantOffer getSantaElfRequestOffer() {
        return this.santaElfRequestOfferIndex == -1 ? null : (MerchantOffer)this.offers.get(this.santaElfRequestOfferIndex);
    }

    public void throwRequestRewards() {
        this.f_19853_.m_7967_((Entity)SantaElfRewards.generateCompletionXP(this.f_19853_, this.m_20182_()));
        LootContext ctx = this.m_7771_(false, DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
        SantaElfRewards.generateRewards(this, ctx).forEach(arg_0 -> ((SantaElfEntity)this).m_19983_(arg_0));
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ChristmasSounds.SANTA_ELF_REQUEST_COMPLETE.get(), SoundSource.VOICE, 1.0f, 1.0f);
        this.f_19853_.m_7967_((Entity)new FireworkRocketEntity(this.f_19853_, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.createCelebratoryFireworks()));
    }

    private ItemStack createCelebratoryFireworks() {
        ItemStack fireworkStack = Items.f_42688_.m_7968_();
        CompoundTag fireworkNBT = new CompoundTag();
        fireworkNBT.m_128405_("Flight", 2);
        CompoundTag explosionsNBT = new CompoundTag();
        explosionsNBT.m_128344_("Type", (byte)0);
        ArrayList colorList = Lists.newArrayList();
        colorList.add(((DyeItem)Items.f_42496_).m_41089_().m_41070_());
        colorList.add(((DyeItem)Items.f_42497_).m_41089_().m_41070_());
        explosionsNBT.m_128408_("Colors", (List)colorList);
        ListTag listWrapper = new ListTag();
        listWrapper.add((Object)explosionsNBT);
        fireworkNBT.m_128365_("Explosions", (Tag)listWrapper);
        fireworkStack.m_41784_().m_128365_("Fireworks", (Tag)fireworkNBT);
        return fireworkStack;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("DespawnDelay", this.despawnDelay);
        nbt.m_128365_("SantaElfRequest", (Tag)this.santaElfRequest.createTag());
        nbt.m_128365_("MerchantOffers", (Tag)this.m_6616_().m_45388_());
        nbt.m_128379_("IsRequestOutdated", this.isRequestOutdated);
        nbt.m_128379_("IsRewardThrown", this.isRewardThrown);
        nbt.m_128405_("TimeToCompleteRequest", this.timeToCompleteRequest);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = nbt.m_128451_("DespawnDelay");
        }
        if (nbt.m_128425_("SantaElfRequest", 10)) {
            this.santaElfRequest = SantaElfRequest.fromTag(nbt.m_128469_("SantaElfRequest"));
        }
        if (nbt.m_128425_("MerchantOffers", 10)) {
            this.offers = new MerchantOffers(nbt.m_128469_("MerchantOffers"));
        }
        this.isRequestOutdated = nbt.m_128471_("IsRequestOutdated");
        this.isRewardThrown = nbt.m_128471_("IsRewardThrown");
        this.timeToCompleteRequest = nbt.m_128451_("TimeToCompleteRequest");
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.maybeDespawn();
        }
        if (--this.requestItemCooldown > 0) {
            // empty if block
        }
        if (--this.requestPaperCooldown > 0) {
            // empty if block
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.isTrading() && --this.despawnDelay == 0) {
            this.despawnElf();
        }
    }

    public void despawnElf() {
        if (!this.f_19853_.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            SimpleParticleType particleType = ParticleTypes.f_123759_;
            for (int i = 0; i < 5; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                serverWorld.m_8767_((ParticleOptions)particleType, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
            }
            serverWorld.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.SANTA_ELF_DESPAWN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void pickUpSomeItems(ItemEntity itemEntity, int itemsToPickUpCount) {
        ItemStack itemStack = itemEntity.m_32055_();
        this.m_21053_(itemEntity);
        this.m_7938_((Entity)itemEntity, itemStack.m_41613_());
        if (itemsToPickUpCount < itemStack.m_41613_()) {
            ItemStack itemStackCopy = itemStack.m_41777_();
            itemStackCopy.m_41764_(itemStack.m_41613_() - itemsToPickUpCount);
            this.m_19983_(itemStackCopy);
        }
    }

    private static class TradeWithPlayerGoal
    extends Goal {
        private final SantaElfEntity mob;

        public TradeWithPlayerGoal(SantaElfEntity santaElfEntity) {
            this.mob = santaElfEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.m_6084_()) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            if (!this.mob.m_20096_()) {
                return false;
            }
            if (this.mob.f_19864_) {
                return false;
            }
            Player playerentity = this.mob.m_7962_();
            if (playerentity == null) {
                return false;
            }
            if (this.mob.m_20280_((Entity)playerentity) > 16.0) {
                return false;
            }
            return playerentity.f_36096_ != null;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.mob.m_7189_(null);
        }
    }

    private static class PickupRequestedItemGoal
    extends Goal {
        private SantaElfEntity santaElfEntity;
        private ItemEntity targetedEntity;

        public PickupRequestedItemGoal(SantaElfEntity santaElfEntity) {
            this.santaElfEntity = santaElfEntity;
        }

        public boolean m_8036_() {
            MerchantOffer requestOffer = this.santaElfEntity.getSantaElfRequestOffer();
            if (requestOffer == null || !requestOffer.m_45380_()) {
                return false;
            }
            SantaElfRequest request = this.santaElfEntity.getRequest();
            if (request.isCompleted()) {
                return false;
            }
            List nearbyEntities = this.santaElfEntity.f_19853_.m_45976_(ItemEntity.class, this.santaElfEntity.m_142469_().m_82377_(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!this.santaElfEntity.getRequest().isInRequest(entity.m_32055_())) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            if (this.targetedEntity != null || !this.targetedEntity.m_6084_()) {
                this.santaElfEntity.m_21573_().m_5624_((Entity)this.targetedEntity, 1.0);
                if (this.santaElfEntity.isReadyToTakeRequestItem() && this.targetedEntity.m_20280_((Entity)this.santaElfEntity) < 2.0) {
                    this.santaElfEntity.handleRequestItemOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class SwapToyPartsRequestGoal
    extends Goal {
        private SantaElfEntity santaElfEntity;
        private ItemEntity targetedEntity;

        public SwapToyPartsRequestGoal(SantaElfEntity santaElfEntity) {
            this.santaElfEntity = santaElfEntity;
        }

        public boolean m_8036_() {
            if (this.santaElfEntity.isRewardThrown) {
                return false;
            }
            List nearbyEntities = this.santaElfEntity.f_19853_.m_45976_(ItemEntity.class, this.santaElfEntity.m_142469_().m_82377_(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!ItemStack.m_41746_((ItemStack)entity.m_32055_(), (ItemStack)((ChristmasItem)ChristmasItems.TOY_PARTS_REQUEST.get()).m_7968_())) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            if (this.targetedEntity != null || !this.targetedEntity.m_6084_()) {
                this.santaElfEntity.m_21573_().m_5624_((Entity)this.targetedEntity, 1.0);
                if (this.santaElfEntity.isReadyToTakeRequestPaper() && this.targetedEntity.m_20280_((Entity)this.santaElfEntity) < 2.0) {
                    this.santaElfEntity.handleRequestPaperOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class LookAtCustomerGoal
    extends LookAtPlayerGoal {
        private final SantaElfEntity villager;

        public LookAtCustomerGoal(SantaElfEntity elfEntity) {
            super((Mob)elfEntity, Player.class, 8.0f);
            this.villager = elfEntity;
        }

        public boolean m_8036_() {
            if (this.villager.isTrading()) {
                this.f_25513_ = this.villager.m_7962_();
                return true;
            }
            return false;
        }
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block blockItem, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(new ItemStack((ItemLike)blockItem), emeraldCost, numberOfItems, maxUses, xp);
        }

        public ItemsForEmeraldsTrade(Item item, int emeraldCost, int numberOfItems, int xp) {
            this(new ItemStack((ItemLike)item), emeraldCost, numberOfItems, 6, xp);
        }

        public ItemsForEmeraldsTrade(Item item, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(new ItemStack((ItemLike)item), emeraldCost, numberOfItems, maxUses, xp);
        }

        public ItemsForEmeraldsTrade(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int xp) {
            this(itemStack, emeraldCost, numberOfItems, maxUses, xp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int xp, float priceMultiplier) {
            this.itemStack = itemStack;
            this.emeraldCost = emeraldCost;
            this.numberOfItems = numberOfItems;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack offerStack = new ItemStack((ItemLike)this.itemStack.m_41720_(), this.numberOfItems);
            offerStack.m_41751_(this.itemStack.m_41783_());
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), offerStack, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class EmeraldForItemsTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(ItemLike itemProvider, int cost, int maxUses, int xp) {
            this.item = itemProvider.m_5456_();
            this.cost = cost;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((ItemLike)this.item, this.cost);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

