/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;

public class SantaElfRequest {
    public Random random = new Random();
    public List<SingleElfRequest> requestedItemsList = new ArrayList<SingleElfRequest>();
    private long expiryTime;

    SantaElfRequest() {
    }

    public SingleElfRequest tryFulfilRequest(ItemStack stack) {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (request.isCompleted() || !request.tryFulfilRequest(stack)) continue;
            return request;
        }
        return null;
    }

    public boolean isInRequest(ItemStack stack) {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (!ItemStack.m_41746_((ItemStack)request.getRequestedItems(), (ItemStack)stack) || request.getNumberOfItems() > stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getRequestPaper() {
        ItemStack requestPaper = ((ChristmasItem)ChristmasItems.TOY_PARTS_REQUEST.get()).m_7968_();
        CompoundTag nbt = requestPaper.m_41784_();
        nbt.m_128365_("SantaElfRequest", (Tag)this.createTag());
        return requestPaper;
    }

    public boolean isCompleted() {
        for (SingleElfRequest request : this.requestedItemsList) {
            if (request.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public List<SingleElfRequest> getRequestedItems() {
        return this.requestedItemsList;
    }

    void addEntry(ItemStack itemStack, boolean isCompleted) {
        SingleElfRequest singleElfRequest = new SingleElfRequest(itemStack);
        if (isCompleted) {
            singleElfRequest.setCompleted();
        }
        this.requestedItemsList.add(singleElfRequest);
    }

    public static SantaElfRequest fromTag(CompoundTag nbt) {
        SantaElfRequest santaElfRequest = new SantaElfRequest();
        ListTag singleRequestsNBT = nbt.m_128437_("SingleRequests", 10);
        byte[] completedRequestNBT = nbt.m_128463_("RequestsCompleted");
        for (int i = 0; i < singleRequestsNBT.size(); ++i) {
            boolean isCompleted;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)singleRequestsNBT.m_128728_(i));
            boolean bl = isCompleted = completedRequestNBT[i] == 1;
            if (itemStack.m_41619_()) continue;
            santaElfRequest.addEntry(itemStack, isCompleted);
        }
        santaElfRequest.setExpiryTime(nbt.m_128454_("ExpiryTime"));
        return santaElfRequest;
    }

    public CompoundTag createTag() {
        CompoundTag nbt = new CompoundTag();
        ListTag singleRequestsNBT = new ListTag();
        for (SingleElfRequest singleElfRequest : this.requestedItemsList) {
            ItemStack itemstack = singleElfRequest.getRequestedItems();
            if (itemstack.m_41619_()) continue;
            singleRequestsNBT.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        ByteArrayTag completedRequestNBT = new ByteArrayTag(this.requestedItemsList.stream().map(request -> request.isCompleted() ? (byte)1 : (byte)0).collect(Collectors.toList()));
        nbt.m_128365_("SingleRequests", (Tag)singleRequestsNBT);
        nbt.m_128365_("RequestsCompleted", (Tag)completedRequestNBT);
        nbt.m_128365_("ExpiryTime", (Tag)LongTag.m_128882_((long)this.expiryTime));
        return nbt;
    }

    void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public class SingleElfRequest {
        private final ItemStack requestedItems;
        private boolean isCompleted;

        public SingleElfRequest(ItemStack requestedItems) {
            this.requestedItems = requestedItems;
        }

        public int getNumberOfItems() {
            return this.requestedItems.m_41613_();
        }

        public ItemStack getRequestedItems() {
            return this.requestedItems;
        }

        public boolean tryFulfilRequest(ItemStack stack) {
            if (ItemStack.m_41746_((ItemStack)stack, (ItemStack)this.requestedItems) && stack.m_41613_() >= this.requestedItems.m_41613_()) {
                this.setCompleted();
                return true;
            }
            return false;
        }

        public void setCompleted() {
            this.isCompleted = true;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public String toString() {
            if (this.requestedItems.m_41720_() instanceof RecordItem) {
                String itemName = ((RecordItem)this.requestedItems.m_41720_()).m_43050_().getString();
                return String.format("%d\u00d7 Music Disc [%s]", this.requestedItems.m_41613_(), itemName);
            }
            String itemName = this.requestedItems.m_41786_().getString();
            return String.format("%d\u00d7 %s", this.requestedItems.m_41613_(), itemName);
        }
    }
}

