/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfRequest;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SantaElfRequests {
    public static final long DEFAULT_EXPIRY = 24000L;
    public static final int TOTAL_NO_OF_ITEMS = 4;
    public static final int NO_OF_UNIQUE_BASIC_ITEMS = 2;
    public static final int MIN_BASIC_REQUESTABLE_ITEMS = 12;
    public static final int MAX_BASIC_REQUESTABLE_ITEMS = 48;
    public static final Tag<Item> BASIC_REQUESTABLE_ITEMS = ItemTags.m_13193_().m_13404_(new ResourceLocation("happyholidays", "christmas_elf_basic_requestables"));
    public static final int NO_OF_UNIQUE_INTERMEDIATE_ITEMS = 1;
    public static final int MIN_INTERMEDIATE_REQUESTABLE_ITEMS = 6;
    public static final int MAX_INTERMEDIATE_REQUESTABLE_ITEMS = 24;
    public static final Tag<Item> INTERMEDIATE_REQUESTABLE_ITEMS = ItemTags.m_13193_().m_13404_(new ResourceLocation("happyholidays", "christmas_elf_intermediate_requestables"));
    public static final int NO_OF_UNIQUE_ADVANCED_ITEMS = 1;
    public static final int MIN_ADVANCED_REQUESTABLE_ITEMS = 4;
    public static final int MAX_ADVANCED_REQUESTABLE_ITEMS = 12;
    public static final Tag<Item> ADVANCED_REQUESTABLE_ITEMS = ItemTags.m_13193_().m_13404_(new ResourceLocation("happyholidays", "christmas_elf_advanced_requestables"));
    public static final Tag<Item> ADVANCED_REQUESTABLE_ITEMS_ALTERNATE = ItemTags.m_13193_().m_13404_(new ResourceLocation("happyholidays", "christmas_elf_advanced_requestables_alternate"));

    public static SantaElfRequest createRandomRequest(long gameTime) {
        ItemStack randomItem;
        int i;
        SantaElfRequest request = new SantaElfRequest();
        request.setExpiryTime(gameTime + 24000L);
        Random random = request.random;
        for (i = 0; i < 2; ++i) {
            randomItem = SantaElfRequests.getRandomRequestable(BASIC_REQUESTABLE_ITEMS, 12, 48, random);
            request.addEntry(randomItem, false);
        }
        for (i = 0; i < 1; ++i) {
            randomItem = SantaElfRequests.getRandomRequestable(INTERMEDIATE_REQUESTABLE_ITEMS, 6, 24, random);
            request.addEntry(randomItem, false);
        }
        for (i = 0; i < 1; ++i) {
            if (random.nextBoolean()) {
                randomItem = SantaElfRequests.getRandomRequestable(ADVANCED_REQUESTABLE_ITEMS, 4, 12, random);
                request.addEntry(randomItem, false);
                continue;
            }
            randomItem = SantaElfRequests.getRandomRequestable(ADVANCED_REQUESTABLE_ITEMS_ALTERNATE, 1, random);
            request.addEntry(randomItem, false);
        }
        return request;
    }

    public static ItemStack getRandomRequestable(Tag<Item> tag, int min, int max, Random random) {
        ItemStack itemStack = ((Item)tag.m_13288_(random)).m_5456_().m_7968_();
        int randomAmount = random.nextInt(max - min + 1) + min;
        itemStack.m_41764_(randomAmount);
        return itemStack;
    }

    public static ItemStack getRandomRequestable(Tag<Item> tag, int amount, Random random) {
        ItemStack itemStack = ((Item)tag.m_13288_(random)).m_5456_().m_7968_();
        itemStack.m_41764_(amount);
        return itemStack;
    }
}

