/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.elf;

import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasRewards;
import com.jumpcutfindo.happyholidays.common.entity.christmas.elf.SantaElfEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class SantaElfRewards {
    private static final ResourceLocation SANTA_ELF_REQUEST_LOOT_TABLE = new ResourceLocation("happyholidays:entities/santa_elf_request");
    public static final double REQUEST_REWARD_MULTIPLIER_STEP = 0.1;
    private static final double REQUEST_ORNAMENT_DROP_BASE_CHANCE = 0.2;
    public static final int COMPLETION_EXPERIENCE = 36;

    public static ExperienceOrb generateCompletionXP(Level level, Vec3 position) {
        return new ExperienceOrb(level, position.f_82479_, position.f_82480_, position.f_82481_, 36);
    }

    public static List<ItemStack> generateRewards(SantaElfEntity santaElfEntity, LootContext lootContext) {
        Level level = santaElfEntity.f_19853_;
        double modifier = ChristmasRewards.computeDropModifier(level, santaElfEntity.m_20182_(), 0.1);
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(SANTA_ELF_REQUEST_LOOT_TABLE);
        List<ItemStack> loot = SantaElfRewards.generateLoot(lootTable, lootContext, modifier, santaElfEntity.m_21187_());
        ItemStack elfOrnament = SantaElfRewards.generateOrnament(modifier, santaElfEntity.m_21187_());
        loot.add(elfOrnament);
        return loot;
    }

    private static List<ItemStack> generateLoot(LootTable lootTable, LootContext ctx, double modifier, Random random) {
        List loot = lootTable.m_79129_(ctx);
        loot.forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.m_41764_(random.nextInt(24) + 1 + 12);
            } else if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                itemStack.m_41764_(random.nextInt(4) + 1 + 4);
            } else if (ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).m_7968_())) {
                itemStack.m_41764_(random.nextInt(6) + 1 + 12);
            }
            if (!ChristmasRewards.isTool(itemStack)) {
                itemStack.m_41764_((int)((double)itemStack.m_41613_() * modifier));
            }
        });
        return loot;
    }

    private static ItemStack generateOrnament(double modifier, Random random) {
        double ornamentDropChance = 0.2 * modifier;
        if (random.nextDouble() <= ornamentDropChance) {
            return ((ChristmasBlockItem)ChristmasItems.SANTA_ELF_ORNAMENT.get()).m_7968_();
        }
        return ItemStack.f_41583_;
    }
}

