/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread;

import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasRewards;
import com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread.GingerbreadPersonEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class GingerbreadConversionRewards {
    private static final ResourceLocation GINGERBREAD_CONVERSION_LOOT_TABLE = new ResourceLocation("happyholidays:entities/gingerbread_conversion");
    public static final double CONVERSION_REWARD_MODIFIER_STEP = 0.1;
    private static final double CONVERSION_ORNAMENT_DROP_BASE_CHANCE = 0.01;

    public static List<ItemStack> generateRewards(GingerbreadPersonEntity gingerbreadPersonEntity, LootContext lootContext) {
        Level level = gingerbreadPersonEntity.f_19853_;
        double modifier = ChristmasRewards.computeDropModifier(level, gingerbreadPersonEntity.m_20182_(), 0.1);
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(GINGERBREAD_CONVERSION_LOOT_TABLE);
        List<ItemStack> loot = GingerbreadConversionRewards.generateLoot(lootTable, lootContext, modifier, gingerbreadPersonEntity.m_21187_());
        ItemStack gingerbreadOrnament = GingerbreadConversionRewards.generateOrnament(modifier, gingerbreadPersonEntity.m_21187_());
        loot.add(gingerbreadOrnament);
        return loot;
    }

    private static List<ItemStack> generateLoot(LootTable lootTable, LootContext ctx, double modifier, Random random) {
        List loot = lootTable.m_79129_(ctx);
        loot.forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.m_41764_(random.nextInt(1) + 1 + 1);
            }
            itemStack.m_41764_((int)((double)itemStack.m_41613_() * modifier));
            if (!ChristmasRewards.isTool(itemStack)) {
                itemStack.m_41764_((int)((double)itemStack.m_41613_() * modifier));
            }
        });
        return loot;
    }

    private static ItemStack generateOrnament(double modifier, Random random) {
        double ornamentDropChance = 0.01 * modifier;
        if (random.nextDouble() <= ornamentDropChance) {
            return ((ChristmasBlockItem)ChristmasItems.GINGERBREAD_MAN_ORNAMENT.get()).m_7968_();
        }
        return ItemStack.f_41583_;
    }
}

