/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread;

import com.jumpcutfindo.happyholidays.common.entity.christmas.IChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread.GingerbreadConversionRewards;
import com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread.SoggyGingerbreadManEntity;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GingerbreadPersonEntity
extends PathfinderMob
implements IAnimatable,
IChristmasEntity {
    public static final float ENTITY_BOX_SIZE = 0.8f;
    public static final float ENTITY_BOX_HEIGHT = 2.0f;
    public static final Item[] HEAT_EMITTING_ITEMS = new Item[]{Items.f_42781_, Items.f_42782_, Items.f_42258_, Items.f_42448_};
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean isLeader = false;

    public GingerbreadPersonEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FollowHeatSourceGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.25, entity -> {
            if (entity instanceof Player) {
                Player playerEntity = (Player)entity;
                ItemStack[] heldItems = new ItemStack[]{playerEntity.m_21205_(), playerEntity.m_21206_()};
                return Arrays.stream(heldItems).anyMatch(itemStack -> ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)Items.f_42447_.m_7968_()));
            }
            return false;
        }));
        this.f_21345_.m_25352_(3, (Goal)new FollowGingerbreadLeaderGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_PASSIVE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ChristmasSounds.GINGERBREAD_PERSON_HURT.get();
    }

    public void setLeader() {
        this.isLeader = true;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isSoggy() {
        return this instanceof SoggyGingerbreadManEntity;
    }

    public boolean m_5825_() {
        return false;
    }

    public void dropConversionLoot() {
        LootContext ctx = this.m_7771_(true, DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
        GingerbreadConversionRewards.generateRewards(this, ctx).forEach(arg_0 -> ((GingerbreadPersonEntity)this).m_19983_(arg_0));
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.gingerbread_man.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.gingerbread_man.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean checkGingerbreadSpawnRules(EntityType<? extends GingerbreadPersonEntity> entity, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, Random rand) {
        return world.m_45524_(pos, 0) > 8;
    }

    public static boolean isValidHeatItem(ItemStack itemStack) {
        return Arrays.stream(HEAT_EMITTING_ITEMS).anyMatch(item -> ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)item.m_7968_()));
    }

    public static boolean isValidHeatSource(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50094_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false || blockState.m_60713_(Blocks.f_50620_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false || blockState.m_60713_(Blocks.f_50619_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false || blockState.m_60713_(Blocks.f_50083_) || blockState.m_60713_(Blocks.f_50084_) || blockState.m_60713_(Blocks.f_50683_) || blockState.m_60713_(Blocks.f_50684_) || blockState.m_60713_(Blocks.f_50450_) || blockState.m_60713_(Blocks.f_49991_);
    }

    private static class FollowHeatSourceGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0);
        private final GingerbreadPersonEntity gingerbreadPerson;
        private Player player;

        public FollowHeatSourceGoal(GingerbreadPersonEntity gingerbreadPerson) {
            this.gingerbreadPerson = gingerbreadPerson;
        }

        public boolean m_8036_() {
            if (!this.gingerbreadPerson.isSoggy()) {
                return false;
            }
            this.player = this.gingerbreadPerson.f_19853_.m_45946_(TEMP_TARGETING, (LivingEntity)this.gingerbreadPerson);
            if (this.player == null) {
                return false;
            }
            ItemStack[] heldItems = new ItemStack[]{this.player.m_21205_(), this.player.m_21206_()};
            return Arrays.stream(heldItems).anyMatch(GingerbreadPersonEntity::isValidHeatItem);
        }

        public void m_8037_() {
            this.gingerbreadPerson.m_21391_((Entity)this.player, this.gingerbreadPerson.m_8085_() + 20, this.gingerbreadPerson.m_8132_());
            if (this.gingerbreadPerson.m_20280_((Entity)this.player) < 6.25) {
                this.gingerbreadPerson.m_21573_().m_26573_();
            } else {
                this.gingerbreadPerson.m_21573_().m_5624_((Entity)this.player, 1.0);
            }
        }
    }

    private static class FollowGingerbreadLeaderGoal
    extends Goal {
        private GingerbreadPersonEntity gingerbreadPerson;
        private GingerbreadPersonEntity leader;
        private int timeToRecalcPath;

        public FollowGingerbreadLeaderGoal(GingerbreadPersonEntity gingerbreadPerson) {
            this.gingerbreadPerson = gingerbreadPerson;
        }

        public boolean m_8036_() {
            if (this.gingerbreadPerson.isLeader()) {
                return false;
            }
            List<GingerbreadPersonEntity> list = this.getSurroundingGingerbreadPeople();
            if (this.canBeLeader()) {
                this.gingerbreadPerson.setLeader();
                return false;
            }
            for (GingerbreadPersonEntity entity : list) {
                if (!entity.isLeader()) continue;
                this.leader = entity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.leader.m_6084_()) {
                if (this.canBeLeader()) {
                    this.gingerbreadPerson.setLeader();
                }
                return false;
            }
            double d0 = this.gingerbreadPerson.m_20280_((Entity)this.leader);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        private boolean canBeLeader() {
            List<GingerbreadPersonEntity> entitiesAround = this.getSurroundingGingerbreadPeople();
            if (entitiesAround.isEmpty()) {
                return true;
            }
            for (GingerbreadPersonEntity entity : entitiesAround) {
                if (!entity.isLeader()) continue;
                return false;
            }
            return true;
        }

        private List<GingerbreadPersonEntity> getSurroundingGingerbreadPeople() {
            return this.gingerbreadPerson.f_19853_.m_45976_(GingerbreadPersonEntity.class, this.gingerbreadPerson.m_142469_().m_82377_(8.0, 4.0, 8.0));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.leader = null;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                this.gingerbreadPerson.m_21573_().m_5624_((Entity)this.leader, 1.0);
            }
        }
    }
}

