/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread;

import com.jumpcutfindo.happyholidays.common.entity.christmas.gingerbread.GingerbreadPersonEntity;
import com.jumpcutfindo.happyholidays.common.events.christmas.GingerbreadConversionEvent;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SoggyGingerbreadManEntity
extends GingerbreadPersonEntity {
    public static final String ENTITY_ID = "soggy_gingerbread_man";
    public static final AttributeSupplier ENTITY_ATTRIBUTES = SoggyGingerbreadManEntity.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.18).m_22265_();
    private float timeLeftToDry = 300.0f;

    public SoggyGingerbreadManEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_() && !this.m_20070_() && this.isNearFireSource() && (this.timeLeftToDry -= 1.0f) == 0.0f) {
            this.convertToDry();
        }
        if (this.f_19853_.m_5776_() && !this.m_20070_() && this.isNearFireSource()) {
            this.spawnSmokeParticles();
        }
    }

    private void spawnSmokeParticles() {
        EntityDimensions size = this.m_6972_(this.m_20089_());
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.nextDouble() * (double)size.f_20377_ - 0.5, this.m_20186_() + this.f_19796_.nextDouble() * (double)size.f_20378_, this.m_20189_() + this.f_19796_.nextDouble() * (double)size.f_20377_ - 0.5, 0.0, 0.0, 0.0);
    }

    private boolean isNearFireSource() {
        BlockPos pos1 = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_142082_(-1, -1, -1);
        BlockPos pos2 = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_142082_(1, 2, 1);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (!GingerbreadPersonEntity.isValidHeatSource(this.f_19853_.m_8055_(pos))) continue;
            return true;
        }
        return false;
    }

    private void convertToDry() {
        this.m_21406_((EntityType)ChristmasEntities.GINGERBREAD_MAN.get(), true);
        this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
        this.dropConversionLoot();
        if (!this.f_19853_.m_5776_()) {
            List<Player> players = HappyHolidaysUtils.findPlayersInRadius(this.f_19853_, this.m_20182_(), 5.0);
            for (Player player : players) {
                GingerbreadConversionEvent.ToDry turnDryEvent = new GingerbreadConversionEvent.ToDry(this, player, this.m_142538_());
                MinecraftForge.EVENT_BUS.post((Event)turnDryEvent);
            }
        }
    }
}

