/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.grinch;

import com.jumpcutfindo.happyholidays.common.block.christmas.presents.PresentBlock;
import com.jumpcutfindo.happyholidays.common.blockentity.christmas.star.ChristmasStarHelper;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceAction;
import com.jumpcutfindo.happyholidays.common.capabilities.christmas.NaughtyNiceMeter;
import com.jumpcutfindo.happyholidays.common.entity.christmas.IChristmasEntity;
import com.jumpcutfindo.happyholidays.common.entity.christmas.grinch.GrinchRewards;
import com.jumpcutfindo.happyholidays.common.events.christmas.GrinchEvent;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.gifts.ChristmasGiftItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasBlocks;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEffects;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasEntities;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasSounds;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GrinchEntity
extends PathfinderMob
implements IAnimatable,
IChristmasEntity {
    public static final EntityDataAccessor<Integer> BREAK_ANIM_PROGRESS = SynchedEntityData.m_135353_(GrinchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String ENTITY_ID = "grinch";
    public static final AttributeSupplier ENTITY_ATTRIBUTES = Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.21).m_22265_();
    public static final float ENTITY_BOX_SIZE = 0.5f;
    public static final float ENTITY_BOX_HEIGHT = 2.125f;
    public static final double GRINCH_SPAWN_CHANCE = 0.2;
    public static final int MAX_GRINCHES_IN_VICINITY = 3;
    private static final int BREAK_PRESENT_ANIM_DURATION = 80;
    private static final int BREAK_PRESENT_INTERVAL = 100;
    private static final float AVOID_PLAYER_RADIUS = 6.0f;
    private static final int GRINCH_TIME_TO_DESPAWN = 200;
    public static final int PRESENT_SEARCH_RADIUS = 8;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int[] presentsBrokenCount = new int[]{0, 0, 0};
    private int presentBreakingProgress = -1;
    private boolean hasReceivedGift = false;
    private boolean isHappyWithGift = false;
    private int despawnTimer = 200;
    private boolean isReadyToDespawn = false;

    public GrinchEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREAK_ANIM_PROGRESS, (Object)-1);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PickupGiftGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.5, livingEntity -> {
            Player playerEntity;
            if (this.hasReceivedGift) {
                return false;
            }
            return !(livingEntity instanceof Player) || !((playerEntity = (Player)livingEntity).m_21205_().m_41720_() instanceof ChristmasGiftItem) && !(playerEntity.m_21206_().m_41720_() instanceof ChristmasGiftItem);
        }));
        this.f_21345_.m_25352_(1, (Goal)new BreakPresentsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ChristmasSounds.GRINCH_PASSIVE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ChristmasSounds.GRINCH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ChristmasSounds.GRINCH_HURT.get();
    }

    public boolean isPlayerAround() {
        List playerEntityList = this.f_19853_.m_6443_(Player.class, this.m_142469_().m_82377_(6.0, 6.0, 6.0), player -> true);
        return playerEntityList.size() > 0;
    }

    public void beginPresentBreaking() {
        this.f_19804_.m_135381_(BREAK_ANIM_PROGRESS, (Object)80);
    }

    public void updatePresentBreaking(int progress) {
        this.f_19804_.m_135381_(BREAK_ANIM_PROGRESS, (Object)progress);
    }

    public void endPresentBreaking(BlockPos targetPresentBlock) {
        this.f_19804_.m_135381_(BREAK_ANIM_PROGRESS, (Object)-1);
        if (this.f_19853_.m_8055_(targetPresentBlock).m_60713_((Block)ChristmasBlocks.BABY_PRESENT.get())) {
            this.presentsBrokenCount[0] = this.presentsBrokenCount[0] + 1;
        } else if (this.f_19853_.m_8055_(targetPresentBlock).m_60713_((Block)ChristmasBlocks.ADULT_PRESENT.get())) {
            this.presentsBrokenCount[1] = this.presentsBrokenCount[1] + 1;
        } else {
            this.presentsBrokenCount[2] = this.presentsBrokenCount[2] + 1;
        }
        this.f_19853_.m_46961_(targetPresentBlock, false);
        this.f_19853_.m_5594_(null, targetPresentBlock, (SoundEvent)ChristmasSounds.GRINCH_BREAK_BOX.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public void handleGiftOnGround(ItemEntity itemEntity) {
        if (!this.hasReceivedGift) {
            CompoundTag itemTag = itemEntity.m_32055_().m_41783_();
            this.m_7938_((Entity)itemEntity, itemEntity.m_32055_().m_41613_());
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            if (itemTag != null && itemTag.m_128441_("Gifts")) {
                this.hasReceivedGift = true;
                this.isHappyWithGift = true;
                this.throwAppeasementRewards();
                if (itemEntity.m_32057_() != null) {
                    Player thrower = this.f_19853_.m_46003_(itemEntity.m_32057_());
                    NaughtyNiceMeter.evaluateAction(thrower, NaughtyNiceAction.APPEASE_GRINCH_EVENT);
                    MinecraftForge.EVENT_BUS.post((Event)new GrinchEvent.Appease(this, thrower));
                }
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.f_19796_.nextGaussian() * 0.02;
                    double d1 = this.f_19796_.nextGaussian() * 0.02;
                    double d2 = this.f_19796_.nextGaussian() * 0.02;
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
                }
                this.f_21344_.m_26519_(this.m_20185_() + this.f_19796_.nextDouble() * 32.0 + 128.0, this.m_20186_(), this.f_19796_.nextDouble() * 32.0 + 128.0, 2.0);
                this.isReadyToDespawn = true;
            } else {
                this.isHappyWithGift = false;
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.f_19796_.nextGaussian() * 0.02;
                    double d1 = this.f_19796_.nextGaussian() * 0.02;
                    double d2 = this.f_19796_.nextGaussian() * 0.02;
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
                }
                this.f_21344_.m_26519_(this.m_20185_() + this.f_19796_.nextDouble() * 64.0 + 128.0, this.m_20186_(), this.f_19796_.nextDouble() * 64.0 + 128.0, 2.0);
                this.isReadyToDespawn = true;
            }
        }
    }

    public void throwAppeasementRewards() {
        this.f_19853_.m_7967_((Entity)GrinchRewards.generateAppeasementXP(this.f_19853_, this.m_20182_()));
        LootContext ctx = this.m_7771_(false, DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
        GrinchRewards.generateRewards(this, ctx).forEach(arg_0 -> ((GrinchEntity)this).m_19983_(arg_0));
    }

    public void despawnGrinch() {
        if (!this.f_19853_.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            SimpleParticleType particleType = ParticleTypes.f_123759_;
            for (int i = 0; i < 5; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                serverWorld.m_8767_((ParticleOptions)particleType, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
            }
            serverWorld.m_5594_(null, this.m_142538_(), (SoundEvent)ChristmasSounds.GRINCH_DESPAWN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_()) {
            this.presentBreakingProgress = (Integer)this.f_19804_.m_135370_(BREAK_ANIM_PROGRESS);
        }
        if (this.isReadyToDespawn && this.f_19797_ % 3 == 0) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            SimpleParticleType particleType = this.isHappyWithGift ? ParticleTypes.f_123750_ : ParticleTypes.f_123792_;
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)particleType, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
        }
        if (this.isReadyToDespawn && --this.despawnTimer <= 0) {
            this.despawnGrinch();
        }
        if (!this.f_19853_.m_5776_() && this.f_19853_.m_46467_() % 60L == 0L) {
            List<Player> playersAround = HappyHolidaysUtils.findPlayersInRadius(this.f_19853_, this.m_20182_(), 6.0);
            for (Player playerEntity : playersAround) {
                MinecraftForge.EVENT_BUS.post((Event)new GrinchEvent.Encounter(this, playerEntity));
            }
        }
    }

    public int[] getPresentsBrokenCount() {
        return this.presentsBrokenCount;
    }

    public static boolean canSpawnInArea(BlockPos blockPos, ServerLevel serverWorld) {
        AABB searchBox = new AABB(blockPos).m_82400_(40.0);
        boolean isPlayerInVicinity = serverWorld.m_45976_(Player.class, searchBox).size() > 0;
        boolean isGrinchesAround = serverWorld.m_45976_(GrinchEntity.class, searchBox).size() > 3;
        return isPlayerInVicinity && !isGrinchesAround && serverWorld.m_46462_();
    }

    public static void spawnGrinchAround(BlockPos blockPos, ServerLevel serverWorld, Random random) {
        if (random.nextDouble() <= 0.2) {
            int randomX = random.nextInt(16) * (random.nextBoolean() ? -1 : 1);
            int randomY = 0;
            int randomZ = random.nextInt(16) * (random.nextBoolean() ? -1 : 1);
            GrinchEntity grinchEntity = (GrinchEntity)((EntityType)ChristmasEntities.GRINCH.get()).m_20615_((Level)serverWorld);
            BlockPos spawnPos = new BlockPos(blockPos.m_123341_() + randomX, blockPos.m_123342_() + randomY, blockPos.m_123343_() + randomZ);
            int count = 0;
            while (serverWorld.m_8055_(spawnPos).m_60828_((BlockGetter)serverWorld, spawnPos) && ++count <= 10) {
                spawnPos = spawnPos.m_7494_();
            }
            if (!serverWorld.m_8055_(spawnPos).m_60828_((BlockGetter)serverWorld, spawnPos)) {
                grinchEntity.m_6027_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
                serverWorld.m_7967_((Entity)grinchEntity);
            }
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128385_("PresentsBroken", this.presentsBrokenCount);
        nbt.m_128379_("HasReceivedGift", this.hasReceivedGift);
        nbt.m_128379_("IsReadyToDespawn", this.isReadyToDespawn);
        nbt.m_128405_("DespawnTimer", this.despawnTimer);
        nbt.m_128379_("IsHappyWithGift", this.isHappyWithGift);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        int[] tempArray = nbt.m_128465_("PresentsBroken");
        this.presentsBrokenCount = tempArray.length == 3 ? tempArray : new int[]{0, 0, 0};
        this.hasReceivedGift = nbt.m_128471_("HasReceivedGift");
        this.isReadyToDespawn = nbt.m_128471_("IsReadyToDespawn");
        int tempDespawnTimer = nbt.m_128451_("DespawnTimer");
        this.despawnTimer = tempDespawnTimer == 0 ? 200 : tempDespawnTimer;
        this.isHappyWithGift = nbt.m_128471_("IsHappyWithGift");
    }

    protected void m_7472_(DamageSource damageSource, int p_213333_2_, boolean p_213333_3_) {
        if (damageSource == DamageSource.f_19317_) {
            return;
        }
        ItemStack scraps = ((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).m_7968_();
        scraps.m_41764_(this.presentsBrokenCount[0] + this.presentsBrokenCount[1] + this.presentsBrokenCount[2]);
        this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), scraps));
    }

    private <E extends GrinchEntity> PlayState predicate(AnimationEvent<E> event) {
        if (this.presentBreakingProgress >= 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.break", Boolean.valueOf(false)));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private static class PickupGiftGoal
    extends Goal {
        private final GrinchEntity grinchEntity;
        private ItemEntity targetedEntity;

        public PickupGiftGoal(GrinchEntity grinchEntity) {
            this.grinchEntity = grinchEntity;
        }

        public boolean m_8036_() {
            if (this.grinchEntity.hasReceivedGift) {
                return false;
            }
            List nearbyEntities = this.grinchEntity.f_19853_.m_45976_(ItemEntity.class, this.grinchEntity.m_142469_().m_82377_(4.0, 4.0, 4.0));
            if (nearbyEntities.size() != 0) {
                for (ItemEntity entity : nearbyEntities) {
                    if (!(entity.m_32055_().m_41720_() instanceof ChristmasGiftItem)) continue;
                    this.targetedEntity = entity;
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            if (this.targetedEntity != null && this.targetedEntity.m_6084_()) {
                this.grinchEntity.m_21573_().m_5624_((Entity)this.targetedEntity, 1.0);
                if (this.targetedEntity.m_20280_((Entity)this.grinchEntity) < 2.0) {
                    this.grinchEntity.handleGiftOnGround(this.targetedEntity);
                }
            }
        }
    }

    private static class BreakPresentsGoal
    extends Goal {
        private static final float MOVE_TO_PRESENT_SPEED = 0.8f;
        private final GrinchEntity grinchEntity;
        private BlockPos targetPresentBlockPos = null;
        private int presentBreakingProgress = 80;
        private int timeLeftToNextSearch = 0;

        public BreakPresentsGoal(GrinchEntity grinchEntity) {
            this.grinchEntity = grinchEntity;
        }

        public boolean m_8036_() {
            if (this.grinchEntity.hasReceivedGift) {
                return false;
            }
            if (this.grinchEntity.m_21124_((MobEffect)ChristmasEffects.DEBUFF_OF_CHRISTMAS_EFFECT.get()) != null) {
                this.targetPresentBlockPos = null;
                this.resetPresentBreaking();
                return false;
            }
            if (!this.grinchEntity.isPlayerAround()) {
                return true;
            }
            this.targetPresentBlockPos = null;
            this.resetPresentBreaking();
            return false;
        }

        public void m_8037_() {
            if (this.targetPresentBlockPos == null && this.timeLeftToNextSearch == 0) {
                BlockPos startPos = this.grinchEntity.m_142538_();
                boolean isFound = false;
                block0: for (int y = -4; y < 4 && !isFound; ++y) {
                    int X = 16;
                    int Z = 16;
                    int x = 0;
                    int z = 0;
                    int dx = 0;
                    int dz = -1;
                    int t = Math.max(X, Z);
                    int maxI = t * t;
                    for (int i = 0; i < maxI; ++i) {
                        BlockPos currPos;
                        if (-X / 2 <= x && x <= X / 2 && -Z / 2 <= z && z <= Z / 2 && this.grinchEntity.f_19853_.m_8055_(currPos = startPos.m_142082_(x, y, z)).m_60734_() instanceof PresentBlock) {
                            if (ChristmasStarHelper.getStarInfluencingEntity(this.grinchEntity.f_19853_, new Vec3((double)currPos.m_123341_(), (double)currPos.m_123342_(), (double)currPos.m_123343_())) != null) continue;
                            this.targetPresentBlockPos = currPos;
                            this.presentBreakingProgress = 80;
                            isFound = true;
                            continue block0;
                        }
                        if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                            t = dx;
                            dx = -dz;
                            dz = t;
                        }
                        x += dx;
                        z += dz;
                    }
                }
            } else if (this.targetPresentBlockPos != null) {
                if (this.grinchEntity.f_19853_.m_46859_(this.targetPresentBlockPos)) {
                    this.targetPresentBlockPos = null;
                    this.grinchEntity.updatePresentBreaking(-1);
                    this.timeLeftToNextSearch = 100;
                } else {
                    int presentZ;
                    int presentY;
                    int presentX = this.targetPresentBlockPos.m_123341_();
                    if (this.grinchEntity.m_20275_(presentX, presentY = this.targetPresentBlockPos.m_123342_(), presentZ = this.targetPresentBlockPos.m_123343_()) > 3.0) {
                        this.grinchEntity.f_21344_.m_26519_((double)presentX, (double)presentY, (double)presentZ, (double)0.8f);
                        this.grinchEntity.f_21365_.m_24946_((double)presentX, (double)presentY, (double)presentZ);
                        if (this.grinchEntity.f_21344_.m_26577_()) {
                            this.grinchEntity.f_21343_.m_24901_();
                        }
                    } else {
                        if (this.presentBreakingProgress == 80) {
                            this.grinchEntity.beginPresentBreaking();
                        } else if (this.presentBreakingProgress == 0) {
                            this.grinchEntity.endPresentBreaking(this.targetPresentBlockPos);
                            this.targetPresentBlockPos = null;
                            this.timeLeftToNextSearch = 100;
                        } else {
                            this.grinchEntity.updatePresentBreaking(this.presentBreakingProgress);
                        }
                        --this.presentBreakingProgress;
                    }
                }
            }
            if (this.timeLeftToNextSearch > 0) {
                --this.timeLeftToNextSearch;
            }
        }

        private void resetPresentBreaking() {
            this.presentBreakingProgress = 80;
            this.grinchEntity.updatePresentBreaking(-1);
        }
    }
}

