/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.entity.christmas.grinch;

import com.jumpcutfindo.happyholidays.common.entity.christmas.ChristmasRewards;
import com.jumpcutfindo.happyholidays.common.entity.christmas.grinch.GrinchEntity;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasBlockItem;
import com.jumpcutfindo.happyholidays.common.item.christmas.ChristmasItem;
import com.jumpcutfindo.happyholidays.common.registry.christmas.ChristmasItems;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class GrinchRewards {
    private static final ResourceLocation GRINCH_APPEASEMENT_LOOT_TABLE = new ResourceLocation("happyholidays:entities/grinch_appeasement");
    public static final double APPEASEMENT_REWARD_MODIFIER_STEP = 0.1;
    public static final double APPEASEMENT_ORNAMENT_DROP_BASE_CHANCE = 0.2;
    public static final int APPEASEMENT_EXPERIENCE = 50;

    public static ExperienceOrb generateAppeasementXP(Level level, Vec3 pos) {
        return new ExperienceOrb(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 50);
    }

    public static List<ItemStack> generateRewards(GrinchEntity grinchEntity, LootContext lootContext) {
        Level level = grinchEntity.f_19853_;
        double modifier = ChristmasRewards.computeDropModifier(grinchEntity.f_19853_, grinchEntity.m_20182_(), 0.1);
        ItemStack presentScraps = GrinchRewards.computePresentScraps(grinchEntity.getPresentsBrokenCount());
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(GRINCH_APPEASEMENT_LOOT_TABLE);
        List<ItemStack> loot = GrinchRewards.generateLoot(lootTable, lootContext, modifier, grinchEntity.m_21187_());
        ItemStack legendaryOrnament = GrinchRewards.generateOrnament(modifier, grinchEntity.m_21187_());
        loot.add(presentScraps);
        loot.add(legendaryOrnament);
        return loot;
    }

    private static ItemStack computePresentScraps(int[] presentsBrokenCount) {
        ItemStack scraps = ((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).m_7968_();
        scraps.m_41764_(presentsBrokenCount[0] + presentsBrokenCount[1] * 2 + presentsBrokenCount[2] * 3);
        return scraps;
    }

    private static List<ItemStack> generateLoot(LootTable lootTable, LootContext ctx, double modifier, Random random) {
        List loot = lootTable.m_79129_(ctx);
        loot.forEach(itemStack -> {
            if (ChristmasItems.isBasicOrnamentItem(itemStack)) {
                itemStack.m_41764_(random.nextInt(4) + 1 + 8);
            } else if (ChristmasItems.isRareOrnamentItem(itemStack)) {
                itemStack.m_41764_(random.nextInt(2) + 1 + 2);
            } else if (ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)((ChristmasItem)ChristmasItems.PRESENT_SCRAPS.get()).m_7968_())) {
                itemStack.m_41764_(random.nextInt(6) + 1 + 6);
            } else if (ChristmasItems.isFoodItem(itemStack)) {
                if (ChristmasItems.isLargeFoodItem(itemStack)) {
                    itemStack.m_41764_(random.nextInt(2) + 1 + 2);
                } else {
                    itemStack.m_41764_(random.nextInt(6) + 1 + 6);
                }
            }
            if (!ChristmasRewards.isTool(itemStack)) {
                itemStack.m_41764_((int)((double)itemStack.m_41613_() * modifier));
            }
        });
        return loot;
    }

    private static ItemStack generateOrnament(double modifier, Random random) {
        double ornamentDropChance = 0.2 * modifier;
        if (random.nextDouble() <= ornamentDropChance) {
            return ((ChristmasBlockItem)ChristmasItems.GRINCH_ORNAMENT.get()).m_7968_();
        }
        return ItemStack.f_41583_;
    }
}

